/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseDamageCloud;
import io.github.flemmli97.runecraftory.common.particles.DurationalParticleData;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.common.entity.EntityProjectile;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import java.util.function.Consumer;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;

public class EntityStatusBall
extends BaseDamageCloud {
    private static final class_2940<Integer> TYPE_DATA = class_2945.method_12791(EntityStatusBall.class, (class_2941)class_2943.field_13327);
    private Type type = Type.SLEEP;
    private int maxLivingTicks;

    public EntityStatusBall(class_1299<? extends EntityStatusBall> type, class_1937 world) {
        super(type, world);
    }

    public EntityStatusBall(class_1937 world, class_1309 shooter) {
        super((class_1299<? extends BaseDamageCloud>)((class_1299)ModEntities.STATUS_BALL.get()), world, shooter);
        this.method_5814(shooter.method_23317(), shooter.method_23318(), shooter.method_23321());
    }

    public int livingTickMax() {
        return this.maxLivingTicks;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TYPE_DATA, (Object)0);
    }

    public void setType(Type type) {
        this.type = type;
        this.field_6011.method_12778(TYPE_DATA, (Object)this.type.ordinal());
        this.maxLivingTicks = this.type.maxLivingTicks;
    }

    public void setLivingTicksMax(int ticks) {
        this.maxLivingTicks = ticks;
    }

    public void method_5674(class_2940<?> key) {
        int id;
        super.method_5674(key);
        if (key == TYPE_DATA && (id = ((Integer)this.field_6011.method_12789(TYPE_DATA)).intValue()) >= 0 && id < Type.values().length) {
            this.type = Type.values()[id];
        }
    }

    public void shootAtPos(class_243 targetPos, float velocity, float inaccuracy) {
        class_243 dir = new class_243(targetPos.method_10216() - this.method_23317(), targetPos.method_10214() - this.method_23318(), targetPos.method_10215() - this.method_23321());
        this.shoot(dir.field_1352, dir.field_1351, dir.field_1350, velocity, inaccuracy);
    }

    public void shootFromRotation(class_1297 shooter, float pitch, float yaw, float pitchOffset, float velocity, float inaccuracy) {
        float f = -class_3532.method_15374((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        float g = -class_3532.method_15374((float)((pitch + pitchOffset) * ((float)Math.PI / 180)));
        float h = class_3532.method_15362((float)(yaw * ((float)Math.PI / 180))) * class_3532.method_15362((float)(pitch * ((float)Math.PI / 180)));
        this.shoot(f, g, h, velocity, inaccuracy);
        class_243 vec3 = shooter.method_18798();
        this.method_18799(this.method_18798().method_1031(vec3.field_1352, shooter.method_24828() ? 0.0 : vec3.field_1351, vec3.field_1350));
    }

    public void shoot(double x, double y, double z, float velocity, float inaccuracy) {
        class_243 vector3d = new class_243(x, y, z).method_1029().method_1031(this.field_5974.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_5974.nextGaussian() * (double)0.0075f * (double)inaccuracy, this.field_5974.nextGaussian() * (double)0.0075f * (double)inaccuracy).method_1021((double)velocity);
        this.method_18799(vector3d);
        double f = Math.sqrt(EntityProjectile.horizontalMag((class_243)vector3d));
        this.method_36456((float)(class_3532.method_15349((double)vector3d.field_1352, (double)vector3d.field_1350) * 57.2957763671875));
        this.method_36457((float)(class_3532.method_15349((double)vector3d.field_1351, (double)f) * 57.2957763671875));
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
    }

    public void method_5773() {
        super.method_5773();
        if (this.field_6002.field_9236) {
            switch (this.type) {
                case SLEEP: 
                case PARALYSIS: 
                case MUSHROOM_POISON: {
                    class_1160 color;
                    int i;
                    for (i = 0; i < 2; ++i) {
                        color = this.type.particleColor;
                        this.field_6002.method_8406((class_2394)new ColoredParticleData((class_2396)ModParticles.LIGHT.get(), color.method_4943(), color.method_4945(), color.method_4947(), 1.0f, 2.0f), this.method_23317() + this.field_5974.nextGaussian() * 0.15, this.method_23318() + 0.35 + this.field_5974.nextGaussian() * 0.07, this.method_23321() + this.field_5974.nextGaussian() * 0.15, this.field_5974.nextGaussian() * 0.01, Math.abs(this.field_5974.nextGaussian() * 0.03), this.field_5974.nextGaussian() * 0.01);
                    }
                    break;
                }
                case RAFFLESIA_SLEEP: 
                case RAFFLESIA_PARALYSIS: 
                case RAFFLESIA_POISON: 
                case RAFFLESIA_ALL: {
                    class_1160 color;
                    int i;
                    for (i = 0; i < 2; ++i) {
                        color = this.type.particleColor;
                        this.field_6002.method_8406((class_2394)new DurationalParticleData(color.method_4943(), color.method_4945(), color.method_4947(), 0.8f, 2.5f, 3), this.method_23317() + this.field_5974.nextGaussian() * 0.15, this.method_23318() + 0.35 + this.field_5974.nextGaussian() * 0.07, this.method_23321() + this.field_5974.nextGaussian() * 0.15, 0.0, 0.0, 0.0);
                    }
                    break;
                }
            }
        }
        class_243 motion = this.method_18798();
        double newX = this.method_23317() + motion.field_1352;
        double newY = this.method_23318() + motion.field_1351;
        double newZ = this.method_23321() + motion.field_1350;
        this.method_5814(newX, newY, newZ);
    }

    protected boolean damageEntity(class_1309 target) {
        CustomDamage.Builder builder = new CustomDamage.Builder((class_1297)this, this.method_35057()).noKnockback();
        this.type.damageMod.accept(builder);
        if (CombatUtils.damageWithFaintAndCrit(this.method_35057(), (class_1297)target, builder, CombatUtils.getAttributeValue(this.method_35057(), (class_1320)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null)) {
            this.method_31472();
            return true;
        }
        return false;
    }

    protected class_238 damageBoundingBox() {
        return this.method_5829().method_1009(0.3, 0.45, 0.3);
    }

    @Override
    protected void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("StatusType", this.type.ordinal());
        compound.method_10569("MaxTicks", this.maxLivingTicks);
    }

    @Override
    protected void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.type = Type.values()[compound.method_10550("StatusType")];
        this.maxLivingTicks = compound.method_10550("MaxTicks");
    }

    public static enum Type {
        SLEEP(b -> b.magic().element(EnumElement.EARTH).withChangedAttribute((class_1320)ModAttributes.SLEEP.get(), 100.0), new class_1160(0.8117647f, 0.050980393f, 0.14901961f), 40),
        MUSHROOM_POISON(b -> b.magic().withChangedAttribute((class_1320)ModAttributes.POISON.get(), 50.0), new class_1160(0.4392157f, 0.7882353f, 0.37254903f), 40),
        PARALYSIS(b -> b.magic().withChangedAttribute((class_1320)ModAttributes.PARA.get(), 50.0), new class_1160(0.76862746f, 0.7294118f, 0.13725491f), 40),
        RAFFLESIA_SLEEP(b -> b.hurtResistant(2).magic().withChangedAttribute((class_1320)ModAttributes.SLEEP.get(), 10.0).withChangedAttribute((class_1320)ModAttributes.FATIGUE.get(), 2.0).withChangedAttribute((class_1320)ModAttributes.COLD.get(), 2.0), new class_1160(0.8117647f, 0.050980393f, 0.14901961f), 30),
        RAFFLESIA_PARALYSIS(b -> b.hurtResistant(2).magic().withChangedAttribute((class_1320)ModAttributes.PARA.get(), 7.0).withChangedAttribute((class_1320)ModAttributes.FATIGUE.get(), 2.0).withChangedAttribute((class_1320)ModAttributes.COLD.get(), 2.0), new class_1160(0.8f, 0.74509805f, 0.22352941f), 30),
        RAFFLESIA_POISON(b -> b.hurtResistant(2).magic().withChangedAttribute((class_1320)ModAttributes.POISON.get(), 7.0).withChangedAttribute((class_1320)ModAttributes.FATIGUE.get(), 2.0).withChangedAttribute((class_1320)ModAttributes.COLD.get(), 2.0), new class_1160(0.72156864f, 0.21960784f, 0.81960785f), 30),
        RAFFLESIA_ALL(b -> b.hurtResistant(2).magic().withChangedAttribute((class_1320)ModAttributes.SLEEP.get(), 5.0).withChangedAttribute((class_1320)ModAttributes.PARA.get(), 5.0).withChangedAttribute((class_1320)ModAttributes.POISON.get(), 5.0), new class_1160(0.5294118f, 0.09019608f, 0.11372549f), 30);

        public final Consumer<CustomDamage.Builder> damageMod;
        public final class_1160 particleColor;
        public final int maxLivingTicks;

        private Type(Consumer<CustomDamage.Builder> damageMod, class_1160 particleColor, int maxLivingTicks) {
            this.damageMod = damageMod;
            this.particleColor = particleColor;
            this.maxLivingTicks = maxLivingTicks;
        }
    }
}

