/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumSkills;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.LootTableResources;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_47;
import net.minecraft.class_52;

public class EntityTreasureChest
extends class_1297
implements IAnimated {
    public static final int MAX_TIER = 4;
    private static final class_2940<Integer> TIER = class_2945.method_12791(EntityTreasureChest.class, (class_2941)class_2943.field_13327);
    private static final AnimatedAction OPEN = AnimatedAction.builder((double)0.32, (String)"open").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{OPEN};
    private final AnimationHandler<EntityTreasureChest> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    protected class_1657 lastHurtByPlayer;
    private class_2960 chestLoot;
    private Runnable openChest;

    public EntityTreasureChest(class_1299<? extends EntityTreasureChest> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5693() {
        this.field_6011.method_12784(TIER, (Object)0);
    }

    public void method_5670() {
        super.method_5670();
        this.getAnimationHandler().tick();
        AnimatedAction anim = this.getAnimationHandler().getAnimation();
        if (!this.method_31481() && !this.field_6002.field_9236 && anim != null && anim.is(new AnimatedAction[]{OPEN}) && anim.done(0)) {
            if (this.openChest != null) {
                this.openChest.run();
            }
            this.method_31472();
        }
        if (!this.method_5740()) {
            this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
        }
        this.method_5784(class_1313.field_6308, this.method_18798());
        double friction = 0.98;
        if (this.field_5952) {
            friction = this.field_6002.method_8320(new class_2338(this.method_23317(), this.method_23318() - 1.0, this.method_23321())).method_26204().method_9499() * 0.98f;
        }
        this.method_18799(this.method_18798().method_18805(friction, 0.98, friction));
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.tier() == 4 && source != class_1282.field_5849) {
            return false;
        }
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player;
            this.lastHurtByPlayer = player = (class_1657)class_12972;
        }
        if (!this.field_6002.field_9236) {
            this.method_31472();
            this.dropFromLootTable(source, true);
        }
        for (int i = 0; i < 20; ++i) {
            double d0 = this.field_5974.nextGaussian() * 0.02;
            double d1 = this.field_5974.nextGaussian() * 0.02;
            double d2 = this.field_5974.nextGaussian() * 0.02;
            this.field_6002.method_8406((class_2394)class_2398.field_11203, this.method_23322(1.0), this.method_23319(), this.method_23325(1.0), d0, d1, d2);
        }
        return true;
    }

    public boolean method_5863() {
        return true;
    }

    protected void method_5749(class_2487 compound) {
        this.setTier(compound.method_10550("ChestTier"));
        if (compound.method_10545("ChestLoot")) {
            this.chestLoot = new class_2960(compound.method_10558("ChestLoot"));
        }
    }

    protected void method_5652(class_2487 compound) {
        compound.method_10569("ChestTier", ((Integer)this.field_6011.method_12789(TIER)).intValue());
        if (this.chestLoot != null) {
            compound.method_10582("ChestLoot", this.chestLoot.toString());
        }
    }

    public void setChestLoot(class_2960 loot) {
        this.chestLoot = loot;
        this.setTier(4);
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (!this.getAnimationHandler().isCurrent(new AnimatedAction[]{OPEN})) {
                this.getAnimationHandler().setAnimation(OPEN);
                this.method_5783(class_3417.field_14982, 0.7f, 1.0f);
                this.openChest = () -> this.openChest(serverPlayer, serverPlayer.method_5998(hand));
                Platform.INSTANCE.getPlayerData(player).ifPresent(data -> LevelCalc.levelSkill(serverPlayer, data, EnumSkills.SEARCHING, 20.0f));
            }
        }
        return class_1269.field_21466;
    }

    public boolean method_30948() {
        return true;
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    public class_1799 method_31480() {
        return SpawnEgg.fromType((class_1299)this.method_5864()).map(class_1799::new).orElse(class_1799.field_8037);
    }

    public void setTier(int tier) {
        this.field_6011.method_12778(TIER, (Object)class_3532.method_15340((int)tier, (int)0, (int)4));
    }

    public int tier() {
        return (Integer)this.field_6011.method_12789(TIER);
    }

    protected void openChest(class_3222 player, class_1799 stack) {
        class_2960 class_29602;
        if (this.chestLoot != null) {
            class_29602 = this.chestLoot;
        } else {
            switch (this.tier()) {
                case 1: {
                    class_29602 = LootTableResources.TIER_2_LOOT;
                    break;
                }
                case 2: {
                    class_29602 = LootTableResources.TIER_3_LOOT;
                    break;
                }
                case 3: {
                    class_29602 = LootTableResources.TIER_4_LOOT;
                    break;
                }
                default: {
                    class_29602 = LootTableResources.TIER_1_LOOT;
                }
            }
        }
        class_2960 resourceLocation = class_29602;
        class_47.class_48 builder = new class_47.class_48((class_3218)this.field_6002).method_311(this.field_5974).method_303(player.method_7292()).method_312(class_181.field_1226, (Object)this).method_312(class_181.field_24424, (Object)this.method_19538()).method_312(LootCtxParameters.UUID_CONTEXT, (Object)player.method_5667()).method_312(class_181.field_1229, (Object)stack);
        class_52 lootTable = this.field_6002.method_8503().method_3857().method_367(resourceLocation);
        lootTable.method_320(builder.method_309(LootCtxParameters.MONSTER_INTERACTION), arg_0 -> ((EntityTreasureChest)this).method_5775(arg_0));
    }

    protected void dropFromLootTable(class_1282 damageSource, boolean attackedRecently) {
        class_2960 resourceLocation = this.method_5864().method_16351();
        class_52 lootTable = this.field_6002.method_8503().method_3857().method_367(resourceLocation);
        class_47.class_48 builder = this.createLootContext(attackedRecently, damageSource);
        lootTable.method_320(builder.method_309(class_173.field_1173), arg_0 -> ((EntityTreasureChest)this).method_5775(arg_0));
    }

    protected class_47.class_48 createLootContext(boolean attackedRecently, class_1282 damageSource) {
        class_47.class_48 builder = new class_47.class_48((class_3218)this.field_6002).method_311(this.field_5974).method_312(class_181.field_1226, (Object)this).method_312(class_181.field_24424, (Object)this.method_19538()).method_312(class_181.field_1231, (Object)damageSource).method_306(class_181.field_1230, (Object)damageSource.method_5529()).method_306(class_181.field_1227, (Object)damageSource.method_5526());
        if (attackedRecently && this.lastHurtByPlayer != null) {
            builder = builder.method_312(class_181.field_1233, (Object)this.lastHurtByPlayer).method_303(this.lastHurtByPlayer.method_7292());
        }
        return builder;
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }
}

