/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseBeam;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3966;

public class EntityWaterLaser
extends BaseBeam {
    private static final class_2940<Float> YAW_MOTION_VAL = class_2945.method_12791(EntityWaterLaser.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> MAX_LIVING_TICK = class_2945.method_12791(EntityWaterLaser.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> YAW_OFFSET = class_2945.method_12791(EntityWaterLaser.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> POSITION_YAW_OFFSET = class_2945.method_12791(EntityWaterLaser.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> RANGE = class_2945.method_12791(EntityWaterLaser.class, (class_2941)class_2943.field_13320);
    private final Object2IntMap<class_1297> hitEntities = new Object2IntOpenHashMap();
    private float accumulatedRot;
    private UUID other;

    public EntityWaterLaser(class_1299<? extends EntityWaterLaser> type, class_1937 level) {
        super(type, level);
    }

    public EntityWaterLaser(class_1937 level, class_1309 shooter) {
        super((class_1299<? extends BaseBeam>)((class_1299)ModEntities.WATER_LASER.get()), level, shooter);
    }

    public EntityWaterLaser(class_1937 level, class_1309 shooter, float yawMotion) {
        super((class_1299<? extends BaseBeam>)((class_1299)ModEntities.WATER_LASER.get()), level, shooter);
        this.field_6011.method_12778(YAW_MOTION_VAL, (Object)Float.valueOf(yawMotion));
    }

    public void setRotationToDirWithOffset(double dirX, double dirY, double dirZ, float acc, float yawOffset) {
        super.setRotationToDir(dirX, dirY, dirZ, acc);
        this.method_36456(this.method_36454() + yawOffset);
    }

    public EntityWaterLaser setMaxTicks(int ticks) {
        this.field_6011.method_12778(MAX_LIVING_TICK, (Object)ticks);
        return this;
    }

    public void setYawOffset(float offset) {
        this.field_6011.method_12778(YAW_OFFSET, (Object)Float.valueOf(offset));
    }

    public void setPositionYawOffset(float offset) {
        this.field_6011.method_12778(POSITION_YAW_OFFSET, (Object)Float.valueOf(offset));
    }

    public void setTwinId(UUID other) {
        this.other = other;
    }

    public void setRange(float range) {
        this.field_6011.method_12778(RANGE, (Object)Float.valueOf(range));
    }

    public float getRange() {
        return ((Float)this.field_6011.method_12789(RANGE)).floatValue();
    }

    public float radius() {
        return 0.4f;
    }

    public boolean piercing() {
        return true;
    }

    public int livingTickMax() {
        return (Integer)this.field_6011.method_12789(MAX_LIVING_TICK);
    }

    public void updateYawPitch() {
        if (this.getHitVecFromShooter() && this.method_35057() != null) {
            class_1297 e = this.method_35057();
            float yRot = this.method_36454();
            float xRot = this.method_36455();
            this.method_36457(e.method_36455());
            this.method_36456(e.method_36454() + ((Float)this.field_6011.method_12789(YAW_OFFSET)).floatValue());
            this.field_6004 = e.field_6004;
            this.field_5982 = e.field_5982 + ((Float)this.field_6011.method_12789(YAW_OFFSET)).floatValue();
            class_1160 vec = RayTraceUtils.rotatedAround((class_243)e.method_5720(), (class_1160)class_1160.field_20705, (float)((Float)this.field_6011.method_12789(POSITION_YAW_OFFSET)).floatValue());
            this.method_5814(e.method_23317() + (double)vec.method_4943(), e.method_23318() + (double)e.method_5751() - (double)0.1f + (double)vec.method_4945(), e.method_23321() + (double)vec.method_4947());
            this.accumulatedRot += Math.abs(this.method_36454() - yRot) + Math.abs(this.method_36455() - xRot);
        }
    }

    public boolean getHitVecFromShooter() {
        return this.method_35057() instanceof class_1657;
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(YAW_MOTION_VAL, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(MAX_LIVING_TICK, (Object)20);
        this.field_6011.method_12784(YAW_OFFSET, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(POSITION_YAW_OFFSET, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(RANGE, (Object)Float.valueOf(9.0f));
    }

    public void method_5773() {
        class_3222 player;
        boolean keep;
        class_1297 class_12972;
        float yRot = this.method_36454();
        if (((Float)this.field_6011.method_12789(YAW_MOTION_VAL)).floatValue() != 0.0f) {
            this.method_36456(this.method_36454() + ((Float)this.field_6011.method_12789(YAW_MOTION_VAL)).floatValue());
            this.hit = null;
        }
        if (this.accumulatedRot > 15.0f) {
            this.hitEntities.clear();
            this.accumulatedRot = 0.0f;
        }
        super.method_5773();
        if (((Float)this.field_6011.method_12789(YAW_MOTION_VAL)).floatValue() != 0.0f) {
            this.field_5982 = yRot;
        }
        if ((class_12972 = this.method_35057()) instanceof class_3222 && !(keep = Platform.INSTANCE.getPlayerData((class_1657)(player = (class_3222)class_12972)).map(d -> {
            AnimatedAction action = d.getWeaponHandler().getAnimation();
            return action != null && action.is(new AnimatedAction[]{PlayerModelAnimations.WATER_LASER_ONE, PlayerModelAnimations.WATER_LASER_TWO, PlayerModelAnimations.WATER_LASER_THREE});
        }).orElse(false).booleanValue()) && this.field_6012 < this.livingTickMax() - 5) {
            this.field_6011.method_12778(MAX_LIVING_TICK, (Object)(this.field_6012 + 5));
        }
    }

    public void onImpact(class_3966 res) {
        class_1309 living;
        class_1297 e = res.method_17782();
        int invul_time = 5;
        if (e instanceof class_1309 && (living = (class_1309)e).method_6081() != null && living.method_6081().method_5526() != null && living.method_6081().method_5526().method_5667().equals(this.other)) {
            invul_time = 0;
        }
        CombatUtils.damageWithFaintAndCrit(this.method_35057(), e, new CustomDamage.Builder((class_1297)this, this.method_35057()).hurtResistant(invul_time).magic().noKnockback().element(EnumElement.WATER), CombatUtils.getAttributeValue(this.method_35057(), (class_1320)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null);
        this.hitEntities.put((Object)e, this.field_6012);
    }

    @Override
    protected boolean check(class_1297 e, Predicate<class_238> intersects) {
        if (this.field_6012 - this.hitEntities.getOrDefault((Object)e, this.field_6012 - 20) <= 19) {
            return false;
        }
        return super.check(e, intersects);
    }

    public boolean canStartDamage() {
        return true;
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(YAW_OFFSET, (Object)Float.valueOf(compound.method_10583("YawOffset")));
        this.field_6011.method_12778(RANGE, (Object)Float.valueOf(compound.method_10583("Range")));
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10548("YawOffset", ((Float)this.field_6011.method_12789(YAW_OFFSET)).floatValue());
        compound.method_10548("Float", ((Float)this.field_6011.method_12789(RANGE)).floatValue());
    }
}

