/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.misc;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.common.entities.misc.BaseProjectile;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.platform.EventCalls;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2643;
import net.minecraft.class_2680;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6025;

public class EntityWindBlade
extends BaseProjectile {
    private class_1297 target;
    private Type type = Type.HOMING;

    public EntityWindBlade(class_1299<? extends EntityWindBlade> type, class_1937 world) {
        super(type, world);
    }

    public EntityWindBlade(class_1937 world, class_1309 shooter) {
        super((class_1299<? extends BaseProjectile>)((class_1299)ModEntities.WIND_BLADE.get()), world, shooter);
    }

    public void setTarget(class_1297 entity) {
        this.target = entity;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public boolean isPiercing() {
        return this.type == Type.PIERCING;
    }

    public int livingTickMax() {
        return this.isPiercing() ? 60 : 30;
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            if (!(this.target != null && this.target.method_5805() || this.type != Type.HOMING)) {
                List list = this.field_6002.method_8333((class_1297)this, this.method_5829().method_1014(16.0).method_18804(this.method_18798()), e -> {
                    class_6025 ownable;
                    if (!e.method_5863() || !e.method_5732()) {
                        return false;
                    }
                    if (e.equals((Object)this.method_24921()) || e instanceof class_6025 && (ownable = (class_6025)e).method_35057() == this.method_24921()) {
                        return false;
                    }
                    return this.canHit((class_1297)e);
                });
                double distSq = Double.MAX_VALUE;
                class_1297 res = null;
                for (class_1297 e2 : list) {
                    if (!(e2.method_5858((class_1297)this) < distSq)) continue;
                    res = e2;
                }
                if (res != null) {
                    this.target = res;
                }
            }
            if (this.target != null) {
                class_243 dir = this.target.method_33571().method_1020(this.method_19538()).method_1029().method_1021(0.1);
                this.method_18799(this.method_18798().method_1021(0.95).method_1019(dir));
            }
        }
    }

    protected float getGravityVelocity() {
        return 0.0f;
    }

    protected boolean entityRayTraceHit(class_3966 result) {
        if (CombatUtils.damageWithFaintAndCrit(this.method_24921(), result.method_17782(), new CustomDamage.Builder((class_1297)this, this.method_24921()).magic().noKnockback().hurtResistant(this.type == Type.PLAIN ? 2 : 10).element(EnumElement.WIND).projectile(), CombatUtils.getAttributeValue(this.method_24921(), (class_1320)ModAttributes.MAGIC.get()) * (double)this.damageMultiplier, null)) {
            if (!this.isPiercing()) {
                this.method_31472();
            }
            return true;
        }
        return false;
    }

    protected void onBlockHit(class_3965 blockRayTraceResult) {
        if (!this.isPiercing()) {
            this.method_31472();
        } else {
            class_243 mot = this.method_18798();
            class_243 newMot = switch (blockRayTraceResult.method_17780()) {
                case class_2350.field_11033, class_2350.field_11036 -> new class_243(mot.method_10216(), -mot.method_10214(), mot.method_10215());
                case class_2350.field_11039, class_2350.field_11034 -> new class_243(-mot.method_10216(), mot.method_10214(), mot.method_10215());
                default -> new class_243(mot.method_10216(), mot.method_10214(), -mot.method_10215());
            };
            if (!blockRayTraceResult.method_17781()) {
                this.method_33574(blockRayTraceResult.method_17784());
            }
            this.method_18799(newMot);
            this.doBlockCollision();
        }
    }

    private void doBlockCollision() {
        class_243 to;
        class_243 pos = this.method_19538();
        class_3965 raytraceresult = this.field_6002.method_17742(new class_3959(pos, to = pos.method_1019(this.method_18798()), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        if (raytraceresult.method_17783() == class_239.class_240.field_1332) {
            class_2338 blockpos = raytraceresult.method_17777();
            class_2680 blockstate = this.field_6002.method_8320(blockpos);
            if (blockstate.method_27852(class_2246.field_10316)) {
                this.method_5717(blockpos);
            } else if (blockstate.method_27852(class_2246.field_10613)) {
                class_2586 tileentity = this.field_6002.method_8321(blockpos);
                if (tileentity instanceof class_2643 && class_2643.method_30276((class_1297)this)) {
                    class_2643.method_11409((class_1937)this.field_6002, (class_2338)blockpos, (class_2680)blockstate, (class_1297)this, (class_2643)((class_2643)tileentity));
                }
            } else if (!EventCalls.INSTANCE.projectileHitCall((class_1676)this, (class_239)raytraceresult)) {
                this.onBlockHit(raytraceresult);
            }
        }
    }

    public static enum Type {
        PLAIN,
        HOMING,
        PIERCING;

    }
}

