/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.ChargeAction;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntityBuffamoo
extends ChargingMonster {
    public static final AnimatedAction CHARGE_ATTACK = AnimatedAction.builder((double)2.2, (String)"charge").marker("attack_start", new double[]{0.72}).marker("attack_end", new double[]{1.92}).build();
    public static final AnimatedAction STAMP = AnimatedAction.builder((double)0.48, (String)"stamp").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)STAMP, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{STAMP, CHARGE_ATTACK, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityBuffamoo>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(STAMP, e -> 1.0f), (int)1), class_6008.method_34980((Object)new GoalAttackAction(CHARGE_ATTACK).cooldown(e -> e.animationCooldown(CHARGE_ATTACK)).prepare(ChargeAction::new), (int)1));
    private static final List<class_6008.class_6010<IdleAction<EntityBuffamoo>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(8.0, 4)), (int)2), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new), (int)2));
    public final AnimatedAttackGoal<EntityBuffamoo> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityBuffamoo> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityBuffamoo(class_1299<? extends EntityBuffamoo> type, class_1937 world) {
        super((class_1299<? extends ChargingMonster>)type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.2);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 1.8;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CHARGE_ATTACK);
            } else {
                this.getAnimationHandler().setAnimation(STAMP);
            }
        }
    }

    @Override
    protected boolean isChargingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{CHARGE_ATTACK});
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_14597;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14857;
    }

    public float method_6017() {
        return (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 0.7f;
    }

    public AnimationHandler<EntityBuffamoo> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public CustomDamage.Builder damageSourceAttack() {
        CustomDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE_ATTACK})) {
            source.knock(CustomDamage.KnockBackType.BACK).knockAmount(2.0f);
        } else if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{STAMP})) {
            source.withChangedAttribute((class_1320)ModAttributes.STUN.get(), 20.0);
        }
        return source;
    }

    @Override
    public void doWhileCharge() {
        if (this.field_6012 % 3 == 0) {
            this.field_6002.method_8396(null, this.method_24515(), class_3417.field_15110, this.method_5634(), 1.0f, this.method_6051().nextFloat() * 0.2f);
        }
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    @Override
    public double chargingSpeed() {
        return 0.28f;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.4375, -0.125);
    }
}

