/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.ChargeAction;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_6008;

public class EntityChipsqueek
extends ChargingMonster {
    public static final AnimatedAction MELEE = AnimatedAction.builder((double)0.44, (String)"tail_slap").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction ROLL = AnimatedAction.builder((double)0.56, (String)"roll").marker("attack_start", new double[]{0.2}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, ROLL, MELEE, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityChipsqueek>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(MELEE, e -> 1.0f), (int)1), class_6008.method_34980((Object)new GoalAttackAction(ROLL).cooldown(e -> e.animationCooldown(ROLL)).prepare(ChargeAction::new), (int)1));
    private static final List<class_6008.class_6010<IdleAction<EntityChipsqueek>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(8.0, 4)), (int)3), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new), (int)2));
    public final AnimatedAttackGoal<EntityChipsqueek> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityChipsqueek> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityChipsqueek(class_1299<? extends EntityChipsqueek> type, class_1937 world) {
        super((class_1299<? extends ChargingMonster>)type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModSounds.ENTITY_CHIPSQUEEK_HURT.get();
    }

    @Override
    protected boolean isChargingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{ROLL});
    }

    @Override
    public double chargingSpeed() {
        return 0.45f;
    }

    public AnimationHandler<EntityChipsqueek> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 2.3;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(ROLL);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.59375, -0.3125);
    }
}

