/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.ElementalAttackMob;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1569;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_6008;
import net.minecraft.class_6025;

public class EntityDemon
extends BaseMonster
implements HealingPredicateEntity,
ElementalAttackMob {
    public static final AnimatedAction DARK = AnimatedAction.builder((double)0.88, (String)"cast").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction HEAL = AnimatedAction.copyOf((AnimatedAction)DARK, (String)"heal");
    public static final AnimatedAction STAB = AnimatedAction.builder((double)0.68, (String)"stab").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction STAB_LONG = AnimatedAction.builder((double)0.8, (String)"stab_long").marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction SWIPE = AnimatedAction.builder((double)0.88, (String)"swipe").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)DARK, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{DARK, HEAL, STAB, STAB_LONG, SWIPE, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityDemon>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(STAB, e -> 1.0f), (int)3), class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(STAB_LONG, e -> 1.0f), (int)3), class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(SWIPE, e -> 1.0f), (int)3), class_6008.method_34980((Object)new GoalAttackAction(DARK).cooldown(e -> e.animationCooldown(DARK)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)2), class_6008.method_34980((Object)new GoalAttackAction(HEAL).cooldown(e -> e.animationCooldown(HEAL)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)1));
    private static final List<class_6008.class_6010<IdleAction<EntityDemon>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)1));
    public final AnimatedAttackGoal<EntityDemon> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityDemon> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private final Predicate<class_1309> healingPredicate = e -> {
        if (this.method_6139() == null) {
            class_6025 ownable;
            if (e instanceof class_6025 && (ownable = (class_6025)e).method_6139() != null) {
                return false;
            }
            return e instanceof class_1569 && e != this.method_5968();
        }
        if (e instanceof class_6025) {
            class_6025 ownable = (class_6025)e;
            if (this.method_6139().equals(ownable.method_6139())) {
                return true;
            }
        }
        return this.method_6139().equals(e.method_5667());
    };

    public EntityDemon(class_1299<? extends EntityDemon> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{DARK})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.DARK_BALL.get())).use((class_1309)this);
            }
        } else if (anim.is(new AnimatedAction[]{HEAL})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.CURE_ALL.get())).use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 2 ? (Spell)((Object)ModSpells.DARK_BALL.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(DARK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(SWIPE);
            } else {
                this.getAnimationHandler().setAnimation(STAB);
            }
        }
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width;
        double length = width = (double)(this.method_17681() * 1.0f);
        if (anim.is(new AnimatedAction[]{STAB})) {
            width = (double)this.method_17681() * 1.4;
            length = (double)this.method_17681() * 2.6;
        } else if (anim.is(new AnimatedAction[]{STAB_LONG})) {
            width = (double)this.method_17681() * 1.4;
            length = (double)this.method_17681() * 3.2;
        } else if (anim.is(new AnimatedAction[]{SWIPE})) {
            width = (double)this.method_17681() * 2.75;
            length = (double)this.method_17681() * 2.3;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    public AnimationHandler<EntityDemon> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Predicate<class_1309> healeableEntities() {
        return this.healingPredicate;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.96875, -0.3125);
    }

    @Override
    public EnumElement getAttackElement() {
        return EnumElement.DARK;
    }
}

