/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntityDuck
extends ChargingMonster {
    private static final AnimatedAction MELEE = AnimatedAction.builder((double)0.72, (String)"slap").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction DIVE = AnimatedAction.builder((double)1.84, (String)"dive").marker("dive", new double[]{1.08}).infinite().build();
    private static final AnimatedAction LAND = new AnimatedAction(0.48, "land");
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction STILL = AnimatedAction.builder((double)0.0, (String)"still").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, DIVE, LAND, INTERACT, STILL};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityDuck>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(MELEE, e -> 1.0f), (int)1), class_6008.method_34980((Object)new GoalAttackAction(DIVE).cooldown(e -> e.animationCooldown(DIVE)).prepare(() -> new WrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 6.0))), (int)1));
    private static final List<class_6008.class_6010<IdleAction<EntityDuck>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new), (int)3));
    public final AnimatedAttackGoal<EntityDuck> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityDuck> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityDuck(class_1299<? extends EntityDuck> type, class_1937 world) {
        super((class_1299<? extends ChargingMonster>)type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.25);
    }

    public AnimationHandler<? extends EntityDuck> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{DIVE})) {
            if (anim.isPast("dive")) {
                if (this.getChargeMotion() == null) {
                    this.setChargeMotion(this.getChargeTo(anim));
                }
                this.method_18800(this.getChargeMotion().field_1352, -0.25, this.getChargeMotion().field_1350);
                if (!this.method_24828()) {
                    if (this.hitEntity == null) {
                        this.hitEntity = new ArrayList();
                    }
                    this.mobAttack(anim, null, e -> {
                        if (!this.hitEntity.contains(e)) {
                            this.hitEntity.add(e);
                            this.method_6121((class_1297)e);
                        }
                    });
                } else {
                    this.getAnimationHandler().setAnimation(LAND);
                    this.setChargeMotion(null);
                }
            } else {
                class_243 delta = this.method_18798();
                this.method_18800(delta.field_1352, 0.1f, delta.field_1350);
                if (this.method_5968() != null) {
                    this.method_5951((class_1297)this.method_5968(), 20.0f, 30.0f);
                }
            }
        } else if (!anim.is(new AnimatedAction[]{LAND})) {
            super.handleAttack(anim);
        }
    }

    @Override
    protected boolean fixedYaw() {
        AnimatedAction anim = this.getAnimationHandler().getAnimation();
        return anim != null && (anim.is(new AnimatedAction[]{DIVE}) ? anim.isPast("dive") : anim.is(new AnimatedAction[]{LAND}));
    }

    @Override
    protected boolean isChargingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{DIVE, LAND});
    }

    @Override
    public class_243 getChargeTo(AnimatedAction anim) {
        return EntityUtils.getTargetDirection((class_1308)this, class_2183.class_2184.field_9853, true).method_1021(0.7);
    }

    @Override
    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.8;
        double length = (double)this.method_17681() * 2.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(DIVE);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return STILL;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.5375, -0.375);
    }
}

