/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import net.minecraft.class_6025;
import org.jetbrains.annotations.Nullable;

public class EntityFairy
extends BaseMonster
implements HealingPredicateEntity {
    public static final AnimatedAction LIGHT = AnimatedAction.builder((double)0.72, (String)"light").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction WIND = AnimatedAction.builder((double)0.72, (String)"wind").marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction HEAL = AnimatedAction.copyOf((AnimatedAction)LIGHT, (String)"heal");
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)LIGHT, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{LIGHT, WIND, HEAL, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityFairy>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(WIND, 9.0, 2.0, 1.0, e -> 1.0f), (int)8), class_6008.method_34980((Object)new GoalAttackAction(LIGHT).cooldown(e -> e.animationCooldown(LIGHT)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)3), class_6008.method_34980((Object)new GoalAttackAction(HEAL).cooldown(e -> e.animationCooldown(HEAL)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)2));
    private static final List<class_6008.class_6010<IdleAction<EntityFairy>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new), (int)1));
    public final AnimatedAttackGoal<EntityFairy> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityFairy> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private final Predicate<class_1309> healingPredicate = e -> {
        if (this.method_6139() == null) {
            class_6025 ownable;
            if (e instanceof class_6025 && (ownable = (class_6025)e).method_6139() != null) {
                return false;
            }
            return e instanceof class_1569 && e != this.method_5968();
        }
        if (e instanceof class_6025) {
            class_6025 ownable = (class_6025)e;
            if (this.method_6139().equals(ownable.method_6139())) {
                return true;
            }
        }
        return this.method_6139().equals(e.method_5667());
    };

    public EntityFairy(class_1299<? extends EntityFairy> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6277(2, this.attack);
        this.method_5875(true);
        this.field_6207 = new FreeMoveControl((class_1308)this);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.3);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    @Override
    protected class_1400<class_1657> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<class_1657>((class_1308)this, class_1657.class, 5, true, true, player -> !this.isTamed());
    }

    @Override
    protected class_1400<class_1308> createTargetGoalMobs() {
        return new NearestTargetHorizontal<class_1308>((class_1308)this, class_1308.class, 5, true, true, this.targetPred);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{LIGHT})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.SHINE.get())).use((class_1309)this);
            }
        } else if (anim.is(new AnimatedAction[]{WIND})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.DOUBLE_SONIC.get())).use((class_1309)this);
            }
        } else if (anim.is(new AnimatedAction[]{HEAL})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.CURE_ALL.get())).use((class_1309)this);
            }
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 1 ? (Spell)((Object)ModSpells.SHINE.get()) : (Spell)((Object)ModSpells.DOUBLE_BULLET.get()))) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LIGHT);
            } else {
                this.getAnimationHandler().setAnimation(WIND);
            }
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)ModSounds.ENTITY_FAIRY_AMBIENT.get();
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_6051().nextInt(20) + 30 + diffAdd;
        }
        return this.method_6051().nextInt(40) + 22 + diffAdd;
    }

    public AnimationHandler<EntityFairy> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Predicate<class_1309> healeableEntities() {
        return this.healingPredicate;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.625, -0.375);
    }
}

