/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityFlowerLily
extends BaseMonster {
    public static final AnimatedAction LEAP = AnimatedAction.builder((double)0.88, (String)"leap").marker("leap", new double[]{0.28}).build();
    public static final AnimatedAction ATTACK = AnimatedAction.builder((double)0.56, (String)"attack").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)ATTACK, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{LEAP, ATTACK, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityFlowerLily>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(ATTACK, 9.0, 2.0, 1.0, e -> 1.0f), (int)2), class_6008.method_34980((Object)MonsterActionUtils.simpleMeleeAction(LEAP, e -> 1.0f).withCondition((goal, target, previous) -> goal.distanceToTargetSq < 4.0), (int)5));
    private static final List<class_6008.class_6010<IdleAction<EntityFlowerLily>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), class_6008.method_34980((Object)new IdleAction(() -> new StrafingRunner(16.0f, 1.0f)), (int)1));
    public final AnimatedAttackGoal<EntityFlowerLily> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityFlowerLily> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityFlowerLily(class_1299<? extends EntityFlowerLily> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.25);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{LEAP})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double attackSize = (double)this.method_17681() * 2.1;
        return new class_238(-attackSize, -0.2, -attackSize, attackSize, (double)this.method_17682() + 0.2, attackSize);
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{LEAP})) {
            if (this.method_18798().method_1027() > 0.01) {
                return this.method_18798();
            }
            return null;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{LEAP})) {
            this.method_5942().method_6340();
            if (anim.isAt("leap")) {
                class_243 vec32 = EntityUtils.getTargetDirection((class_1308)this, class_2183.class_2184.field_9853, true).method_1021(-1.8);
                this.method_18800(vec32.field_1352, 0.15, vec32.field_1350);
            }
        } else if (anim.is(new AnimatedAction[]{ATTACK})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                this.rangedAttackSpell().use((class_1309)this);
            }
        }
    }

    protected Spell rangedAttackSpell() {
        return (Spell)((Object)ModSpells.DOUBLE_BULLET.get());
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 0 ? this.rangedAttackSpell() : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(ATTACK);
            }
        }
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783((class_3414)ModSounds.ENTITY_FLOWER_LILY_STEP.get(), 1.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_6051().nextInt(20) + 30 + diffAdd;
        }
        return this.method_6051().nextInt(40) + 25 + diffAdd;
    }

    public AnimationHandler<EntityFlowerLily> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.875, -0.25);
    }
}

