/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityGoblin
extends LeapingMonster {
    protected static final AnimatedAction MELEE = AnimatedAction.builder((double)0.72, (String)"slash").marker("attack", new double[]{0.36}).build();
    protected static final AnimatedAction LEAP = AnimatedAction.builder((double)0.92, (String)"leap").marker("attack_start", new double[]{0.36}).build();
    protected static final AnimatedAction STONE = AnimatedAction.builder((double)0.72, (String)"throw").marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, LEAP, STONE, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityGoblin>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(MELEE, e -> 0.8f), (int)2), class_6008.method_34980((Object)new GoalAttackAction(LEAP).cooldown(e -> e.animationCooldown(LEAP)).prepare(() -> new WrappedRunner((ActionRun)new MoveAwayRunner(1.5, 1.0, 4))), (int)1), class_6008.method_34980((Object)new GoalAttackAction(LEAP).cooldown(e -> e.animationCooldown(LEAP)).prepare(() -> new WrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 5.0))), (int)2), class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(STONE, 8.0, 3.0, 1.0, e -> 1.0f), (int)3));
    private static final List<class_6008.class_6010<IdleAction<EntityGoblin>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)1), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2));
    public final AnimatedAttackGoal<EntityGoblin> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityGoblin> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityGoblin(class_1299<? extends EntityGoblin> type, class_1937 world) {
        super((class_1299<? extends LeapingMonster>)type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.25);
    }

    @Override
    protected void method_5964(class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)ModItems.STEEL_SWORD_PROP.get()));
        this.method_5946(class_1304.field_6173, 0.0f);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 2.1;
        double length = this.method_17681() * 2.0f;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 2 ? (Spell)((Object)ModSpells.STONE_THROW.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(STONE);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)ModSounds.ENTITY_GOBLING_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModSounds.ENTITY_GOBLING_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)ModSounds.ENTITY_GOBLIN_DEATH.get();
    }

    public AnimationHandler<? extends EntityGoblin> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{STONE})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.STONE_THROW.get())).use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    protected boolean isLeapingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{LEAP});
    }

    @Override
    public class_243 getLeapVec(@Nullable class_243 target) {
        return super.getLeapVec(target).method_1021(1.25);
    }

    @Override
    public double leapHeightMotion() {
        return 0.3;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.8125, -0.3125);
    }
}

