/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityMobArrow;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityGoblin;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_6008;

public class EntityGoblinArcher
extends EntityGoblin {
    private static final AnimatedAction BOW = AnimatedAction.builder((double)0.8, (String)"bow").marker("attack", new double[]{0.52}).build();
    private static final AnimatedAction TRIPLE = AnimatedAction.copyOf((AnimatedAction)BOW, (String)"triple");
    private static final AnimatedAction KICK = AnimatedAction.builder((double)0.56, (String)"kick").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)KICK, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{BOW, TRIPLE, KICK, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityGoblinArcher>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeActionInRange(KICK, e -> 0.6f), (int)1), class_6008.method_34980((Object)MonsterActionUtils.simpleRangedStrafingAction(BOW, 8.0f, 1.0f, e -> 1.0f).withCondition(ActionUtils.chanced(e -> 1.0f, (goal, target, previous) -> ((EntityGoblinArcher)goal.attacker).method_6047().method_7909() instanceof class_1753)), (int)6), class_6008.method_34980((Object)MonsterActionUtils.simpleRangedStrafingAction(TRIPLE, 8.0f, 1.0f, e -> 1.0f).withCondition(ActionUtils.chanced(e -> 1.0f, (goal, target, previous) -> ((EntityGoblinArcher)goal.attacker).method_6047().method_7909() instanceof class_1753)), (int)3));
    private static final List<class_6008.class_6010<IdleAction<EntityGoblinArcher>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new KeepDistanceRunner(4.0, 10.0, 1.0)), (int)3), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)1), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new), (int)2));
    public final AnimatedAttackGoal<EntityGoblinArcher> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityGoblinArcher> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityGoblinArcher(class_1299<? extends EntityGoblin> type, class_1937 level) {
        super(type, level);
        this.field_6201.method_6280(((EntityGoblin)this).attack);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected void method_5964(class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
        this.method_5946(class_1304.field_6173, 0.0f);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 2 ? (Spell)((Object)ModSpells.TRIPLE_ARROW.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(TRIPLE);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(BOW);
            } else {
                this.getAnimationHandler().setAnimation(KICK);
            }
        }
    }

    public AnimationHandler<EntityGoblinArcher> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.3;
        double length = (double)this.method_17681() * 1.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void setupAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{BOW, TRIPLE})) {
            this.method_6019(class_1268.field_5808);
        }
        super.setupAttack(anim);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{BOW, TRIPLE})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                boolean withTarget;
                boolean bl = withTarget = this.method_5968() != null && this.method_5985().method_6369((class_1297)this.method_5968());
                if (anim.is(new AnimatedAction[]{BOW})) {
                    if (withTarget) {
                        this.shootArrow(this.method_5968());
                    } else {
                        this.shootArrowFromRotation((class_1309)this);
                    }
                } else if (withTarget) {
                    this.shootTripleArrow(this.method_5968());
                } else {
                    this.shootTripleArrowFromRotation((class_1309)this);
                }
                this.method_6021();
            }
        } else {
            super.handleAttack(anim);
        }
    }

    private void shootArrow(class_1309 target) {
        EntityMobArrow arrow = new EntityMobArrow(this.field_6002, (class_1309)this, 0.8f);
        class_243 dir = new class_243(target.method_23317() - arrow.method_23317(), target.method_23323(0.33) - arrow.method_23318(), target.method_23321() - arrow.method_23321());
        double l = Math.sqrt(dir.field_1352 * dir.field_1352 + dir.field_1350 * dir.field_1350);
        dir = dir.method_1031(0.0, l * 0.2, 0.0);
        arrow.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, 1.3f, 7 - this.field_6002.method_8407().method_5461() * 2);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().nextFloat() * 0.4f + 0.8f));
        this.field_6002.method_8649((class_1297)arrow);
    }

    private void shootArrowFromRotation(class_1309 shooter) {
        EntityMobArrow arrow = new EntityMobArrow(this.field_6002, (class_1309)this, 0.8f);
        arrow.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454(), 0.0f, 1.3f, 7 - this.field_6002.method_8407().method_5461() * 2);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().nextFloat() * 0.4f + 0.8f));
        this.field_6002.method_8649((class_1297)arrow);
    }

    private void shootTripleArrow(class_1309 target) {
        EntityMobArrow arrow = new EntityMobArrow(this.field_6002, (class_1309)this, 0.8f);
        class_243 dir = new class_243(target.method_23317() - arrow.method_23317(), target.method_23323(0.33) - arrow.method_23318(), target.method_23321() - arrow.method_23321());
        double l = Math.sqrt(dir.field_1352 * dir.field_1352 + dir.field_1350 * dir.field_1350);
        dir = dir.method_1031(0.0, l * 0.2, 0.0);
        arrow.method_7485(dir.field_1352, dir.field_1351, dir.field_1350, 1.3f, 7 - this.field_6002.method_8407().method_5461() * 2);
        this.field_6002.method_8649((class_1297)arrow);
        class_243 up = this.method_18864(1.0f);
        for (float y = -15.0f; y <= 15.0f; y += 30.0f) {
            class_1158 quaternion = new class_1158(new class_1160(up), y, true);
            class_1160 newDir = new class_1160(dir);
            newDir.method_19262(quaternion);
            EntityMobArrow arrowO = new EntityMobArrow(this.field_6002, (class_1309)this, 0.8f);
            arrowO.method_7485(newDir.method_4943(), newDir.method_4945(), newDir.method_4947(), 1.3f, 7 - this.field_6002.method_8407().method_5461() * 2);
            this.field_6002.method_8649((class_1297)arrowO);
        }
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().nextFloat() * 0.4f + 0.8f));
    }

    private void shootTripleArrowFromRotation(class_1309 shooter) {
        for (int i = 0; i < 3; ++i) {
            EntityMobArrow arrow = new EntityMobArrow(this.field_6002, (class_1309)this, 0.8f);
            arrow.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454() + (float)((i - 1) * 15), 0.0f, 1.3f, 7 - this.field_6002.method_8407().method_5461() * 2);
            this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().nextFloat() * 0.4f + 0.8f));
            this.field_6002.method_8649((class_1297)arrow);
        }
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }
}

