/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityGoblin;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_6008;

public class EntityGoblinGangster
extends EntityGoblin {
    private static final AnimatedAction DOUBLE_STAB = AnimatedAction.builder((double)0.88, (String)"double_stab").marker("attack", new double[]{0.4, 0.72}).build();
    private static final AnimatedAction DOUBLE_THROW = AnimatedAction.builder((double)0.96, (String)"double_throw").marker("attack", new double[]{0.4, 0.76}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)DOUBLE_THROW, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{DOUBLE_STAB, DOUBLE_THROW, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityGoblinGangster>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeActionInRange(DOUBLE_STAB, e -> 0.8f), (int)2), class_6008.method_34980((Object)MonsterActionUtils.simpleRangedEvadingAction(DOUBLE_THROW, 8.0, 3.0, 1.0, e -> 1.0f).withCondition((goal, target, previous) -> !((EntityGoblinGangster)goal.attacker).method_6047().method_7960()), (int)3));
    private static final List<class_6008.class_6010<IdleAction<EntityGoblinGangster>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)1), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2));
    public final AnimatedAttackGoal<EntityGoblinGangster> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityGoblinGangster> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityGoblinGangster(class_1299<? extends EntityGoblin> type, class_1937 level) {
        super(type, level);
        this.field_6201.method_6280(((EntityGoblin)this).attack);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected void method_5964(class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)ModItems.CUTLASS_PROP.get()));
        this.method_5946(class_1304.field_6173, 0.0f);
        this.method_5673(class_1304.field_6171, new class_1799((class_1935)ModItems.CUTLASS_PROP.get()));
        this.method_5946(class_1304.field_6171, 0.0f);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 1 ? (Spell)((Object)ModSpells.THROW_HAND_ITEM.get()) : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(DOUBLE_THROW);
            } else {
                this.getAnimationHandler().setAnimation(DOUBLE_STAB);
            }
        }
    }

    public AnimationHandler<EntityGoblinGangster> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.5;
        double length = (double)this.method_17681() * 2.15;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{DOUBLE_THROW})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                if (this.method_5968() != null && this.method_5985().method_6369((class_1297)this.method_5968())) {
                    ((Spell)((Object)ModSpells.THROW_HAND_ITEM.get())).use((class_1309)this);
                }
                this.method_6021();
            }
        } else if (anim.is(new AnimatedAction[]{DOUBLE_STAB})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                this.mobAttack(anim, this.method_5968(), this::quickAttack);
            }
        }
    }

    public boolean quickAttack(class_1297 target) {
        CustomDamage.Builder source = new CustomDamage.Builder((class_1297)this).noKnockback().hurtResistant(1);
        return CombatUtils.mobAttack((class_1309)this, target, source);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }
}

