/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.AirWanderGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityHornet
extends BaseMonster {
    public static final AnimatedAction ATTACK = AnimatedAction.builder((double)0.68, (String)"attack").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)ATTACK, (String)"interact");
    public static final AnimatedAction STILL = AnimatedAction.builder((double)0.0, (String)"still").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{ATTACK, INTERACT, STILL};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityHornet>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(ATTACK, 9.0, 2.0, 1.0, e -> 1.0f), (int)1));
    private static final List<class_6008.class_6010<IdleAction<EntityHornet>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new KeepDistanceRunner(2.0, 10.0, 1.0)).withCondition((goal, target) -> goal.distanceToTargetSq < 9.0), (int)5), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(12.0, 5)), (int)3));
    public final AnimatedAttackGoal<EntityHornet> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityHornet> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityHornet(class_1299<? extends BaseMonster> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6280((class_1352)this.wander);
        this.wander = new AirWanderGoal(this);
        this.field_6201.method_6277(6, (class_1352)this.wander);
        this.field_6201.method_6277(2, this.attack);
        this.field_6207 = new FreeMoveControl((class_1308)this);
        this.method_5875(true);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.3);
    }

    @Override
    protected class_1400<class_1657> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<class_1657>((class_1308)this, class_1657.class, 5, true, true, player -> !this.isTamed());
    }

    @Override
    protected class_1400<class_1308> createTargetGoalMobs() {
        return new NearestTargetHorizontal<class_1308>((class_1308)this, class_1308.class, 5, true, true, this.targetPred);
    }

    @Override
    public void method_6091(class_243 vec) {
        this.handleFreeTravel(vec);
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_6051().nextInt(20) + 30 + diffAdd;
        }
        return this.method_6051().nextInt(40) + 35 + diffAdd;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{ATTACK})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.POISON_NEEDLE.get())).use((class_1309)this);
            }
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.POISON_NEEDLE.get()))) {
                return;
            }
            this.getAnimationHandler().setAnimation(ATTACK);
        }
    }

    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_20603;
    }

    protected class_3414 method_6002() {
        return class_3417.field_20602;
    }

    public float method_6017() {
        return (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 0.9f;
    }

    protected class_3414 method_5994() {
        return (class_3414)ModSounds.ENTITY_WASP_BUZZ.get();
    }

    public int method_5970() {
        return 25;
    }

    public AnimationHandler<EntityHornet> getAnimationHandler() {
        return this.animationHandler;
    }

    protected void method_5623(double dist, boolean groundLogic, class_2680 state, class_2338 pos) {
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return STILL;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.84375, -0.25);
    }
}

