/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityLeafBall
extends BaseMonster {
    public static final AnimatedAction MELEE = AnimatedAction.builder((double)0.68, (String)"tackle").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction WIND = AnimatedAction.builder((double)1.12, (String)"wind_blade").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction SLEEP_ATTACK = AnimatedAction.builder((double)0.8, (String)"sleep_aura").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction STILL = AnimatedAction.builder((double)0.0, (String)"still").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, WIND, SLEEP_ATTACK, INTERACT, STILL};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityLeafBall>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeActionInRange(MELEE, e -> 0.7f), (int)1), class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(WIND, 10.0, 4.0, 1.0, e -> 1.0f), (int)3), class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(SLEEP_ATTACK, 7.0, 1.0, 1.0, e -> 1.0f), (int)2));
    private static final List<class_6008.class_6010<IdleAction<EntityLeafBall>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new KeepDistanceRunner(4.0, 10.0, 1.0)), (int)2), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)3));
    public final AnimatedAttackGoal<EntityLeafBall> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityLeafBall> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityLeafBall(class_1299<? extends EntityLeafBall> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6277(2, this.attack);
        this.method_5875(true);
        this.field_6207 = new FreeMoveControl((class_1308)this, 60.0f, 30.0f, () -> true);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.28);
    }

    @Override
    protected class_1400<class_1657> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<class_1657>((class_1308)this, class_1657.class, 5, true, true, player -> !this.isTamed());
    }

    @Override
    protected class_1400<class_1308> createTargetGoalMobs() {
        return new NearestTargetHorizontal<class_1308>((class_1308)this, class_1308.class, 5, true, true, this.targetPred);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{WIND})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.DOUBLE_SONIC.get())).use((class_1309)this);
            }
        } else if (anim.is(new AnimatedAction[]{SLEEP_ATTACK})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.SLEEP_AURA.get())).use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = this.method_17681() * 2.0f;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 0 ? (Spell)((Object)ModSpells.DOUBLE_BULLET.get()) : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(MELEE);
            } else {
                this.getAnimationHandler().setAnimation(WIND);
            }
        }
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_6051().nextInt(20) + 30 + diffAdd;
        }
        return this.method_6051().nextInt(40) + 25 + diffAdd;
    }

    public AnimationHandler<EntityLeafBall> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return STILL;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.0, -0.375);
    }
}

