/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.HealingPredicateEntity;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1569;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_6008;
import net.minecraft.class_6025;

public class EntityMage
extends BaseMonster
implements HealingPredicateEntity {
    public static final AnimatedAction SWING = AnimatedAction.builder((double)0.64, (String)"swing").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction CAST_1 = AnimatedAction.builder((double)0.84, (String)"cast_1").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction CAST_DOUBLE = AnimatedAction.builder((double)0.84, (String)"cast_double").marker("attack", new double[]{0.4, 0.6}).build();
    public static final AnimatedAction CAST_2 = AnimatedAction.builder((double)0.92, (String)"cast_2").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)SWING, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{SWING, CAST_1, CAST_2, CAST_DOUBLE, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityMage>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeActionInRange(SWING, e -> 0.8f), (int)1), class_6008.method_34980(MonsterActionUtils.simpleRangedStrafingAction(CAST_1, 6.0f, 1.0f, e -> 1.0f), (int)3), class_6008.method_34980(MonsterActionUtils.simpleRangedStrafingAction(CAST_DOUBLE, 7.0f, 1.0f, e -> 1.0f), (int)2), class_6008.method_34980(MonsterActionUtils.simpleRangedStrafingAction(CAST_2, 8.0f, 1.0f, e -> 1.0f), (int)4));
    private static final List<class_6008.class_6010<IdleAction<EntityMage>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new KeepDistanceRunner(4.0, 10.0, 1.0)), (int)3), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)1), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new), (int)2));
    public final AnimatedAttackGoal<EntityMage> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityMage> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private final Predicate<class_1309> healingPredicate = e -> {
        if (this.method_6139() == null) {
            class_6025 ownable;
            if (e instanceof class_6025 && (ownable = (class_6025)e).method_6139() != null) {
                return false;
            }
            return e instanceof class_1569 && e != this.method_5968();
        }
        if (e instanceof class_6025) {
            class_6025 ownable = (class_6025)e;
            if (this.method_6139().equals(ownable.method_6139())) {
                return true;
            }
        }
        return this.method_6139().equals(e.method_5667());
    };

    public EntityMage(class_1299<? extends EntityMage> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 2.1;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{CAST_1})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                this.getFirstSpell().use((class_1309)this);
            }
        } else if (anim.is(new AnimatedAction[]{CAST_DOUBLE})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.DARK_BALL.get())).use((class_1309)this);
            }
        } else if (anim.is(new AnimatedAction[]{CAST_2})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                this.getSecondSpell().use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            Spell spell;
            switch (command) {
                case 2: {
                    Spell spell2 = this.getSecondSpell();
                    break;
                }
                case 1: {
                    Spell spell2 = this.getFirstSpell();
                    break;
                }
                default: {
                    Spell spell2 = spell = null;
                }
            }
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), spell)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(CAST_2);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(CAST_1);
            } else {
                this.getAnimationHandler().setAnimation(SWING);
            }
        }
    }

    public AnimationHandler<EntityMage> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public Predicate<class_1309> healeableEntities() {
        return this.healingPredicate;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    public Spell getFirstSpell() {
        return (Spell)((Object)ModSpells.PARALYSIS_BALL.get());
    }

    public Spell getSecondSpell() {
        return (Spell)((Object)ModSpells.EXPANDING_QUAD_LIGHT.get());
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.84375, -0.3125);
    }
}

