/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.RiderAttackTargetGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.StayGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1370;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityMimic
extends LeapingMonster {
    private static final class_2940<Boolean> AWAKE = class_2945.method_12791(EntityMimic.class, (class_2941)class_2943.field_13323);
    private static final AnimatedAction MELEE = AnimatedAction.builder((double)0.6, (String)"attack").marker("attack", new double[]{0.44}).build();
    private static final AnimatedAction LEAP = AnimatedAction.builder((double)0.6, (String)"leap").marker("attack", new double[]{0.2}).build();
    private static final AnimatedAction THROW = AnimatedAction.builder((double)0.6, (String)"throw").marker("attack", new double[]{0.44}).build();
    private static final AnimatedAction ARROW = AnimatedAction.copyOf((AnimatedAction)THROW, (String)"arrow");
    private static final AnimatedAction CAST = AnimatedAction.builder((double)0.6, (String)"cast").marker("attack", new double[]{0.44}).build();
    private static final AnimatedAction CLOSE = AnimatedAction.builder((double)0.32, (String)"close").build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, LEAP, THROW, ARROW, CAST, CLOSE, INTERACT};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityMimic>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(MELEE, e -> 0.8f), (int)8), class_6008.method_34980((Object)new GoalAttackAction(LEAP).cooldown(e -> e.animationCooldown(LEAP)).prepare(() -> new WrappedRunner((ActionRun)new MoveAwayRunner(3.0, 1.0, 3))), (int)8), class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(THROW, 9.0, 3.0, 1.0, e -> 1.0f), (int)4), class_6008.method_34980((Object)new GoalAttackAction(THROW).cooldown(e -> e.animationCooldown(THROW)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)3), class_6008.method_34980((Object)new GoalAttackAction(ARROW).cooldown(e -> e.animationCooldown(ARROW)).prepare(() -> new WrappedRunner((ActionRun)new MoveAwayRunner(2.0, 1.0, 2))), (int)6), class_6008.method_34980((Object)new GoalAttackAction(CAST).cooldown(e -> e.animationCooldown(CAST)).prepare(() -> new WrappedRunner((ActionRun)new MoveAwayRunner(2.0, 1.0, 2))), (int)6));
    private static final List<class_6008.class_6010<IdleAction<EntityMimic>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 1.5)), (int)1), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2));
    public final AnimatedAttackGoal<EntityMimic> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityMimic> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private int sleepTick = -1;
    private boolean sleeping;
    private final List<class_1799> throwables = List.of(new class_1799((class_1935)class_1802.field_8279), new class_1799((class_1935)ModItems.BATTLE_AXE.get()), new class_1799((class_1935)ModItems.STEEL_SWORD.get()), new class_1799((class_1935)ModItems.MUSHROOM.get()));

    public EntityMimic(class_1299<? extends EntityMimic> type, class_1937 world) {
        super((class_1299<? extends LeapingMonster>)type, world);
        this.field_6201.method_6277(2, this.attack);
        this.field_6207 = new JumpingMover(this);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.5);
    }

    @Override
    public void addGoal() {
        this.field_6185.method_6277(1, (class_1352)this.targetPlayer);
        this.field_6185.method_6277(2, (class_1352)this.targetMobs);
        this.field_6185.method_6277(0, (class_1352)this.hurt);
        this.field_6185.method_6277(3, (class_1352)new RiderAttackTargetGoal((class_1308)this, 15));
        this.field_6201.method_6277(0, (class_1352)this.swimGoal);
        this.field_6201.method_6277(0, new StayGoal<BaseMonster>(this, StayGoal.CANSTAYMONSTER));
        this.field_6201.method_6277(3, (class_1352)this.followOwnerGoal);
        this.field_6201.method_6277(4, (class_1352)new class_1370((class_1314)this, 1.0));
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        boolean ret = super.method_5643(source, amount);
        if (ret && !this.sleeping) {
            this.setAwake();
        }
        return ret;
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.6;
        double length = (double)this.method_17681() * 1.8;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 2 ? (Spell)((Object)ModSpells.THROW_HAND_ITEM.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(THROW);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(AWAKE, (Object)false);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{THROW})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                class_1799 held = this.method_6047();
                this.method_5673(class_1304.field_6173, this.throwables.get(this.field_5974.nextInt(this.throwables.size())));
                ((Spell)((Object)ModSpells.THROW_HAND_ITEM.get())).use((class_1309)this);
                this.method_5673(class_1304.field_6173, held);
            }
        } else if (anim.is(new AnimatedAction[]{CAST})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.WATER_LASER.get())).use((class_1309)this);
            }
        } else if (anim.is(new AnimatedAction[]{ARROW})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.DOUBLE_ARROW.get())).use((class_1309)this);
            }
        } else {
            if (!this.isLeapingAnim(anim)) {
                class_243 vec32 = this.getLeapVec(this.tryGetTargetPosition(this.method_5968())).method_1021(0.1);
                this.method_18800(vec32.field_1352, 0.05f, vec32.field_1350);
            }
            super.handleAttack(anim);
        }
    }

    @Override
    protected boolean isLeapingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{LEAP});
    }

    @Override
    public class_243 getLeapVec(@Nullable class_243 target) {
        return super.getLeapVec(target).method_1021(1.25);
    }

    @Override
    public double leapHeightMotion() {
        return 0.3;
    }

    public void method_5980(@Nullable class_1309 livingEntity) {
        super.method_5980(livingEntity);
        if (livingEntity != null && !this.sleeping) {
            this.setAwake();
        }
    }

    public void method_5670() {
        super.method_5670();
        if (!this.field_6002.field_9236) {
            if (this.method_5968() == null) {
                --this.sleepTick;
            }
            if (this.sleepTick == 0) {
                this.field_6011.method_12778(AWAKE, (Object)false);
                this.getAnimationHandler().setAnimation(CLOSE);
                this.method_5942().method_6340();
            }
        }
    }

    public void setAwake() {
        this.field_6011.method_12778(AWAKE, (Object)true);
        this.sleepTick = 200;
    }

    protected float method_6106() {
        if (this.method_5968() != null) {
            return 0.28f * this.method_23313();
        }
        return 0.48f * this.method_23313();
    }

    protected void method_6043() {
        class_243 vec3 = this.method_18798();
        this.method_18800(vec3.field_1352, this.method_6106(), vec3.field_1350);
        this.field_6007 = true;
    }

    public boolean isAwake() {
        return (Boolean)this.field_6011.method_12789(AWAKE);
    }

    public AnimationHandler<? extends EntityMimic> getAnimationHandler() {
        return this.animationHandler;
    }

    private int getJumpDelay() {
        if (this.method_5968() != null) {
            return this.field_5974.nextInt(5) + 5;
        }
        return this.field_5974.nextInt(6) + 7;
    }

    public boolean method_30948() {
        return !this.isAwake();
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public void onSleeping(boolean sleeping) {
        if (sleeping) {
            this.sleeping = true;
            if (this.isAwake()) {
                this.field_6011.method_12778(AWAKE, (Object)false);
                this.getAnimationHandler().setAnimation(CLOSE);
                this.method_5942().method_6340();
            }
        } else {
            this.sleeping = false;
        }
    }

    @Override
    public boolean hasSleepingAnimation() {
        return true;
    }

    protected static class JumpingMover
    extends class_1335 {
        private final EntityMimic mimic;
        private int jumpDelay;

        public JumpingMover(EntityMimic mimic) {
            super((class_1308)mimic);
            this.mimic = mimic;
        }

        public void method_6240() {
            this.field_6371.field_6241 = this.field_6371.method_36454();
            this.field_6371.field_6283 = this.field_6371.method_36454();
            if (this.field_6374 != class_1335.class_1336.field_6378) {
                this.field_6371.method_5930(0.0f);
                return;
            }
            this.mimic.setAwake();
            this.field_6374 = class_1335.class_1336.field_6377;
            double dX = this.field_6370 - this.field_6371.method_23317();
            double dZ = this.field_6367 - this.field_6371.method_23321();
            float n = (float)(class_3532.method_15349((double)dZ, (double)dX) * 57.2957763671875) - 90.0f;
            this.field_6371.method_36456(this.method_6238(this.field_6371.method_36454(), n, 90.0f));
            if (this.field_6371.method_24828()) {
                this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_26825(class_5134.field_23719)));
                if (this.jumpDelay-- <= 0) {
                    this.jumpDelay = this.mimic.getJumpDelay();
                    this.mimic.method_5993().method_6233();
                    this.mimic.method_5783(class_3417.field_14982, this.mimic.method_6107() * 0.5f, 1.0f);
                } else {
                    this.mimic.field_6212 = 0.0f;
                    this.mimic.field_6250 = 0.0f;
                    this.field_6371.method_6125(0.0f);
                }
            } else {
                this.field_6371.method_6125((float)(this.field_6372 * this.field_6371.method_26825(class_5134.field_23719)));
            }
        }
    }
}

