/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.ChargeAction;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_6008;

public class EntityMinotaur
extends ChargingMonster {
    public static final AnimatedAction SWING = AnimatedAction.builder((double)1.08, (String)"swing").marker("attack", new double[]{0.72}).build();
    public static final AnimatedAction SPIN = AnimatedAction.builder((double)1.48, (String)"spin").marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{1.28}).marker("reset", new double[]{0.84}).build();
    public static final AnimatedAction CHARGE = AnimatedAction.builder((double)2.64, (String)"charge").marker("attack_start", new double[]{0.64}).marker("attack_end", new double[]{2.2}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)SWING, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{SWING, SPIN, CHARGE, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityMinotaur>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(SWING, e -> 1.0f), (int)1), class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(SPIN, e -> 1.0f), (int)1), class_6008.method_34980((Object)new GoalAttackAction(CHARGE).cooldown(e -> e.animationCooldown(CHARGE)).withCondition(MonsterActionUtils.chargeCondition()).prepare(ChargeAction::new), (int)2));
    private static final List<class_6008.class_6010<IdleAction<EntityMinotaur>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)3), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(12.0, 5)), (int)5));
    public final AnimatedAttackGoal<EntityMinotaur> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityMinotaur> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private class_243 spinDirection;
    private float spinAngle;

    public EntityMinotaur(class_1299<? extends EntityMinotaur> type, class_1937 world) {
        super((class_1299<? extends ChargingMonster>)type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected Consumer<AnimatedAction> animatedActionConsumer() {
        return anim -> {
            super.animatedActionConsumer().accept((AnimatedAction)anim);
            if (!this.field_6002.field_9236 && (anim == null || anim.is(new AnimatedAction[]{SPIN}))) {
                this.hitEntity = null;
                this.spinDirection = null;
            }
        };
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            double attackSize = (double)this.method_17681() * 1.4;
            return new class_238(-attackSize, -0.2, -attackSize, attackSize, (double)this.method_17682() + 0.2, attackSize);
        }
        double width = (double)this.method_17681() * 1.6;
        double length = (double)this.method_17681() * 2.1;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            if (this.hitEntity == null) {
                this.hitEntity = new ArrayList();
            }
            if (this.spinDirection == null) {
                this.spinDirection = EntityUtils.getTargetDirection((class_1308)this, class_2183.class_2184.field_9853, true).method_1021(0.1);
                this.spinAngle = this.method_36454() + 90.0f;
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                this.method_18800(this.spinDirection.method_10216(), this.method_18798().field_1351, this.spinDirection.method_10215());
                float start = (float)(anim.getMarker("attack_start", 0) * 20.0);
                float end = (float)(anim.getMarker("attack_end", 0) * 20.0);
                float f = anim.progress(start, end, 1.0f, 0);
                float fNext = anim.progress(start, end, 1.0f, 1);
                float angleInc = -490.0f;
                if (anim.isAt("reset")) {
                    this.hitEntity.clear();
                }
                this.hitEntity.addAll(CombatUtils.EntityAttack.create((class_1309)this, CombatUtils.EntityAttack.circleTargetsFixedRange(this.spinAngle + f * angleInc, this.spinAngle + fNext * angleInc, 4.5f)).withTargetPredicate(e -> this.hitPred.test(e) && !this.hitEntity.contains(e)).executeAttack());
            }
        } else {
            if (anim.is(new AnimatedAction[]{SWING}) && anim.isAt("attack")) {
                S2CScreenShake.sendAround((class_1297)this, 16.0, 5, 3.0f);
                this.field_6002.method_8396(null, this.method_24515(), class_3417.field_15152, this.method_5634(), 1.0f, 0.9f);
            }
            super.handleAttack(anim);
        }
    }

    @Override
    public CustomDamage.Builder damageSourceAttack() {
        CustomDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE})) {
            source.knock(CustomDamage.KnockBackType.BACK).knockAmount(2.0f);
        } else if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SWING})) {
            source.withChangedAttribute((class_1320)ModAttributes.STUN.get(), 30.0);
        }
        return source;
    }

    @Override
    protected boolean isChargingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{CHARGE});
    }

    @Override
    public boolean handleChargeMovement(AnimatedAction anim) {
        boolean res = super.handleChargeMovement(anim);
        if (res && this.field_6012 % 7 == 0) {
            this.method_5783((class_3414)ModSounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
        }
        return res;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(SWING);
            }
        }
    }

    public AnimationHandler<? extends EntityMinotaur> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public double chargingSpeed() {
        return 0.45f;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 2.3125, -0.4375);
    }
}

