/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityMobArrow;
import io.github.flemmli97.runecraftory.common.entities.monster.EntityOrc;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1753;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3417;
import net.minecraft.class_6008;

public class EntityOrcArcher
extends EntityOrc {
    public static final AnimatedAction MELEE = AnimatedAction.builder((double)0.92, (String)"kick").marker("attack", new double[]{0.58}).build();
    public static final AnimatedAction RANGED = AnimatedAction.builder((double)1.0, (String)"bow").marker("attack", new double[]{0.6}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, RANGED, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityOrc>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeActionInRange(MELEE, e -> 0.6f), (int)1), class_6008.method_34980((Object)MonsterActionUtils.simpleRangedStrafingAction(RANGED, 8.0f, 1.0f, e -> 1.0f).withCondition(ActionUtils.chanced(e -> e.method_5864() == ModEntities.ORC.get() ? 0.85f : 0.95f, (goal, target, previous) -> ((EntityOrc)goal.attacker).method_6047().method_7909() instanceof class_1753)), (int)4));
    private static final List<class_6008.class_6010<IdleAction<EntityOrc>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new KeepDistanceRunner(4.0, 10.0, 1.0)), (int)3), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)1), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new), (int)2));
    public final AnimatedAttackGoal<EntityOrc> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityOrcArcher> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityOrcArcher(class_1299<? extends EntityOrcArcher> type, class_1937 level) {
        super((class_1299<? extends EntityOrc>)type, level);
        this.field_6201.method_6280(((EntityOrc)this).attack);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected void method_5964(class_1266 difficulty) {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
        this.method_5946(class_1304.field_6173, 0.0f);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.2;
        double length = (double)this.method_17681() * 1.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void setupAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{RANGED})) {
            this.method_6019(class_1268.field_5808);
        }
        super.setupAttack(anim);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{RANGED})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                if (this.method_5968() != null && this.method_5985().method_6369((class_1297)this.method_5968())) {
                    this.shootArrow(this.method_5968());
                } else if (this.method_31483() instanceof class_1657) {
                    this.shootArrowFromRotation((class_1309)this);
                }
                this.method_6021();
            }
        } else {
            super.handleAttack(anim);
        }
    }

    public AnimationHandler<EntityOrcArcher> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(MELEE);
            } else {
                this.getAnimationHandler().setAnimation(RANGED);
            }
        }
    }

    private void shootArrow(class_1309 target) {
        EntityMobArrow arrow = new EntityMobArrow(this.field_6002, (class_1309)this, 0.8f);
        arrow.shootAtEntity((class_1297)target, 1.3f, 14 - this.field_6002.method_8407().method_5461() * 4);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().nextFloat() * 0.4f + 0.8f));
        this.field_6002.method_8649((class_1297)arrow);
    }

    private void shootArrowFromRotation(class_1309 shooter) {
        EntityMobArrow arrow = new EntityMobArrow(this.field_6002, (class_1309)this, 0.8f);
        arrow.method_24919((class_1297)shooter, shooter.method_36455(), shooter.method_36454(), 0.0f, 1.3f, 7 - this.field_6002.method_8407().method_5461() * 2);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().nextFloat() * 0.4f + 0.8f));
        this.field_6002.method_8649((class_1297)arrow);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }
}

