/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.RestrictedWaterAvoidingStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityPalmCat
extends LeapingMonster {
    private static final AnimatedAction MELEE = AnimatedAction.builder((double)0.72, (String)"attack").marker("attack", new double[]{0.44}).build();
    private static final AnimatedAction LEAP = AnimatedAction.builder((double)0.76, (String)"attack_2").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{0.64}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, LEAP, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityPalmCat>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(MELEE, e -> e.consecutive ? 1.0f : 0.7f), (int)4), class_6008.method_34980((Object)new GoalAttackAction(LEAP).cooldown(e -> e.animationCooldown(LEAP)).prepare(() -> new WrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 3.0))), (int)2));
    private static final List<class_6008.class_6010<IdleAction<EntityPalmCat>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)3), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(12.0, 5)), (int)1));
    public final AnimatedAttackGoal<EntityPalmCat> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityPalmCat> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private boolean hitAny;
    private boolean consecutive;

    public EntityPalmCat(class_1299<? extends EntityPalmCat> type, class_1937 world) {
        super((class_1299<? extends LeapingMonster>)type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected Consumer<AnimatedAction> animatedActionConsumer() {
        return anim -> {
            super.animatedActionConsumer().accept((AnimatedAction)anim);
            if (!this.field_6002.field_9236) {
                AnimatedAction current = this.animationHandler.getAnimation();
                if (MELEE.is(new AnimatedAction[]{current}) || LEAP.is(new AnimatedAction[]{current})) {
                    if (this.hitAny && !this.consecutive) {
                        this.consecutive = true;
                        this.attack.resetCooldown();
                    } else {
                        this.consecutive = false;
                    }
                }
                this.hitAny = false;
            }
        };
    }

    @Override
    protected boolean isLeapingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{LEAP});
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.3);
    }

    @Override
    public void addGoal() {
        super.addGoal();
        this.field_6201.method_6280((class_1352)this.wander);
        this.wander = new RestrictedWaterAvoidingStrollGoal(this, 0.6);
        this.field_6201.method_6277(6, (class_1352)this.wander);
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    public AnimationHandler<? extends EntityPalmCat> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public class_243 getLeapVec(@Nullable class_243 target) {
        if (target != null) {
            class_243 leap = new class_243(target.field_1352 - this.method_23317(), 0.0, target.field_1350 - this.method_23321());
            if (leap.method_1027() > 7.0) {
                return leap.method_1029();
            }
            return leap.method_1021(0.9);
        }
        return super.getLeapVec(null);
    }

    @Override
    public double leapHeightMotion() {
        return 0.2;
    }

    @Override
    public boolean method_6121(class_1297 entity) {
        boolean hurt;
        CustomDamage.Builder source = new CustomDamage.Builder((class_1297)this).noKnockback().hurtResistant(1);
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{LEAP})) {
            source.knock(CustomDamage.KnockBackType.UP).knockAmount(1.0f);
        }
        if (hurt = CombatUtils.mobAttack((class_1309)this, entity, source)) {
            this.hitAny = true;
        }
        return hurt;
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.3;
        double length = (double)this.method_17681() * 2.1;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.984375, -0.25);
    }
}

