/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityPanther
extends LeapingMonster {
    private static final AnimatedAction MELEE = AnimatedAction.builder((double)0.76, (String)"attack").marker("attack", new double[]{0.32, 0.6}).build();
    private static final AnimatedAction LEAP = AnimatedAction.builder((double)1.12, (String)"leap").marker("attack_start", new double[]{0.2}).marker("attack_end", new double[]{1.0}).marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, LEAP, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityPanther>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(MELEE, e -> 0.8f), (int)2), class_6008.method_34980((Object)new GoalAttackAction(LEAP).cooldown(e -> e.animationCooldown(LEAP)).withCondition(ActionUtils.chanced(e -> 1.0f)).prepare(() -> new WrappedRunner((ActionRun)new MoveAwayRunner(1.5, 1.0, 4))), (int)1), class_6008.method_34980((Object)new GoalAttackAction(LEAP).cooldown(e -> e.animationCooldown(LEAP)).withCondition(ActionUtils.chanced(e -> 1.0f)).prepare(() -> new WrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 4.0))), (int)2));
    private static final List<class_6008.class_6010<IdleAction<EntityPanther>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)1), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2));
    public final AnimatedAttackGoal<EntityPanther> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityPanther> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityPanther(class_1299<? extends EntityPanther> type, class_1937 world) {
        super((class_1299<? extends LeapingMonster>)type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return (class_3414)ModSounds.ENTITY_PANTHER_HURT.get();
    }

    protected class_3414 method_5994() {
        return (class_3414)ModSounds.ENTITY_PANTHER_AMBIENT.get();
    }

    public AnimationHandler<? extends EntityPanther> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{LEAP})) {
            if (anim.isPast("attack_start")) {
                class_243 vec32 = this.getLeapVec(this.tryGetTargetPosition(this.method_5968()));
                this.method_18800(vec32.field_1352, 0.25, vec32.field_1350);
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (this.hitEntity == null) {
                    this.hitEntity = new ArrayList();
                }
                this.mobAttack(anim, null, e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add(e);
                        this.method_6121((class_1297)e);
                    }
                });
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    protected boolean isLeapingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{LEAP});
    }

    @Override
    public class_243 getLeapVec(@Nullable class_243 target) {
        return super.getLeapVec(target).method_1021(1.2);
    }

    @Override
    public double leapHeightMotion() {
        return 0.25;
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.3;
        double length = (double)this.method_17681() * 1.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.34375, -0.8125);
    }
}

