/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.AirWanderGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import net.minecraft.class_7;

public class EntitySkyFish
extends BaseMonster {
    public static final AnimatedAction SLAP = AnimatedAction.builder((double)0.56, (String)"slap").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction BEAM = AnimatedAction.builder((double)0.68, (String)"beam").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction SWIPE = AnimatedAction.builder((double)0.76, (String)"swipe").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)SLAP, (String)"interact");
    public static final AnimatedAction STILL = AnimatedAction.builder((double)0.0, (String)"still").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{SLAP, BEAM, SWIPE, INTERACT, STILL};
    private static final List<class_6008.class_6010<GoalAttackAction<EntitySkyFish>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(SLAP, e -> 0.6f), (int)1), class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(BEAM, 8.0, 5.0, 1.0, e -> 1.0f), (int)2), class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(SWIPE, 8.0, 5.0, 1.0, e -> 1.0f), (int)1));
    private static final List<class_6008.class_6010<IdleAction<EntitySkyFish>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(10.0, 5)), (int)2), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new), (int)1));
    public final AnimatedAttackGoal<EntitySkyFish> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntitySkyFish> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntitySkyFish(class_1299<? extends BaseMonster> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6280((class_1352)this.wander);
        this.wander = new AirWanderGoal(this);
        this.field_6201.method_6277(6, (class_1352)this.wander);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6201.method_6277(2, this.attack);
        this.field_6207 = new FreeMoveControl((class_1308)this, () -> false);
        this.field_6201.method_6280((class_1352)this.swimGoal);
        this.wander.method_6303(50);
        this.method_5875(true);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.25);
        this.method_5996(class_5134.field_23717).method_6192(32.0);
    }

    @Override
    protected class_1400<class_1657> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<class_1657>((class_1308)this, class_1657.class, 5, true, true, player -> !this.isTamed());
    }

    @Override
    protected class_1400<class_1308> createTargetGoalMobs() {
        return new NearestTargetHorizontal<class_1308>((class_1308)this, class_1308.class, 5, true, true, this.targetPred);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236 && this.method_5968() == null && !this.method_5799() && this.belowSoldid()) {
            class_243 mot = this.method_18798();
            double newY = Math.max(0.0, mot.field_1351);
            this.method_18800(mot.field_1352, Math.min(0.3, newY += 0.03), mot.field_1350);
        }
    }

    @Override
    public void method_6091(class_243 vec) {
        this.handleFreeTravel(vec);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.5;
        double length = (double)this.method_17681() * 1.6;
        return new class_238(-width * 0.2, -0.02, 0.0, width * 0.8, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{BEAM})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.WATER_LASER.get())).use((class_1309)this);
            }
        } else if (anim.is(new AnimatedAction[]{SWIPE})) {
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.WATER_SWIPE.get())).use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 1) {
                if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.WATER_LASER.get()))) {
                    return;
                }
                this.getAnimationHandler().setAnimation(BEAM);
            } else {
                if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                    return;
                }
                if (command == 2) {
                    this.getAnimationHandler().setAnimation(SWIPE);
                } else {
                    this.getAnimationHandler().setAnimation(SLAP);
                }
            }
        }
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_14851;
    }

    protected class_3414 method_6002() {
        return class_3417.field_15003;
    }

    public float method_6017() {
        return (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 0.8f;
    }

    public AnimationHandler<EntitySkyFish> getAnimationHandler() {
        return this.animationHandler;
    }

    private boolean belowSoldid() {
        class_2338 pos = this.method_24515().method_10074();
        return this.field_6002.method_8320(pos).method_26168((class_1922)this.field_6002, pos, (class_1297)this);
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    public boolean method_5675() {
        return false;
    }

    @Override
    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    public boolean method_6094() {
        return true;
    }

    @Override
    public boolean method_5788() {
        return false;
    }

    public class_1310 method_6046() {
        return class_1310.field_6292;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return STILL;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.75, -0.125);
    }
}

