/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1408;
import net.minecraft.class_1410;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntitySpider
extends BaseMonster {
    private static final class_2940<Boolean> CLIMBING_SYNC = class_2945.method_12791(EntitySpider.class, (class_2941)class_2943.field_13323);
    public static final AnimatedAction MELEE = AnimatedAction.builder((double)0.6, (String)"attack").marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction WEBSHOT = AnimatedAction.builder((double)0.68, (String)"webshot").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction STILL = AnimatedAction.builder((double)0.0, (String)"still").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, WEBSHOT, INTERACT, STILL};
    private static final List<class_6008.class_6010<GoalAttackAction<EntitySpider>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(MELEE, e -> 0.7f), (int)1), class_6008.method_34980(MonsterActionUtils.simpleRangedStrafingAction(WEBSHOT, 7.0f, 1.0f, e -> 1.0f), (int)2));
    private static final List<class_6008.class_6010<IdleAction<EntitySpider>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)5), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(9.0, 3)), (int)3), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new), (int)1));
    public final AnimatedAttackGoal<EntitySpider> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntitySpider> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    public int climbingTicker = -1;
    public static final int CLIMB_MAX = 9;

    public EntitySpider(class_1299<? extends EntitySpider> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.27);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new class_1410((class_1308)this, level);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CLIMBING_SYNC, (Object)false);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            this.setClimbing(this.field_5976);
        }
        this.climbingTicker = this.isClimbing() && this.method_5805() && !this.playDeath() ? Math.min(this.climbingTicker + 1, 9) : Math.max(this.climbingTicker - 1, -1);
    }

    public boolean method_6101() {
        return this.isClimbing();
    }

    public void method_5844(class_2680 state, class_243 motionMultiplier) {
        if (!state.method_27852(class_2246.field_10343)) {
            super.method_5844(state, motionMultiplier);
        }
    }

    public boolean isClimbing() {
        return (Boolean)this.field_6011.method_12789(CLIMBING_SYNC);
    }

    public void setClimbing(boolean climbing) {
        this.field_6011.method_12778(CLIMBING_SYNC, (Object)climbing);
    }

    protected class_3414 method_5994() {
        return class_3417.field_15170;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_14657;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(class_3417.field_14760, 0.15f, 1.0f);
    }

    protected class_3414 method_6002() {
        return class_3417.field_14579;
    }

    public float method_6017() {
        return (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.3f;
    }

    public AnimationHandler<EntitySpider> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.5;
        double length = (double)this.method_17681() * 1.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{WEBSHOT})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack") && (this.method_5968() != null && this.method_5985().method_6369((class_1297)this.method_5968()) || this.method_31483() instanceof class_1657)) {
                ((Spell)((Object)ModSpells.WEB_SHOT.get())).use((class_1309)this);
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 1 ? (Spell)((Object)ModSpells.WEB_SHOT.get()) : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(WEBSHOT);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    protected int method_23329(float distance, float damageMultiplier) {
        return (int)((double)(super.method_23329(distance, damageMultiplier) - 3) * 0.5);
    }

    public class_1310 method_6046() {
        return class_1310.field_6293;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return STILL;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.625, 0.21875);
    }
}

