/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.ChargingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.AmphibiousStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.ChargeAction;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.SwimWalkMoveController;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.AmphibiousNavigator;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1409;
import net.minecraft.class_1412;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import net.minecraft.class_7;

public class EntityTortas
extends ChargingMonster {
    public static final AnimatedAction BITE = AnimatedAction.builder((double)0.56, (String)"bite").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction SPIN = AnimatedAction.builder((double)2.5, (String)"spin").marker("attack_start", new double[]{0.0}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)BITE, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{BITE, SPIN, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityTortas>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(BITE, e -> 0.85f), (int)1), class_6008.method_34980((Object)new GoalAttackAction(SPIN).cooldown(e -> e.animationCooldown(SPIN)).withCondition(MonsterActionUtils.chargeCondition()).prepare(ChargeAction::new), (int)2));
    private static final List<class_6008.class_6010<IdleAction<EntityTortas>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)3), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(12.0, 5)), (int)5), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new), (int)1));
    public final AnimatedAttackGoal<EntityTortas> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityTortas> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    protected final class_1412 waterNavigator;
    protected final class_1409 groundNavigator;

    public EntityTortas(class_1299<? extends EntityTortas> type, class_1937 world) {
        super((class_1299<? extends ChargingMonster>)type, world);
        this.method_5941(class_7.field_18, 0.0f);
        this.field_6201.method_6277(2, this.attack);
        this.field_6207 = new SwimWalkMoveController((class_1308)this);
        this.field_6201.method_6280((class_1352)this.swimGoal);
        this.waterNavigator = new AmphibiousNavigator((class_1308)this, world);
        this.groundNavigator = new class_1409((class_1308)this, world);
        this.field_6201.method_6280((class_1352)this.wander);
        this.wander = new AmphibiousStrollGoal(this, 1.0, 2);
        this.field_6201.method_6277(6, (class_1352)this.wander);
        this.field_6013 = 1.0f;
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.18);
    }

    @Override
    public int animationCooldown(AnimatedAction anim) {
        if (anim != null && anim.is(new AnimatedAction[]{SPIN})) {
            int diffAdd = this.difficultyCooldown();
            return this.method_6051().nextInt(50) + 30 + diffAdd;
        }
        return super.animationCooldown(anim);
    }

    @Override
    public void setDoJumping(boolean jump) {
        if (this.method_5799()) {
            super.setDoJumping(jump);
        }
    }

    @Override
    public void method_6091(class_243 vec) {
        if (this.method_6034() && this.method_5799()) {
            this.handleFreeTravel(vec);
        } else {
            super.method_6091(vec);
        }
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.2;
        double length = (double)this.method_17681() * 1.4;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    protected boolean isChargingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{SPIN});
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim != null && anim.is(new AnimatedAction[]{SPIN})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1014(0.2), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(BITE);
            }
        }
    }

    @Override
    public double ridingSpeedModifier() {
        return 0.8;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_15183;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14856;
    }

    public float method_6017() {
        return (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 0.75f;
    }

    public AnimationHandler<EntityTortas> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean adjustRotFromRider(class_1309 rider) {
        return true;
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SPIN})) {
            return this.method_18798();
        }
        return super.directionToLookAt();
    }

    @Override
    public boolean handleChargeMovement(AnimatedAction anim) {
        class_243 prevMotion = this.method_18798();
        if (this.method_5968() != null) {
            class_243 pos = this.method_19538();
            class_243 target = this.method_5968().method_19538();
            class_243 mot = target.method_1023(pos.field_1352, this.method_5799() ? pos.field_1351 : target.field_1351, pos.field_1350).method_1029().method_1021(0.27);
            this.method_18800(mot.field_1352, mot.field_1351, mot.field_1350);
            if (!this.method_24828() && !this.method_5799()) {
                this.method_18799(this.method_18798().method_1031(0.0, prevMotion.field_1351, 0.0));
            }
        } else {
            class_243 look = this.method_5631(this.method_5799() ? this.method_36455() : 0.0f, this.method_36454()).method_1021(0.27);
            this.method_18800(look.field_1352, look.field_1351, look.field_1350);
            if (!this.method_24828() && !this.method_5799()) {
                this.method_18799(this.method_18798().method_1031(0.0, prevMotion.field_1351, 0.0));
            }
        }
        return true;
    }

    @Override
    public void doWhileCharge() {
        if (this.field_6012 % 4 == 0) {
            this.method_5783((class_3414)ModSounds.PLAYER_ATTACK_SWOOSH_LIGHT.get(), 1.0f, (this.method_6051().nextFloat() - this.method_6051().nextFloat()) * 0.2f + 1.0f);
        }
        if (this.field_6012 % 8 == 0) {
            this.hitEntity.clear();
        }
    }

    @Override
    public double chargingSpeed() {
        return 0.3f;
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    public void method_5790() {
        if (!this.field_6002.field_9236) {
            if (this.method_5799()) {
                this.field_6189 = this.waterNavigator;
                this.wander.method_6303(2);
                this.method_5796(true);
            } else {
                this.field_6189 = this.groundNavigator;
                this.wander.method_6303(100);
                this.method_5796(false);
            }
        }
    }

    public double method_5621() {
        return (double)this.method_17682() * 0.7;
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_6094() {
        return true;
    }

    public class_1310 method_6046() {
        return class_1310.field_6292;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.6875, -0.25);
    }
}

