/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntityTroll
extends BaseMonster {
    public static final AnimatedAction PUNCH = AnimatedAction.builder((double)0.8, (String)"punch").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction DOUBLE_PUNCH = AnimatedAction.builder((double)0.8, (String)"double_fist_punch").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction SLAM = AnimatedAction.builder((double)0.8, (String)"fist_slam").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)PUNCH, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{PUNCH, DOUBLE_PUNCH, SLAM, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityTroll>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(PUNCH, e -> 1.0f), (int)1), class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(DOUBLE_PUNCH, e -> 1.0f), (int)1), class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(SLAM, e -> 1.0f), (int)1));
    private static final List<class_6008.class_6010<IdleAction<EntityTroll>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)3), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(12.0, 4)), (int)1));
    public final AnimatedAttackGoal<EntityTroll> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityTroll> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityTroll(class_1299<? extends EntityTroll> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.23);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{SLAM})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{SLAM})) {
            double range = (double)this.method_17681() * 2.1;
            return new class_238(-range * 0.5, -0.02, -range * 0.25, range * 0.5, (double)this.method_17682() + 0.02, range * 0.75);
        }
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 1.8;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void mobAttack(AnimatedAction anim, class_1309 target, Consumer<class_1309> cons) {
        super.mobAttack(anim, target, cons);
        if (anim.is(new AnimatedAction[]{SLAM})) {
            S2CScreenShake.sendAround((class_1297)this, 16.0, 10, 2.0f);
            this.field_6002.method_8396(null, this.method_24515(), class_3417.field_15152, this.method_5634(), 1.0f, 1.0f);
        }
    }

    @Override
    public CustomDamage.Builder damageSourceAttack() {
        CustomDamage.Builder source = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SLAM, DOUBLE_PUNCH})) {
            source.withChangedAttribute((class_1320)ModAttributes.STUN.get(), 30.0);
        }
        return source;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(SLAM);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(DOUBLE_PUNCH);
            } else {
                this.getAnimationHandler().setAnimation(PUNCH);
            }
        }
    }

    public AnimationHandler<EntityTroll> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 2.3125, -0.375);
    }
}

