/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.AirWanderGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntityVeggieGhost
extends BaseMonster {
    public static final AnimatedAction ATTACK = AnimatedAction.builder((double)1.16, (String)"head_attack").marker("attack", new double[]{0.68}).build();
    public static final AnimatedAction CAST = AnimatedAction.builder((double)0.68, (String)"cast").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction SPIN = AnimatedAction.builder((double)0.68, (String)"spin").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction VANISH = AnimatedAction.builder((double)5.0, (String)"vanish").marker("attack", new double[]{2.5}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)CAST, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{ATTACK, CAST, SPIN, VANISH, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityVeggieGhost>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeActionCondition(ATTACK, e -> 1.0f, ActionUtils.ranged((double)8.0)), (int)1), class_6008.method_34980(MonsterActionUtils.simpleMeleeActionCondition(SPIN, e -> 1.0f, ActionUtils.ranged((double)8.0)), (int)1), class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(CAST, 10.0, 5.0, 1.0, e -> 1.0f), (int)2), class_6008.method_34980((Object)new GoalAttackAction(VANISH).withCondition((goal, target, previous) -> ((EntityVeggieGhost)goal.attacker).shouldVanishNext(previous)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)4));
    private static final List<class_6008.class_6010<IdleAction<EntityVeggieGhost>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), class_6008.method_34980((Object)new IdleAction(() -> new StrafingRunner(16.0f, 5.0f)), (int)1));
    public final AnimatedAttackGoal<EntityVeggieGhost> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityVeggieGhost> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (anim != null && anim.is(new AnimatedAction[]{VANISH})) {
            this.vanishNext = (double)this.method_6051().nextFloat() < 0.6;
        }
        return false;
    });
    private boolean vanishNext;

    public EntityVeggieGhost(class_1299<? extends EntityVeggieGhost> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6280((class_1352)this.wander);
        this.wander = new AirWanderGoal(this);
        this.field_6201.method_6277(6, (class_1352)this.wander);
        this.field_6201.method_6280((class_1352)this.swimGoal);
        this.field_6201.method_6277(2, this.attack);
        this.field_5960 = true;
        this.field_6207 = new FreeMoveControl((class_1308)this);
        this.method_5875(true);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.35);
    }

    @Override
    protected class_1400<class_1657> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<class_1657>((class_1308)this, class_1657.class, 5, true, true, player -> !this.isTamed());
    }

    @Override
    protected class_1400<class_1308> createTargetGoalMobs() {
        return new NearestTargetHorizontal<class_1308>((class_1308)this, class_1308.class, 5, true, true, this.targetPred);
    }

    @Override
    public void method_6091(class_243 vec) {
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            this.field_5960 = entity.field_5960;
        } else {
            boolean bl = this.field_5960 = !this.playDeath();
            if (this.method_23318() < (double)(this.field_6002.method_31607() + 1)) {
                vec = new class_243(vec.field_1352, 0.006, vec.field_1350);
            }
        }
        this.handleFreeTravel(vec);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            return new OrientedBoundingBox(this.attackBB(anim), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            double attackSize = (double)this.method_17681() * 1.4;
            return new class_238(-attackSize, -0.2, -attackSize, attackSize, (double)this.method_17682() + 0.2, attackSize);
        }
        double width = (double)this.method_17681() * 1.6;
        double length = this.method_17681() * 2.0f;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{CAST})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.TRIPLE_FIRE_BALL.get())).use((class_1309)this);
            }
        } else if (anim.is(new AnimatedAction[]{VANISH})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                class_1309 target = this.method_5968();
                if (target == null) {
                    double rX = this.method_23317() + (this.field_5974.nextDouble() - 0.5) * 16.0;
                    double rY = this.method_23318() + (this.field_5974.nextDouble() - 0.5) * 4.0;
                    double rZ = this.method_23321() + (this.field_5974.nextDouble() - 0.5) * 16.0;
                    this.teleport(rX, rY, rZ);
                } else {
                    this.teleportTowards((class_1297)target);
                }
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{VANISH})) {
            return false;
        }
        boolean ret = super.method_5643(source, amount);
        if (ret) {
            this.vanishNext = (double)this.method_6051().nextFloat() < 0.4;
        }
        return ret;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 1 ? (Spell)((Object)ModSpells.TRIPLE_FIRE_BALL.get()) : null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CAST);
            } else {
                this.getAnimationHandler().setAnimation(ATTACK);
            }
        }
    }

    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    protected class_3414 method_5994() {
        return (class_3414)ModSounds.ENTITY_GHOST_AMBIENT.get();
    }

    private void teleportTowards(class_1297 entity) {
        class_243 look = new class_243(entity.method_5720().field_1352, 0.0, entity.method_5720().field_1350).method_1029().method_1021(-1.5);
        class_243 behindEntity = entity.method_19538().method_1019(look);
        class_243 dir = new class_243(behindEntity.field_1352 - this.method_23317(), behindEntity.field_1351 - this.method_23318(), behindEntity.field_1350 - this.method_23321());
        if (dir.method_1027() < 100.0) {
            this.teleport(behindEntity.field_1352, behindEntity.field_1351, behindEntity.field_1350);
        } else {
            dir = dir.method_1029();
            double e = this.method_23317() + this.field_5974.nextDouble() * 9.0 * dir.field_1352;
            double g = this.method_23321() + this.field_5974.nextDouble() * 9.0 * dir.field_1350;
            this.teleport(e, entity.method_23318(), g);
        }
    }

    private void teleport(double x, double y, double z) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(x, y, z);
        while (mutableBlockPos.method_10264() > this.field_6002.method_31607() && !this.field_6002.method_8320((class_2338)mutableBlockPos).method_26207().method_15801()) {
            mutableBlockPos.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.field_6002.method_8320((class_2338)mutableBlockPos);
        if (!blockState.method_26207().method_15801()) {
            y = this.method_23318();
        }
        this.method_5859(x, y + 1.0, z);
    }

    public boolean shouldVanishNext(String prev) {
        class_1309 target = this.method_5968();
        if (target != null && target.method_5858((class_1297)this) > 140.0) {
            return true;
        }
        return this.field_5974.nextFloat() < 0.2f || !prev.equals(VANISH.getID()) && this.vanishNext;
    }

    public AnimationHandler<EntityVeggieGhost> getAnimationHandler() {
        return this.animationHandler;
    }

    protected void method_5623(double dist, boolean groundLogic, class_2680 state, class_2338 pos) {
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.75, -0.25);
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }
}

