/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.AirWanderGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityWeagle
extends BaseMonster {
    public static final AnimatedAction GALE = AnimatedAction.builder((double)0.96, (String)"gale").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction PECK = AnimatedAction.builder((double)0.56, (String)"peck").marker("attack", new double[]{0.2}).build();
    public static final AnimatedAction SWOOP = AnimatedAction.builder((double)0.6, (String)"swoop").marker("swoop_start", new double[]{0.2}).marker("swoop_end", new double[]{0.48}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)PECK, (String)"interact");
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)2.0, (String)"defeat").infinite().build();
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{GALE, PECK, SWOOP, INTERACT, DEFEAT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityWeagle>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeActionInRange(PECK, e -> 1.0f), (int)1), class_6008.method_34980(MonsterActionUtils.simpleMeleeActionInRange(SWOOP, e -> 1.0f), (int)1), class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(GALE, 8.0, 4.0, 1.0, e -> 1.0f), (int)2));
    private static final List<class_6008.class_6010<IdleAction<EntityWeagle>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2), class_6008.method_34980((Object)new IdleAction(() -> new StrafingRunner(16.0f, 5.0f)), (int)1));
    public final AnimatedAttackGoal<EntityWeagle> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    protected List<class_1309> hitEntity;
    private final AnimationHandler<EntityWeagle> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        this.hitEntity = null;
        this.setSwoopMotion(null);
        return false;
    });
    private class_243 swoopMotion;

    public EntityWeagle(class_1299<? extends BaseMonster> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6280((class_1352)this.wander);
        this.wander = new AirWanderGoal(this);
        this.field_6201.method_6277(6, (class_1352)this.wander);
        this.field_6201.method_6277(2, this.attack);
        this.field_6207 = new FreeMoveControl((class_1308)this, 90.0f, 50.0f, FreeMoveControl.TRUE);
        this.method_5875(true);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23720).method_6192(0.33);
        this.method_5996(class_5134.field_23717).method_6192(32.0);
    }

    @Override
    protected class_1400<class_1657> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<class_1657>((class_1308)this, class_1657.class, 5, true, true, player -> !this.isTamed());
    }

    @Override
    protected class_1400<class_1308> createTargetGoalMobs() {
        return new NearestTargetHorizontal<class_1308>((class_1308)this, class_1308.class, 5, true, true, this.targetPred);
    }

    @Override
    public void method_6091(class_243 vec) {
        super.handleFreeTravel(vec);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.5;
        double length = (double)this.method_17681() * 1.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SWOOP})) {
            return this.swoopMotion;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{GALE})) {
            if (anim.isAt("attack")) {
                ((Spell)((Object)ModSpells.GUST_SPELL.get())).use((class_1309)this);
            }
        } else if (anim.is(new AnimatedAction[]{SWOOP})) {
            if (this.hitEntity == null) {
                this.hitEntity = new ArrayList<class_1309>();
            }
            if (this.swoopMotion == null) {
                this.setSwoopMotion(EntityUtils.getTargetDirection((class_1308)this, class_2183.class_2184.field_9853, true).method_1021(0.2).method_1031(0.0, -0.3, 0.0));
            }
            if (anim.isPast("swoop_start") && !anim.isPast("swoop_end")) {
                this.method_18799(this.swoopMotion);
                this.mobAttack(anim, null, e -> {
                    if (!this.hitEntity.contains(e)) {
                        this.hitEntity.add((class_1309)e);
                        this.method_6121((class_1297)e);
                    }
                });
            } else {
                this.method_18799(this.swoopMotion.method_18805(-1.0, -0.7, -1.0));
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        if (anim != null && anim.is(new AnimatedAction[]{GALE})) {
            int diffAdd = this.difficultyCooldown();
            return this.method_6051().nextInt(40) + 20 + diffAdd;
        }
        return super.animationCooldown(anim);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{SWOOP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1014(0.2).method_1014(grow), this.method_36454(), 0.0f, this.method_19538().method_1019(this.method_18798()));
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 2 ? (Spell)((Object)ModSpells.GUST_SPELL.get()) : null)) {
                return;
            }
            switch (command) {
                case 2: {
                    this.getAnimationHandler().setAnimation(GALE);
                    break;
                }
                case 1: {
                    this.getAnimationHandler().setAnimation(SWOOP);
                    break;
                }
                default: {
                    this.getAnimationHandler().setAnimation(PECK);
                }
            }
        }
    }

    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    protected void method_5801() {
        this.method_5783((class_3414)ModSounds.ENTITY_WEAGLE_FLAP.get(), this.method_6107(), (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
    }

    public AnimationHandler<EntityWeagle> getAnimationHandler() {
        return this.animationHandler;
    }

    protected void method_5623(double dist, boolean groundLogic, class_2680 state, class_2338 pos) {
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.0, -0.0625);
    }

    public void setSwoopMotion(class_243 swoopMotion) {
        this.swoopMotion = swoopMotion;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.swoopMotion);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, charge -> {
            this.swoopMotion = charge;
        });
    }
}

