/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.RestrictedWaterAvoidingStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityWolf
extends LeapingMonster {
    private static final AnimatedAction MELEE = AnimatedAction.builder((double)1.76, (String)"attack").marker("attack", new double[]{0.48, 0.84, 1.16, 1.52}).build();
    private static final AnimatedAction LEAP = AnimatedAction.builder((double)1.12, (String)"leap").marker("attack_start", new double[]{0.36}).marker("attack_end", new double[]{0.96}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, LEAP, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityWolf>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(MELEE, e -> 0.8f), (int)2), class_6008.method_34980((Object)new GoalAttackAction(LEAP).cooldown(e -> e.animationCooldown(LEAP)).prepare(() -> new WrappedRunner((ActionRun)new MoveAwayRunner(1.5, 1.0, 4))), (int)1), class_6008.method_34980((Object)new GoalAttackAction(LEAP).cooldown(e -> e.animationCooldown(LEAP)).prepare(() -> new WrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 4.0))), (int)2));
    private static final List<class_6008.class_6010<IdleAction<EntityWolf>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)1), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(16.0, 5)), (int)2));
    public final AnimatedAttackGoal<EntityWolf> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityWolf> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityWolf(class_1299<? extends EntityWolf> type, class_1937 world) {
        super((class_1299<? extends LeapingMonster>)type, world);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.3);
    }

    @Override
    public void addGoal() {
        super.addGoal();
        this.field_6201.method_6280((class_1352)this.wander);
        this.wander = new RestrictedWaterAvoidingStrollGoal(this, 0.6);
        this.field_6201.method_6277(6, (class_1352)this.wander);
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    protected class_3414 method_5994() {
        return class_3417.field_14575;
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_15218;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14659;
    }

    public float method_6017() {
        return (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 0.6f;
    }

    public AnimationHandler<? extends EntityWolf> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{MELEE})) {
            this.method_5942().method_6340();
            if (anim.isAt("attack")) {
                this.mobAttack(anim, this.method_5968(), target -> EntityWolf.wolfAttack((class_1309)this, (class_1297)target));
            }
        } else {
            super.handleAttack(anim);
        }
    }

    @Override
    protected boolean isLeapingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{LEAP});
    }

    @Override
    public class_243 getLeapVec(@Nullable class_243 target) {
        return super.getLeapVec(target).method_1021(1.1);
    }

    @Override
    public double leapHeightMotion() {
        return 0.2;
    }

    public static boolean wolfAttack(class_1309 attacker, class_1297 target) {
        CustomDamage.Builder source = new CustomDamage.Builder((class_1297)attacker).noKnockback().hurtResistant(1);
        return CombatUtils.mobAttack(attacker, target, source);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 2.1;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(LEAP);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.0625, -0.375);
    }
}

