/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster;

import io.github.flemmli97.runecraftory.common.entities.LeapingMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.lib.RunecraftoryTags;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.utils.LootTableResources;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.ActionUtils;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5712;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityWooly
extends LeapingMonster {
    private static final class_2940<Boolean> SHEARED = class_2945.method_12791(EntityWooly.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> SPAWNSHEARED = class_2945.method_12791(EntityWooly.class, (class_2941)class_2943.field_13323);
    public static final AnimatedAction SLAP = AnimatedAction.builder((double)0.76, (String)"slap").marker("attack", new double[]{0.28, 0.56}).build();
    public static final AnimatedAction KICK = AnimatedAction.builder((double)1.0, (String)"kick").marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{0.92}).build();
    public static final AnimatedAction HEADBUTT = AnimatedAction.builder((double)0.8, (String)"headbutt").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)HEADBUTT, (String)"interact");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    public static final AnimatedAction[] ANIMS = new AnimatedAction[]{SLAP, KICK, HEADBUTT, INTERACT, SLEEP};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityWooly>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(SLAP, EntityWooly::attackChance), (int)2), class_6008.method_34980((Object)new GoalAttackAction(KICK).cooldown(e -> e.animationCooldown(KICK)).withCondition(ActionUtils.chanced(EntityWooly::attackChance)).prepare(() -> new WrappedRunner((ActionRun)new MoveAwayRunner(1.5, 1.0, 4))), (int)1), class_6008.method_34980((Object)new GoalAttackAction(KICK).cooldown(e -> e.animationCooldown(KICK)).withCondition(ActionUtils.chanced(EntityWooly::attackChance)).prepare(() -> new WrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 3.0))), (int)1), class_6008.method_34980(MonsterActionUtils.simpleMeleeAction(HEADBUTT, EntityWooly::attackChance), (int)2));
    private static final List<class_6008.class_6010<IdleAction<EntityWooly>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)), (int)1), class_6008.method_34980((Object)new IdleAction(() -> new RandomMoveAroundRunner(10.0, 5)), (int)2), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new).duration(e -> e.method_6051().nextInt(10) + 15), (int)3));
    public final AnimatedAttackGoal<EntityWooly> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityWooly> animationHandler = new AnimationHandler((class_1297)this, ANIMS);

    public EntityWooly(class_1299<? extends EntityWooly> type, class_1937 level) {
        super((class_1299<? extends LeapingMonster>)type, level);
        this.field_6201.method_6277(2, this.attack);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SPAWNSHEARED, (Object)((double)this.method_6051().nextFloat() < 0.05 ? 1 : 0));
        this.field_6011.method_12784(SHEARED, (Object)((Boolean)this.field_6011.method_12789(SPAWNSHEARED)));
    }

    @Override
    protected boolean isLeapingAnim(AnimatedAction anim) {
        return anim.is(new AnimatedAction[]{KICK});
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.22);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Sheared", this.isSheared());
        compound.method_10556("SpawnedSheared", ((Boolean)this.field_6011.method_12789(SPAWNSHEARED)).booleanValue());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setSheared(compound.method_10577("Sheared"));
        this.field_6011.method_12778(SPAWNSHEARED, (Object)compound.method_10577("SpawnedSheared"));
    }

    @Override
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        if (itemStack.method_31573(RunecraftoryTags.SHEARS)) {
            if (!(this.field_6002.field_9236 || this.isSheared() || this.isTamed() && !player.method_5667().equals(this.method_6139()))) {
                this.shear(player, itemStack);
                itemStack.method_7956(1, (class_1309)player, playerx -> playerx.method_20236(hand));
                return class_1269.field_5812;
            }
            return class_1269.field_21466;
        }
        return super.method_5992(player, hand);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 1.9;
        if (anim.is(new AnimatedAction[]{HEADBUTT, KICK})) {
            length *= 1.5;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(KICK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(HEADBUTT);
            } else {
                this.getAnimationHandler().setAnimation(SLAP);
            }
        }
    }

    @Override
    protected void tameEntity(class_1657 owner) {
        super.tameEntity(owner);
        this.field_6011.method_12778(SPAWNSHEARED, (Object)false);
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_14730;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14814;
    }

    public float method_6017() {
        return (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.7f;
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_6051().nextInt(20) + 30 + diffAdd;
        }
        return this.method_6051().nextInt(30) + 30 + diffAdd;
    }

    public AnimationHandler<EntityWooly> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void onDailyUpdate() {
        super.onDailyUpdate();
        if (!((Boolean)this.field_6011.method_12789(SPAWNSHEARED)).booleanValue() || this.isTamed()) {
            this.setSheared(false);
        }
    }

    protected class_2960 method_5991() {
        if (this.isSheared()) {
            return super.method_5991();
        }
        return LootTableResources.WOOLED_WHITE_LOOT;
    }

    public boolean isSheared() {
        return (Boolean)this.field_6011.method_12789(SHEARED);
    }

    public void setSheared(boolean flag) {
        this.field_6011.method_12778(SHEARED, (Object)flag);
    }

    public void shear(class_1657 player, class_1799 used) {
        class_52 lootTable = this.field_6002.method_8503().method_3857().method_367(EntityWooly.shearedLootTable(this.method_5991()));
        lootTable.method_320(this.dailyDropContext().method_306(LootCtxParameters.UUID_CONTEXT, (Object)player.method_5667()).method_306(class_181.field_1229, (Object)used).method_309(LootCtxParameters.MONSTER_INTERACTION), arg_0 -> ((EntityWooly)this).method_5775(arg_0));
        this.setSheared(true);
        this.method_5783(class_3417.field_14975, 1.0f, 1.0f);
        this.method_32875(class_5712.field_28730, (class_1297)player);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.84375, -0.375);
    }

    protected float attackChance() {
        return (Boolean)this.method_5841().method_12789(SPAWNSHEARED) != false || this.isTamed() ? 0.8f : 0.0f;
    }

    public static class_2960 shearedLootTable(class_2960 def) {
        return new class_2960(def.method_12836(), def.method_12832() + "_sheared_drops");
    }
}

