/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityPollen;
import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntityAmbrosia
extends BossMonster {
    public static final AnimatedAction KICK_1 = AnimatedAction.builder((double)0.6, (String)"kick_1").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction KICK_2 = AnimatedAction.builder((double)0.6, (String)"kick_2").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction KICK_3 = AnimatedAction.builder((double)0.84, (String)"kick_3").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction BUTTERFLY = AnimatedAction.builder((double)2.04, (String)"butterfly").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction WAVE = AnimatedAction.builder((double)2.24, (String)"wave").marker("attack", new double[]{0.24}).build();
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.76, (String)"sleep").marker("attack", new double[]{0.24}).build();
    public static final AnimatedAction POLLEN = AnimatedAction.builder((double)0.72, (String)"pollen").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction POLLEN_2 = AnimatedAction.copyOf((AnimatedAction)POLLEN, (String)"pollen_2");
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction ANGRY = AnimatedAction.builder((double)2.4, (String)"angry").build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)KICK_1, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{KICK_1, BUTTERFLY, WAVE, SLEEP, POLLEN, POLLEN_2, KICK_2, KICK_3, DEFEAT, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityAmbrosia>> ATTACK_HANDLER = EntityAmbrosia.createAnimationHandler(b -> {
        b.put((Object)BUTTERFLY, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.BUTTERFLY.get())))).use((class_1309)entity);
            }
        });
        BiConsumer<AnimatedAction, EntityAmbrosia> kick = (anim, entity) -> {
            class_1309 target = entity.method_5968();
            if (target != null) {
                entity.method_5942().method_6335((class_1297)target, 1.0);
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, entity::method_6121);
            }
        };
        b.put((Object)KICK_1, kick);
        b.put((Object)KICK_2, kick);
        b.put((Object)KICK_3, kick);
        b.put((Object)SLEEP, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.SLEEP_BALLS.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)WAVE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.WAVE.get())))).use((class_1309)entity);
            }
        });
        BiConsumer<AnimatedAction, EntityAmbrosia> pollenHandler = (anim, entity) -> {
            if (entity.moveDirection == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.35));
            }
            entity.method_18799(entity.moveDirection);
            if (anim.isAt("attack") && !EntityUtils.sealed((class_1309)entity)) {
                entity.method_5942().method_6340();
                EntityPollen pollen = new EntityPollen(entity.field_6002, (class_1309)entity);
                pollen.method_5814(pollen.method_23317(), pollen.method_23318() + 0.5, pollen.method_23321());
                entity.field_6002.method_8649((class_1297)pollen);
            }
        };
        b.put((Object)POLLEN, pollenHandler);
        b.put((Object)POLLEN_2, pollenHandler);
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntityAmbrosia>>> ATTACKS = List.of(class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(BUTTERFLY).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(4.5, 1.1, 6), e -> 40 + e.method_6051().nextInt(10))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(KICK_1).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 50 + e.method_6051().nextInt(10))), (int)11), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(SLEEP).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.2, 2.0), e -> 50 + e.method_6051().nextInt(10))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(WAVE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 1.5), e -> 20 + e.method_6051().nextInt(10))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.enragedBossAttack(POLLEN).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 2.0), e -> 45 + e.method_6051().nextInt(10))), (int)9));
    private static final List<class_6008.class_6010<IdleAction<EntityAmbrosia>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new StrafingRunner(7.0f, 5.0f, 1.0f, 0.2f)), (int)1));
    public final AnimatedAttackGoal<EntityAmbrosia> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityAmbrosia> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.field_6002.field_9236 && anim == null) {
            AnimatedAction chainAnim;
            boolean chain = !this.commanded;
            this.setMoveDirection(null);
            this.commanded = false;
            if (chain && (chainAnim = this.chainAnim(this.getAnimationHandler().getAnimation())) != null) {
                this.getAnimationHandler().setAnimation(chainAnim);
                return true;
            }
        }
        return false;
    });
    private boolean commanded;
    private class_243 moveDirection;

    public EntityAmbrosia(class_1299<? extends EntityAmbrosia> type, class_1937 world) {
        super((class_1299<? extends BossMonster>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795).setMusic((class_3414)ModSounds.AMBROSIA_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.29);
        super.applyAttributes();
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{WAVE, ANGRY})) && super.method_5643(source, amount);
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{POLLEN, ANGRY, DEFEAT})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    public boolean shouldFreezeTravel() {
        return this.getAnimationHandler().isCurrent(new AnimatedAction[]{WAVE});
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{POLLEN, POLLEN_2})) {
            return this.moveDirection;
        }
        return super.directionToLookAt();
    }

    @Override
    public void setupAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{BUTTERFLY}) && this.method_5968() != null) {
            class_1309 target = this.method_5968();
            this.setTargetPosition(new MobAttackExt.TargetPosition(target.method_19538(), target.method_23318(), target.method_23318() + (double)target.method_17682() * 0.3));
        } else {
            super.setupAttack(anim);
        }
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{POLLEN})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 2.0, grow, grow + 2.0), this.method_36454(), this.method_36455(), this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.6;
        double length = (double)this.method_17681() * 2.1;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.WAVE.get()))) {
                    this.getAnimationHandler().setAnimation(WAVE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.SLEEP_BALLS.get()))) {
                    this.getAnimationHandler().setAnimation(SLEEP);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                this.getAnimationHandler().setAnimation(KICK_1);
            }
            this.commanded = true;
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.8125, -0.3125);
    }

    public AnimationHandler<EntityAmbrosia> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean allowAnimation(String prev, AnimatedAction other) {
        if (prev.equals(POLLEN_2.getID())) {
            return !POLLEN.is(new AnimatedAction[]{other});
        }
        if (prev.equals(KICK_3.getID())) {
            return !KICK_1.is(new AnimatedAction[]{other});
        }
        return super.allowAnimation(prev, other);
    }

    public AnimatedAction chainAnim(AnimatedAction anim) {
        if (anim == null) {
            return null;
        }
        return switch (anim.getID()) {
            case "kick_1" -> KICK_2;
            case "kick_2" -> KICK_3;
            case "pollen" -> POLLEN_2;
            default -> null;
        };
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    protected void setMoveDirection(class_243 moveDirection) {
        this.moveDirection = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.moveDirection);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.moveDirection = motion;
        });
    }
}

