/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.RestrictedWaterAvoidingStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntityChimera
extends BossMonster {
    public static final AnimatedAction LEAP = AnimatedAction.builder((double)1.36, (String)"leap").marker("attack_start", new double[]{0.0}).marker("attack_end", new double[]{1.2}).build();
    public static final AnimatedAction FIRE_TAIL_BUBBLE = AnimatedAction.builder((double)1.48, (String)"tail_beam").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction WATER_TAIL_BUBBLE = AnimatedAction.copyOf((AnimatedAction)FIRE_TAIL_BUBBLE, (String)"water_tail_bubble");
    public static final AnimatedAction WATER_TAIL_BEAM = AnimatedAction.copyOf((AnimatedAction)FIRE_TAIL_BUBBLE, (String)"water_tail_beam");
    public static final AnimatedAction FIRE_BREATH = AnimatedAction.builder((double)1.2, (String)"breath_attack").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction BUBBLE_BEAM = AnimatedAction.copyOf((AnimatedAction)FIRE_BREATH, (String)"bubble_beam");
    public static final AnimatedAction SLASH = AnimatedAction.builder((double)0.64, (String)"claw_attack").marker("attack", new double[]{0.36, 0.72}).build();
    public static final AnimatedAction BITE = AnimatedAction.builder((double)1.04, (String)"bite_attack").marker("attack_1", new double[]{0.4}).marker("attack_2", new double[]{0.72}).build();
    public static final AnimatedAction ANGRY = new AnimatedAction(1.04, "angry");
    public static final AnimatedAction SLEEP = AnimatedAction.builder((double)0.0, (String)"sleep").infinite().build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)SLASH, (String)"interact");
    private static final AnimatedAction[] ANIMATED_ACTIONS = new AnimatedAction[]{LEAP, FIRE_TAIL_BUBBLE, WATER_TAIL_BUBBLE, WATER_TAIL_BEAM, FIRE_BREATH, BUBBLE_BEAM, SLASH, BITE, DEFEAT, INTERACT, ANGRY, SLEEP};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityChimera>> ATTACK_HANDLER = EntityChimera.createAnimationHandler(b -> {
        BiConsumer<AnimatedAction, EntityChimera> summonFire = (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.FIREBALL_BARRAGE.get())))).use((class_1309)entity);
            }
        };
        b.put((Object)FIRE_TAIL_BUBBLE, summonFire);
        b.put((Object)FIRE_BREATH, summonFire);
        BiConsumer<AnimatedAction, EntityChimera> summonWater = (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.BUBBLE_BEAM.get())))).use((class_1309)entity);
            }
        };
        b.put((Object)BUBBLE_BEAM, summonWater);
        b.put((Object)WATER_TAIL_BUBBLE, summonWater);
        b.put((Object)WATER_TAIL_BEAM, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.WATER_LASER.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)LEAP, (anim, entity) -> {
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (entity.hitEntity == null) {
                    entity.hitEntity = new ArrayList<class_1309>();
                }
                if (entity.chargeMotion == null) {
                    class_243 dir = EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.4);
                    entity.setChargeMotion(new class_243(dir.field_1352, 0.0, dir.field_1350));
                }
                entity.method_18800(entity.chargeMotion.field_1352, entity.method_18798().field_1351, entity.chargeMotion.field_1350);
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new CustomDamage.Builder((class_1297)entity).hurtResistant(5).knock(CustomDamage.KnockBackType.UP))) {
                        entity.chargeAttackSuccess = true;
                        entity.hitEntity.add((class_1309)e);
                    }
                });
            }
        });
        b.put((Object)SLASH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.SLASH.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)BITE, (anim, entity) -> {
            if (anim.isAt("attack_1")) {
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), e -> CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new CustomDamage.Builder((class_1297)entity).hurtResistant(5).knockAmount(0.0f)));
            } else if (anim.isAt("attack_2")) {
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), entity::method_6121);
            }
        });
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntityChimera>>> ATTACKS = List.of(class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(LEAP).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 4.0), e -> 30 + e.method_6051().nextInt(15))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(FIRE_TAIL_BUBBLE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.method_6051().nextInt(15))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(WATER_TAIL_BUBBLE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.method_6051().nextInt(15))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(WATER_TAIL_BEAM).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.method_6051().nextInt(15))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(FIRE_BREATH).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.method_6051().nextInt(15))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(BUBBLE_BEAM).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.method_6051().nextInt(15))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(SLASH).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 30 + e.method_6051().nextInt(15))), (int)10));
    private static final List<class_6008.class_6010<IdleAction<EntityChimera>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.1, 1.0)), (int)9), class_6008.method_34980((Object)new IdleAction(() -> new MoveAwayRunner(4.0, 1.0, 6)), (int)10));
    public final AnimatedAttackGoal<EntityChimera> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityChimera> animationHandler = new AnimationHandler((class_1297)this, ANIMATED_ACTIONS).withChangeListener(anim -> {
        if (!this.field_6002.field_9236) {
            if (anim == null) {
                this.setChargeMotion(null);
            }
            if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{LEAP})) {
                this.hitEntity = null;
                if (this.chargeAttackSuccess) {
                    this.chargeAttackSuccess = false;
                    this.getAnimationHandler().setAnimation(BITE);
                    return true;
                }
            }
            return false;
        }
        return false;
    });
    protected boolean chargeAttackSuccess;
    private class_243 chargeMotion;
    protected List<class_1309> hitEntity;

    public EntityChimera(class_1299<? extends EntityChimera> type, class_1937 world) {
        super((class_1299<? extends BossMonster>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
        this.field_6013 = 1.0f;
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5795).setMusic((class_3414)ModSounds.CHIMERA_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.31);
        super.applyAttributes();
    }

    @Override
    public void addGoal() {
        super.addGoal();
        this.field_6201.method_6280((class_1352)this.wander);
        this.wander = new RestrictedWaterAvoidingStrollGoal(this, 0.6);
        this.field_6201.method_6277(6, (class_1352)this.wander);
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{DEFEAT, ANGRY})) && super.method_5643(source, amount);
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT, LEAP})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.6;
        double length = (double)this.method_17681() * 1.7;
        if (anim.is(new AnimatedAction[]{BITE})) {
            width = (double)this.method_17681() * 1.2;
            length = (double)this.method_17681() * 1.3;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        class_243 dir;
        float offset;
        if (anim.is(new AnimatedAction[]{LEAP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(0.3, 0.1, 0.3 + this.method_18798().method_1021(0.3).method_1033()), this.method_36454(), 0.0f, this.method_19538());
        }
        if (!anim.is(new AnimatedAction[]{BITE})) {
            return super.calculateAttackAABB(anim, target, grow);
        }
        double reach = (double)this.method_17681() * 0.9;
        float f = offset = anim.isAt("attack") ? 45.0f : -5.0f;
        if (target != null && !this.method_5956()) {
            reach = Math.min(reach, this.method_19538().method_1022(target));
            dir = MathUtils.rotate((class_243)MathUtils.NORMAL_Y, (class_243)target.method_1020(this.method_19538()).method_1029(), (float)(offset * ((float)Math.PI / 180)));
        } else {
            class_1297 class_12972 = this.method_5642();
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                dir = class_243.method_1030((float)player.method_36455(), (float)(player.method_36454() + offset));
            } else {
                dir = class_243.method_1030((float)this.method_36455(), (float)(this.method_36454() + offset));
            }
        }
        class_243 attackPos = this.method_19538().method_1019(dir.method_1021(reach));
        return new OrientedBoundingBox(this.attackBB(anim).method_1009(grow, 0.0, grow), this.method_36454() + 45.0f, 0.0f, attackPos);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.BUBBLE_BEAM.get()))) {
                    this.getAnimationHandler().setAnimation(BUBBLE_BEAM);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.SLASH.get()))) {
                    this.getAnimationHandler().setAnimation(SLASH);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                this.getAnimationHandler().setAnimation(LEAP);
            }
        }
    }

    protected class_3414 method_5994() {
        return (class_3414)ModSounds.ENTITY_CHIMERA_AMBIENT.get();
    }

    @Override
    public double ridingSpeedModifier() {
        return 1.5;
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{LEAP})) {
            return this.chargeMotion;
        }
        return super.directionToLookAt();
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.421875, -0.3125);
    }

    public void setChargeMotion(class_243 charge) {
        this.chargeMotion = charge;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.chargeMotion);
    }

    public AnimationHandler<EntityChimera> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.chargeMotion = motion;
        });
    }
}

