/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.spells.HealT1Spell;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_11;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityDeadTree
extends BossMonster {
    private static final class_2940<Byte> SUMMON_ANIMATION = class_2945.method_12791(EntityDeadTree.class, (class_2941)class_2943.field_13319);
    public static final AnimatedAction ATTACK = AnimatedAction.builder((double)0.92, (String)"attack").marker("attack", new double[]{0.44, 0.68}).build();
    public static final AnimatedAction FALLING_APPLES = AnimatedAction.builder((double)0.72, (String)"falling_apples").marker("attack", new double[]{0.36}).withClientID("summon").build();
    public static final AnimatedAction APPLE_SHIELD = AnimatedAction.copyOf((AnimatedAction)FALLING_APPLES, (String)"apple_shield");
    public static final AnimatedAction SPIKE = AnimatedAction.copyOf((AnimatedAction)FALLING_APPLES, (String)"spike");
    public static final AnimatedAction BIG_FALLING_APPLES = AnimatedAction.copyOf((AnimatedAction)FALLING_APPLES, (String)"big_falling_apples");
    public static final AnimatedAction MORE_FALLING_APPLES = AnimatedAction.copyOf((AnimatedAction)FALLING_APPLES, (String)"more_falling_apples");
    public static final AnimatedAction HEAL = AnimatedAction.copyOf((AnimatedAction)FALLING_APPLES, (String)"heal");
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction ANGRY = AnimatedAction.builder((double)1.24, (String)"angry").build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)ATTACK, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{ATTACK, FALLING_APPLES, APPLE_SHIELD, SPIKE, BIG_FALLING_APPLES, MORE_FALLING_APPLES, HEAL, DEFEAT, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityDeadTree>> ATTACK_HANDLER = EntityDeadTree.createAnimationHandler(b -> {
        b.put((Object)ATTACK, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), entity::method_6121);
            }
        });
        b.put((Object)FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.APPLE_RAIN.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)APPLE_SHIELD, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.APPLE_SHIELD.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)BIG_FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.APPLE_RAIN_BIG.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)MORE_FALLING_APPLES, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.APPLE_RAIN_MORE.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)SPIKE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.ROOT_SPIKE_TRIPLE.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)HEAL, (anim, entity) -> {
            if (anim.isAt("attack")) {
                float healAmount = (float)(CombatUtils.getAttributeValue((class_1297)entity, (class_1320)ModAttributes.MAGIC.get()) * 2.0);
                entity.method_6025(healAmount);
                class_3218 serverLevel = (class_3218)entity.field_6002;
                serverLevel.method_14199((class_2394)class_2398.field_11201, entity.method_23317(), entity.method_23318() + (double)entity.method_17682() + 0.5, entity.method_23321(), 0, 0.0, 0.1, 0.0, 0.0);
                HealT1Spell.spawnHealParticles((class_1309)entity);
                HealT1Spell.spawnHealParticles((class_1309)entity);
                HealT1Spell.spawnHealParticles((class_1309)entity);
            }
        });
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntityDeadTree>>> ATTACKS = List.of(class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(ATTACK).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.0), e -> 35 + e.method_6051().nextInt(15))), (int)9), class_6008.method_34980((Object)new GoalAttackAction(FALLING_APPLES).cooldown(e -> e.animationCooldown(FALLING_APPLES)).withCondition((goal, target, previous) -> !((EntityDeadTree)goal.attacker).isEnraged()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 4.0), e -> 35 + e.method_6051().nextInt(15))), (int)10), class_6008.method_34980((Object)new GoalAttackAction(APPLE_SHIELD).cooldown(e -> e.animationCooldown(APPLE_SHIELD)).withCondition((goal, target, previous) -> ((EntityDeadTree)goal.attacker).shieldCooldown <= 0).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(SPIKE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)9), class_6008.method_34980((Object)new GoalAttackAction(BIG_FALLING_APPLES).cooldown(e -> e.animationCooldown(BIG_FALLING_APPLES)).withCondition((goal, target, previous) -> ((EntityDeadTree)goal.attacker).isEnraged()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 4.0), e -> 40 + e.method_6051().nextInt(20))), (int)9), class_6008.method_34980((Object)new GoalAttackAction(MORE_FALLING_APPLES).cooldown(e -> e.animationCooldown(MORE_FALLING_APPLES)).withCondition((goal, target, previous) -> ((EntityDeadTree)goal.attacker).isEnraged()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 4.0), e -> 40 + e.method_6051().nextInt(20))), (int)10), class_6008.method_34980((Object)new GoalAttackAction(HEAL).cooldown(e -> e.animationCooldown(HEAL)).withCondition((goal, target, previous) -> ((EntityDeadTree)goal.attacker).healCooldown <= 0).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)11));
    private static final List<class_6008.class_6010<IdleAction<EntityDeadTree>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 3.0)), (int)1));
    public final AnimatedAttackGoal<EntityDeadTree> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityDeadTree> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.field_6002.field_9236 && anim != null) {
            if (anim.is(new AnimatedAction[]{APPLE_SHIELD})) {
                this.shieldCooldown = 100;
            }
            if (anim.is(new AnimatedAction[]{HEAL})) {
                this.healCooldown = 100;
            }
        } else if (anim != null && anim.getClientIdentifier().equals("summon")) {
            int rand = this.field_5974.nextInt(3);
            AnimatedAction animNew = AnimatedAction.builder((double)anim.getLength(), (String)anim.getID()).withClientID(anim.getClientIdentifier() + "_" + rand).withTransitionTime(anim.getStartTransition(), anim.getEndTransitionTime()).speed(anim.getSpeed()).build();
            this.getAnimationHandler().setAnimation(animNew);
            return true;
        }
        return false;
    });
    private int shieldCooldown;
    private int healCooldown;

    public EntityDeadTree(class_1299<? extends EntityDeadTree> type, class_1937 world) {
        super((class_1299<? extends BossMonster>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795).setMusic((class_3414)ModSounds.DEAD_TREE_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.25);
        super.applyAttributes();
    }

    protected class_1408 method_5965(class_1937 level) {
        return new class_1409((class_1308)this, level){

            @Nullable
            protected class_11 method_18416(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                if (!EntityDeadTree.this.canMove()) {
                    return null;
                }
                return super.method_18416(targets, regionOffset, offsetUpward, accuracy, followRange);
            }
        };
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SUMMON_ANIMATION, (Object)0);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.25f;
    }

    public byte summonAnimationType() {
        return (Byte)this.field_6011.method_12789(SUMMON_ANIMATION);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            --this.shieldCooldown;
            --this.healCooldown;
        }
    }

    @Override
    public int animationCooldown(AnimatedAction anim) {
        int cooldown = super.animationCooldown(anim);
        if (anim != null && anim.is(new AnimatedAction[]{SPIKE})) {
            cooldown += 40;
        }
        return cooldown;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY})) && super.method_5643(source, amount);
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT})) {
            return;
        }
        if (!this.canMove()) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 2.1;
        double length = (double)this.method_17681() * 1.85;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        this.method_5942().method_6340();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.ROOT_SPIKE_TRIPLE.get()))) {
                    this.getAnimationHandler().setAnimation(SPIKE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.APPLE_RAIN.get()))) {
                    this.getAnimationHandler().setAnimation(FALLING_APPLES);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                this.getAnimationHandler().setAnimation(ATTACK);
            }
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14562;
    }

    protected class_3414 method_6002() {
        return (class_3414)ModSounds.ENTITY_DEAD_TREE_DEATH.get();
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 3.5625, -0.1875).method_1021(2.0);
    }

    public AnimationHandler<EntityDeadTree> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return DEFEAT;
    }

    public boolean canMove() {
        return this.isTamed() || this.isEnraged();
    }
}

