/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1160;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntityGrimoire
extends BossMonster {
    private static final List<class_1160> CIRCLE_PARTICLE_MOTION = RayTraceUtils.rotatedVecs((class_243)new class_243(0.25, 0.0, 0.0), (class_243)new class_243(0.0, 1.0, 0.0), (float)-180.0f, (float)175.0f, (float)5.0f);
    public static final AnimatedAction TAIL_SWIPE = AnimatedAction.builder((double)0.84, (String)"tail_swipe").marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction BITE = AnimatedAction.builder((double)0.8, (String)"bite").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction GUST = AnimatedAction.builder((double)1.96, (String)"gust").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction CHARGE = AnimatedAction.builder((double)1.72, (String)"charge").infinite().marker("charge_start", new double[]{0.16}).marker("charge_end", new double[]{1.6}).build();
    public static final AnimatedAction CHARGE_LAND = AnimatedAction.builder((double)0.48, (String)"charge_land").marker("attack", new double[]{0.16}).build();
    public static final AnimatedAction WIND_BREATH = AnimatedAction.builder((double)1.36, (String)"wind_breath").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction TORNADO = AnimatedAction.builder((double)1.24, (String)"tornado").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction ANGRY = new AnimatedAction(1.44, "angry");
    public static final AnimatedAction SLEEP = new AnimatedAction(0.0, "sleep");
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)TAIL_SWIPE, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{TAIL_SWIPE, BITE, GUST, CHARGE, CHARGE_LAND, WIND_BREATH, TORNADO, DEFEAT, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityGrimoire>> ATTACK_HANDLER = EntityGrimoire.createAnimationHandler(b -> {
        BiConsumer<AnimatedAction, EntityGrimoire> melee = (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), entity::method_6121);
            }
        };
        b.put((Object)TAIL_SWIPE, melee);
        b.put((Object)BITE, melee);
        b.put((Object)GUST, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.GUST_ROCKS.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)WIND_BREATH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.WIND_BLADE_BARRAGE.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)TORNADO, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.TORNADO.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)CHARGE, (anim, entity) -> {
            if (anim.isPast("charge_start") && !anim.isPast("charge_end")) {
                if (entity.hitEntity == null) {
                    entity.hitEntity = new ArrayList<class_1309>();
                }
                if (entity.moveDirection == null) {
                    entity.setMoveDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.35));
                }
                entity.method_18799(entity.moveDirection);
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new CustomDamage.Builder((class_1297)entity).hurtResistant(5).knock(CustomDamage.KnockBackType.BACK).knockAmount(2.0f))) {
                        entity.hitEntity.add((class_1309)e);
                    }
                });
            }
            if (anim.isPast("charge_end")) {
                entity.method_18799(entity.method_18798().method_1031(0.0, -0.06, 0.0));
                if (entity.method_18798().field_1351 < -0.72) {
                    entity.method_18800(entity.method_18798().field_1352, -0.72, entity.method_18798().field_1350);
                }
                if (entity.method_24828()) {
                    entity.getAnimationHandler().setAnimation(CHARGE_LAND);
                }
                if (!(!anim.isPast(6.0) || entity.method_36601().method_27852(class_2246.field_10124) && entity.method_25936().method_27852(class_2246.field_10124))) {
                    entity.getAnimationHandler().setAnimation(CHARGE_LAND);
                }
            }
        });
        b.put((Object)CHARGE_LAND, (anim, entity) -> {
            if (anim.isAt("attack")) {
                CustomDamage.Builder source = new CustomDamage.Builder((class_1297)entity).noKnockback().element(EnumElement.WIND).hurtResistant(5);
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), e -> CombatUtils.mobAttack((class_1309)entity, (class_1297)e, source));
                S2CScreenShake.sendAround((class_1297)entity, 24.0, 4, 3.0f);
                entity.field_6002.method_8396(null, entity.method_24515(), class_3417.field_15152, entity.method_5634(), 1.0f, 0.9f);
                entity.field_6002.method_8421((class_1297)entity, (byte)66);
            }
        });
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntityGrimoire>>> ATTACKS = List.of(class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(TAIL_SWIPE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 40 + e.method_6051().nextInt(15))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(BITE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 40 + e.method_6051().nextInt(15))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(GUST).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(4.0, 1.0, 7), e -> 40 + e.method_6051().nextInt(15))), (int)9), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(CHARGE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 6.0), e -> 40 + e.method_6051().nextInt(15))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(WIND_BREATH).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(4.0, 1.0, 6), e -> 40 + e.method_6051().nextInt(20))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.enragedBossAttack(TORNADO).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(3.0, 1.0, 6), e -> 40 + e.method_6051().nextInt(15))), (int)10));
    private static final List<class_6008.class_6010<IdleAction<EntityGrimoire>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 1.5)), (int)1));
    public final AnimatedAttackGoal<EntityGrimoire> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityGrimoire> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (CHARGE.is(new AnimatedAction[]{anim})) {
            this.hitEntity = null;
        }
        if (!this.field_6002.field_9236 && anim == null) {
            boolean chain = !this.commanded;
            this.setMoveDirection(null);
            this.commanded = false;
            if (chain && this.isEnraged() && this.getAnimationHandler().isCurrent(new AnimatedAction[]{BITE})) {
                this.getAnimationHandler().setAnimation(TAIL_SWIPE);
                return true;
            }
        }
        return false;
    });
    private boolean commanded;
    protected List<class_1309> hitEntity;
    private class_243 moveDirection;

    public EntityGrimoire(class_1299<? extends EntityGrimoire> type, class_1937 world) {
        super((class_1299<? extends BossMonster>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795).setMusic((class_3414)ModSounds.GRIMOIRE_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.29);
        super.applyAttributes();
    }

    @Override
    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return !this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY}) && super.method_5643(source, amount);
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT, CHARGE})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE, CHARGE_LAND})) {
            return this.moveDirection;
        }
        return super.directionToLookAt();
    }

    @Override
    public void method_5711(byte id) {
        super.method_5711(id);
        if (id == 66) {
            for (class_1160 vec : CIRCLE_PARTICLE_MOTION) {
                this.field_6002.method_8406((class_2394)new ColoredParticleData((class_2396)ModParticles.WIND.get(), 0.2627451f, 0.6392157f, 0.25490198f, 1.0f, 0.4f), this.method_23317(), this.method_23318() + 0.2, this.method_23321(), (double)vec.method_4943(), (double)vec.method_4945(), (double)vec.method_4947());
            }
        }
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{CHARGE_LAND})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(1.2, 0.1, 1.2), this.method_36454(), 0.0f, this.method_19538());
        }
        if (anim.is(new AnimatedAction[]{CHARGE})) {
            double width = this.method_17681();
            double speed = Math.max(width, this.method_18798().method_1033() - width);
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 0.5, 0.1, grow + 0.5).method_1012(0.0, 0.0, speed), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 1.5;
        if (anim.is(new AnimatedAction[]{TAIL_SWIPE})) {
            width = (double)this.method_17681() * 1.5;
            length = (double)this.method_17681() * 1.45;
            return new class_238(-width * 0.65, -0.02, 0.0, width * 0.35, (double)this.method_17682() + 0.02, length);
        }
        if (anim.is(new AnimatedAction[]{BITE})) {
            width = (double)this.method_17681() * 1.1;
            length = (double)this.method_17681() * 1.4;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.WIND_BLADE_BARRAGE.get()))) {
                    this.getAnimationHandler().setAnimation(WIND_BREATH);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                    this.getAnimationHandler().setAnimation(TAIL_SWIPE);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                this.getAnimationHandler().setAnimation(BITE);
            }
            this.commanded = true;
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 2.4375, 0.71875).method_1021(1.5);
    }

    public AnimationHandler<EntityGrimoire> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean allowAnimation(String prev, AnimatedAction other) {
        if (prev.equals(BITE.getID())) {
            return !this.isEnraged() || !TAIL_SWIPE.is(new AnimatedAction[]{other});
        }
        return super.allowAnimation(prev, other);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return SLEEP;
    }

    protected void setMoveDirection(class_243 moveDirection) {
        this.moveDirection = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.moveDirection);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.moveDirection = motion;
        });
    }
}

