/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetHorizontal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.MathsHelper;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1335;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntityHandonetta
extends BossMonster {
    public static final AnimatedAction SWIPE = AnimatedAction.builder((double)1.28, (String)"swipe").marker("attack", new double[]{0.64}).build();
    public static final AnimatedAction FLICK = AnimatedAction.builder((double)1.32, (String)"flick").marker("attack", new double[]{0.64}).build();
    public static final AnimatedAction SHOOT = AnimatedAction.builder((double)1.44, (String)"shoot").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction LASER = AnimatedAction.builder((double)1.24, (String)"laser").marker("aim", new double[]{0.3}).marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction PLATE = AnimatedAction.builder((double)0.88, (String)"plate").marker("attack", new double[]{0.56}).build();
    public static final AnimatedAction GRAB = AnimatedAction.builder((double)1.2, (String)"grab").marker("attack", new double[]{0.56}).marker("invis_start", new double[]{0.72}).marker("grab_done", new double[]{1.04}).build();
    public static final AnimatedAction GRAB_CAUGHT = AnimatedAction.builder((double)1.96, (String)"grab_caught").marker("attack", new double[]{0.12, 0.6, 1.04, 1.48}).marker("attack_end", new double[]{1.8}).build();
    public static final AnimatedAction PUNCH = AnimatedAction.builder((double)1.2, (String)"punch").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.04}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction ANGRY = AnimatedAction.builder((double)1.56, (String)"angry").build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)SWIPE, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{SWIPE, FLICK, SHOOT, LASER, PLATE, GRAB, GRAB_CAUGHT, PUNCH, DEFEAT, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityHandonetta>> ATTACK_HANDLER = EntityHandonetta.createAnimationHandler(b -> {
        b.put((Object)SWIPE, (anim, entity) -> {
            class_1309 target = entity.method_5968();
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, entity::method_6121);
            }
        });
        b.put((Object)FLICK, (anim, entity) -> {
            class_1309 target = entity.method_5968();
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, entity::method_6121);
            }
        });
        b.put((Object)PUNCH, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (entity.moveDirection == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853).method_1021(0.75));
                entity.caughtEntities.clear();
            }
            entity.method_18799(entity.moveDirection);
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.caughtEntities.contains(e) && CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new CustomDamage.Builder((class_1297)entity).hurtResistant(8))) {
                        entity.caughtEntities.add((class_1309)e);
                        S2CScreenShake.sendAround((class_1297)entity, 32.0, 4, 2.0f);
                    }
                });
            }
        });
        b.put((Object)SHOOT, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.DARK_BULLETS.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)LASER, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (entity.method_5968() != null && !anim.isPast("aim")) {
                entity.setTargetPosition(entity.method_5968());
            }
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.DARK_BEAM.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)PLATE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.PLATE.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)GRAB, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (entity.moveDirection == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853).method_1021(0.45));
            }
            entity.method_18799(entity.moveDirection);
            if (anim.isPast("grab_done")) {
                if (!entity.caughtEntities.isEmpty()) {
                    entity.getAnimationHandler().setAnimation(GRAB_CAUGHT);
                }
            } else if (anim.isPast("attack") && !anim.isPast("grab_done")) {
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.caughtEntities.contains(e)) {
                        entity.catchEntity((class_1309)e);
                    }
                });
            }
        });
        b.put((Object)GRAB_CAUGHT, (anim, entity) -> {
            entity.method_5942().method_6340();
            entity.method_18799(entity.method_18798().method_1021(0.1));
            if (anim.isAt("attack")) {
                entity.caughtEntities.forEach(entity::method_6121);
                S2CScreenShake.sendAround((class_1297)entity, 24.0, 4, 1.0f);
            }
            if (anim.isPast("attack_end") && !entity.caughtEntities.isEmpty()) {
                entity.caughtEntities.forEach(e -> e.method_6016((class_1291)ModEffects.TRUE_INVIS.get()));
                entity.caughtEntities.clear();
            }
        });
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntityHandonetta>>> ATTACKS = List.of(class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(SWIPE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 70 + e.method_6051().nextInt(50))).withCondition((goal, target, previous) -> ((EntityHandonetta)goal.attacker).allowAnimation(previous, SWIPE) && (goal.distanceToTargetSq < 16.0 || (double)((EntityHandonetta)goal.attacker).field_5974.nextFloat() < 0.5)), (int)11), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(FLICK).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 70 + e.method_6051().nextInt(50))).withCondition((goal, target, previous) -> ((EntityHandonetta)goal.attacker).allowAnimation(previous, FLICK) && (goal.distanceToTargetSq < 16.0 || (double)((EntityHandonetta)goal.attacker).field_5974.nextFloat() < 0.5)), (int)11), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(PUNCH).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 8.0, true, true, true), e -> 70 + e.method_6051().nextInt(50))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(LASER).prepare(() -> new TimedWrappedRunner((ActionRun)new KeepDistanceRunner(7.0, 9.0, 1.0), e -> 70 + e.method_6051().nextInt(50))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(PLATE).prepare(() -> new TimedWrappedRunner((ActionRun)new KeepDistanceRunner(7.0, 11.0, 1.0), e -> 70 + e.method_6051().nextInt(50))), (int)9), class_6008.method_34980((Object)MonsterActionUtils.enragedBossAttack(GRAB).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 5.0, true, true, true), e -> 70 + e.method_6051().nextInt(50))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.enragedBossAttack(SHOOT).prepare(() -> new TimedWrappedRunner((ActionRun)new KeepDistanceRunner(7.0, 10.0, 1.0), e -> 70 + e.method_6051().nextInt(50))), (int)9));
    private static final List<class_6008.class_6010<IdleAction<EntityHandonetta>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new StrafingRunner(10.0f, 8.0f, 0.8f, 0.1f)), (int)2));
    public final AnimatedAttackGoal<EntityHandonetta> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityHandonetta> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        this.moveDirection = null;
        if (anim != null) {
            this.method_18799(this.method_18798().method_1021(0.1));
        }
        return false;
    });
    private final List<class_1309> caughtEntities = new ArrayList<class_1309>();
    private class_243 moveDirection;

    public EntityHandonetta(class_1299<? extends EntityHandonetta> type, class_1937 world) {
        super((class_1299<? extends BossMonster>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
        this.method_5875(true);
        this.field_6207 = new HandonettaMoveController((class_1308)this);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level);
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5786, class_1259.class_1261.field_5795).setMusic((class_3414)ModSounds.HANDONETTA_FIGHT.get());
    }

    protected void method_5623(double y, boolean onGround, class_2680 state, class_2338 pos) {
        super.method_5623(y, false, state, pos);
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23719).method_6192(0.26);
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.32);
    }

    @Override
    protected class_1400<class_1657> createTargetGoalPlayer() {
        return new NearestTargetHorizontal<class_1657>((class_1308)this, class_1657.class, 16, true, true, player -> !this.isTamed());
    }

    @Override
    protected class_1400<class_1308> createTargetGoalMobs() {
        return new NearestTargetHorizontal<class_1308>((class_1308)this, class_1308.class, 16, true, true, this.targetPred);
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{GRAB, GRAB_CAUGHT}) && this.caughtEntities.contains(source.method_5529())) {
            return false;
        }
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY})) && super.method_5643(source, amount);
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{PUNCH, GRAB})) {
            return this.moveDirection;
        }
        return super.directionToLookAt();
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public CustomDamage.Builder damageSourceAttack() {
        CustomDamage.Builder builder = super.damageSourceAttack();
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SWIPE})) {
            builder.knock(CustomDamage.KnockBackType.BACK);
            builder.knockAmount(1.2f);
        }
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{FLICK})) {
            builder.knock(CustomDamage.KnockBackType.UP);
            builder.knockAmount(0.9f);
        }
        return builder;
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{PUNCH})) {
            float[] rots = MathsHelper.YXRotFrom(this.moveDirection);
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 0.2, grow, grow + 0.2), rots[0], rots[1], this.method_19538());
        }
        if (anim.is(new AnimatedAction[]{GRAB})) {
            float[] rots = MathsHelper.YXRotFrom(this.moveDirection);
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow, 0.0, grow), rots[0], rots[1], this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow).inflate(0.0, grow * 2.0, 0.0);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 2.2;
        double length = (double)this.method_17681() * 1.7;
        if (anim.is(new AnimatedAction[]{FLICK})) {
            width = (double)this.method_17681() * 1.6;
            length = (double)this.method_17681() * 1.8;
        }
        return new class_238(-width * 0.5, -0.5, 0.0, width * 0.5, (double)this.method_17682() + 0.5, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 2 ? (Spell)((Object)ModSpells.DARK_BULLETS.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(SHOOT);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(FLICK);
            } else {
                this.getAnimationHandler().setAnimation(SWIPE);
            }
        }
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{GRAB, GRAB_CAUGHT})) {
            boolean invis = this.getAnimationHandler().isCurrent(new AnimatedAction[]{GRAB}) ? this.getAnimationHandler().getAnimation().isPast("invis_start") : this.getAnimationHandler().isCurrent(new AnimatedAction[]{GRAB_CAUGHT});
            this.caughtEntities.forEach(e -> {
                if (e.method_5805()) {
                    if (e instanceof class_3222) {
                        class_3222 player = (class_3222)e;
                        player.method_24203(this.method_23317(), this.method_23318(), this.method_23321());
                    } else {
                        e.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
                    }
                    if (invis) {
                        e.method_6092(new class_1293((class_1291)ModEffects.TRUE_INVIS.get(), 10, 1, true, false, false));
                    }
                }
            });
        }
    }

    private void catchEntity(class_1309 entity) {
        this.caughtEntities.add(entity);
    }

    public void method_5697(class_1297 entityIn) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{PUNCH, GRAB})) {
            return;
        }
        super.method_5697(entityIn);
    }

    public boolean method_24828() {
        return super.method_24828();
    }

    @Override
    public void method_6091(class_243 vec) {
        this.handleFreeTravel(vec);
    }

    public AnimationHandler<EntityHandonetta> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.453125, -0.375);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    protected void setMoveDirection(class_243 moveDirection) {
        this.moveDirection = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.moveDirection);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.moveDirection = motion;
        });
    }

    static class HandonettaMoveController
    extends FreeMoveControl {
        public HandonettaMoveController(class_1308 mob) {
            super(mob);
        }

        @Override
        public void method_6240() {
            class_1335.class_1336 current = this.field_6374;
            super.method_6240();
            if (current == class_1335.class_1336.field_6376 && this.field_6371.method_5968() != null) {
                class_243 target = this.field_6371.method_5968().method_19538();
                class_243 dist = this.field_6371.method_19538().method_1020(target);
                if (dist.method_10214() < 4.0) {
                    this.field_6371.method_5976(1.0f);
                } else {
                    this.field_6371.method_5976(-1.0f);
                }
                if (dist.method_37268() < 16.0) {
                    this.field_6371.method_6125(this.field_6371.method_6029() * 2.0f);
                    this.field_6371.method_5930(-1.0f);
                    this.field_6371.method_5938(this.field_6371.field_6212 * 0.5f);
                }
            }
        }
    }
}

