/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.misc.EntityMarionettaTrap;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModEffects;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.JumpEvadeAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.KeepDistanceRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntityMarionetta
extends BossMonster {
    private static final class_2940<Boolean> CAUGHT = class_2945.method_12791(EntityMarionetta.class, (class_2941)class_2943.field_13323);
    public static final AnimatedAction MELEE = AnimatedAction.builder((double)0.48, (String)"melee").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction SPIN = AnimatedAction.builder((double)1.52, (String)"spin").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.4}).build();
    public static final AnimatedAction CARD_ATTACK = AnimatedAction.builder((double)0.64, (String)"card_attack").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction CHEST_ATTACK = AnimatedAction.builder((double)1.2, (String)"chest_attack").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.0}).build();
    public static final AnimatedAction CHEST_THROW = AnimatedAction.builder((double)5.0, (String)"chest_throw").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction STUFFED_ANIMALS = AnimatedAction.builder((double)0.76, (String)"stuffed_animals").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction DARK_BEAM = AnimatedAction.builder((double)0.8, (String)"dark_beam").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction FURNITURE = AnimatedAction.builder((double)1.2, (String)"furniture").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction ANGRY = AnimatedAction.builder((double)1.2, (String)"angry").build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)MELEE, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{MELEE, SPIN, CARD_ATTACK, CHEST_ATTACK, CHEST_THROW, STUFFED_ANIMALS, DARK_BEAM, FURNITURE, DEFEAT, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityMarionetta>> ATTACK_HANDLER = EntityMarionetta.createAnimationHandler(b -> {
        b.put((Object)MELEE, (anim, entity) -> {
            class_1309 target = entity.method_5968();
            if (target != null) {
                entity.method_5942().method_6335((class_1297)target, 1.0);
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, entity::method_6121);
            }
        });
        b.put((Object)SPIN, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (entity.moveDirection == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.5));
            }
            entity.method_18799(entity.moveDirection);
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.mobAttack((AnimatedAction)anim, null, e -> CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new CustomDamage.Builder((class_1297)entity).hurtResistant(8)));
            }
        });
        b.put((Object)CARD_ATTACK, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.CARD_THROW.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)CHEST_ATTACK, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (entity.moveDirection == null) {
                entity.setMoveDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.5));
            }
            entity.method_18799(entity.moveDirection);
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.caughtEntities.contains(e)) {
                        entity.catchEntity((class_1309)e);
                    }
                });
            }
        });
        b.put((Object)CHEST_THROW, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                class_243 throwVec = new class_243(entity.method_5720().method_10216(), 0.0, entity.method_5720().method_10215()).method_1029().method_1021(1.2).method_1031(0.0, 0.85, 0.0);
                EntityMarionettaTrap trap = new EntityMarionettaTrap(entity.field_6002, (class_1309)entity);
                trap.setDamageMultiplier(0.9f);
                entity.caughtEntities.forEach(e -> {
                    e.method_6092(new class_1293((class_1291)ModEffects.TRUE_INVIS.get(), 100, 1, true, false, false));
                    trap.addCaughtEntity((class_1309)e);
                });
                trap.method_18799(throwVec);
                entity.field_6002.method_8649((class_1297)trap);
                entity.caughtEntities.clear();
            }
        });
        b.put((Object)STUFFED_ANIMALS, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.PLUSH_THROW.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)DARK_BEAM, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack") && !EntityUtils.sealed((class_1309)entity)) {
                ((Spell)((Object)((Object)((Object)ModSpells.DARK_BEAM.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)FURNITURE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack") && !EntityUtils.sealed((class_1309)entity)) {
                ((Spell)((Object)((Object)((Object)ModSpells.FURNITURE.get())))).use((class_1309)entity);
            }
        });
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntityMarionetta>>> ATTACKS = List.of(class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(MELEE).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.1), e -> 30 + e.method_6051().nextInt(20))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(SPIN).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.5), e -> 35 + e.method_6051().nextInt(20))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(CARD_ATTACK).prepare(() -> new TimedWrappedRunner((ActionRun)new JumpEvadeAction(2.0, 0.9, 0.5, 0.0f, 0.5f, (ActionRun)new DoNothingRunner(true)), e -> 5)), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(CHEST_ATTACK).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.5), e -> 35 + e.method_6051().nextInt(20))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(STUFFED_ANIMALS).prepare(() -> new TimedWrappedRunner((ActionRun)new KeepDistanceRunner(3.0, 7.0, 1.2), e -> 30 + e.method_6051().nextInt(20))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.enragedBossAttack(DARK_BEAM).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 30 + e.method_6051().nextInt(20))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.enragedBossAttack(FURNITURE).prepare(() -> new TimedWrappedRunner((ActionRun)new DoNothingRunner(true), e -> 5)), (int)1));
    private static final List<class_6008.class_6010<IdleAction<EntityMarionetta>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new JumpEvadeAction(2.0, 0.9, 0.5, 0.015f, 0.4f, (ActionRun)new StrafingRunner(7.0f, 1.0f))), (int)10), class_6008.method_34980((Object)new IdleAction(() -> new StrafingRunner(7.0f, 1.0f)), (int)8));
    public final AnimatedAttackGoal<EntityMarionetta> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityMarionetta> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        this.moveDirection = null;
        if (((Boolean)this.field_6011.method_12789(CAUGHT)).booleanValue()) {
            if (!this.field_6002.field_9236) {
                this.field_6011.method_12778(CAUGHT, (Object)false);
                this.getAnimationHandler().setAnimation(CHEST_THROW);
            }
            return true;
        }
        return false;
    });
    private final List<class_1309> caughtEntities = new ArrayList<class_1309>();
    private class_243 moveDirection;

    public EntityMarionetta(class_1299<? extends EntityMarionetta> type, class_1937 world) {
        super((class_1299<? extends BossMonster>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5788, class_1259.class_1261.field_5795).setMusic((class_3414)ModSounds.MARIONETTA_FIGHT.get());
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(CAUGHT, (Object)false);
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    public boolean caughtTarget() {
        return (Boolean)this.field_6011.method_12789(CAUGHT);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.26);
        super.applyAttributes();
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.caughtEntities.contains(source.method_5529())) {
            return false;
        }
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHEST_THROW, ANGRY})) && super.method_5643(source, amount);
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SPIN, CHEST_ATTACK})) {
            return this.moveDirection;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{SPIN})) {
            float rotY = -class_3532.method_15393((float)((float)(class_3532.method_15349((double)this.moveDirection.method_10216(), (double)this.moveDirection.method_10215()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 1.6, 0.1, grow + 1.6), rotY, 0.0f, this.method_19538());
        }
        if (anim.is(new AnimatedAction[]{CHEST_ATTACK})) {
            float rotY = -class_3532.method_15393((float)((float)(class_3532.method_15349((double)this.moveDirection.method_10216(), (double)this.moveDirection.method_10215()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 1.2, 0.1, grow + 1.2), rotY, 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.5;
        double length = (double)this.method_17681() * 1.7;
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 2 ? (Spell)((Object)ModSpells.CARD_THROW.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(CARD_ATTACK);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(SPIN);
            } else {
                this.getAnimationHandler().setAnimation(MELEE);
            }
        }
    }

    @Override
    public void method_5670() {
        super.method_5670();
        this.caughtEntities.forEach(e -> {
            if (e.method_5805()) {
                if (e instanceof class_3222) {
                    class_3222 player = (class_3222)e;
                    player.method_24203(this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.2, this.method_23321());
                } else {
                    e.method_5814(this.method_23317(), this.method_23318() + (double)this.method_17682() + 0.2, this.method_23321());
                }
            }
        });
    }

    private void catchEntity(class_1309 entity) {
        this.caughtEntities.add(entity);
        this.field_6011.method_12778(CAUGHT, (Object)true);
    }

    public void method_5697(class_1297 entityIn) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{SPIN, CHEST_ATTACK})) {
            return;
        }
        super.method_5697(entityIn);
    }

    public AnimationHandler<EntityMarionetta> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.078125, -0.375);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    protected void setMoveDirection(class_243 moveDirection) {
        this.moveDirection = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.moveDirection);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.moveDirection = motion;
        });
    }
}

