/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.enums.EnumElement;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.misc.GroundShakeParticleSpawner;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.CustomDataSerializers;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntityRaccoon
extends BossMonster {
    public static final class_243[] CLONE_POS = new class_243[]{new class_243(-4.0, 0.0, 0.0), new class_243(0.0, 0.0, -4.0), new class_243(4.0, 0.0, 0.0), new class_243(0.0, 0.0, 4.0)};
    private static final class_2940<Boolean> BERSERK = class_2945.method_12791(EntityRaccoon.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<class_243>> CLONE_CENTER = class_2945.method_12791(EntityRaccoon.class, (class_2941)CustomDataSerializers.OPTIONAL_VEC);
    private static final class_2940<Integer> CLONE_INDEX = class_2945.method_12791(EntityRaccoon.class, (class_2941)class_2943.field_13327);
    public static final AnimatedAction DOUBLE_PUNCH = AnimatedAction.builder((double)0.88, (String)"double_punch").marker("attack", new double[]{0.4, 0.68}).build();
    public static final AnimatedAction PUNCH = AnimatedAction.builder((double)0.92, (String)"punch").marker("attack", new double[]{0.56}).build();
    public static final AnimatedAction JUMP = AnimatedAction.builder((double)1.08, (String)"jump").marker("jump", new double[]{0.2}).infinite().build();
    public static final AnimatedAction LAND = AnimatedAction.builder((double)0.4, (String)"land").marker("attack", new double[]{0.24}).build();
    public static final AnimatedAction STOMP = AnimatedAction.builder((double)1.36, (String)"stomp").marker("attack", new double[]{0.56, 1.12}).build();
    public static final AnimatedAction LEAF_SHOOT = AnimatedAction.builder((double)0.88, (String)"shoot").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction LEAF_BOOMERANG = AnimatedAction.copyOf((AnimatedAction)LEAF_SHOOT, (String)"spinning_shoot");
    public static final AnimatedAction LEAF_SHOT_CLONE = AnimatedAction.builder((double)0.88, (String)"leaf_clone").withClientID("shoot").marker("attack", new double[]{0.44, 0.64}).build();
    public static final AnimatedAction BARRAGE = AnimatedAction.builder((double)3.32, (String)"punch_barrage").marker("attack", new double[]{0.44, 0.84, 1.28}).marker("vulnerable_start", new double[]{1.52}).marker("vulnerable_end", new double[]{3.04}).build();
    public static final AnimatedAction ROAR = AnimatedAction.builder((double)1.24, (String)"roar").marker("roar", new double[]{0.12}).build();
    public static final AnimatedAction ANGRY = AnimatedAction.copyOf((AnimatedAction)ROAR, (String)"angry");
    public static final AnimatedAction CLONE = AnimatedAction.copyOf((AnimatedAction)ROAR, (String)"clone");
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction TRANSFORM = AnimatedAction.builder((double)1.5, (String)"transform").build();
    public static final AnimatedAction UNTRANSFORM = AnimatedAction.builder((double)2.2, (String)"untransform").marker("knockback_start", new double[]{1.0}).marker("knockback_end", new double[]{1.5}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)DOUBLE_PUNCH, (String)"interact");
    public static final AnimatedAction INTERACT_BERSERK = AnimatedAction.copyOf((AnimatedAction)PUNCH, (String)"interact_berserk");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{DOUBLE_PUNCH, PUNCH, JUMP, LAND, STOMP, LEAF_SHOOT, LEAF_BOOMERANG, LEAF_SHOT_CLONE, BARRAGE, ROAR, ANGRY, CLONE, DEFEAT, TRANSFORM, UNTRANSFORM, INTERACT, INTERACT_BERSERK};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityRaccoon>> ATTACK_HANDLER = EntityRaccoon.createAnimationHandler(b -> {
        b.put((Object)DOUBLE_PUNCH, (anim, entity) -> {
            class_1309 target = entity.method_5968();
            if (target != null) {
                entity.method_5942().method_6335((class_1297)target, 1.0);
            }
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, entity::method_6121);
            }
        });
        b.put((Object)PUNCH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), entity::method_6121);
            }
        });
        b.put((Object)BARRAGE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                class_243 dir;
                class_1309 target = entity.method_5968();
                if (target != null) {
                    class_243 targetPos = target.method_19538();
                    dir = new class_243(targetPos.field_1352 - entity.method_23317(), 0.0, targetPos.field_1350 - entity.method_23321()).method_1029();
                    entity.setTargetPosition(target);
                } else {
                    dir = new class_243(entity.method_5720().method_10216(), 0.0, entity.method_5720().method_10215()).method_1029();
                }
                entity.method_18799(entity.method_18798().method_1019(dir.method_1021(0.6)));
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), entity::method_6121);
            }
        });
        b.put((Object)JUMP, (anim, entity) -> {
            entity.method_5942().method_6340();
            double length = anim.getLength() - 3.0f;
            if (entity.jumpDir == null) {
                class_243 dir = entity.method_5968() != null ? entity.method_5968().method_19538().method_1020(entity.method_19538()) : entity.method_5720();
                dir = new class_243(dir.method_10216(), 0.0, dir.method_10215()).method_1029().method_1021(8.0);
                entity.jumpDir = dir.method_18805(1.0 / length, 1.0, 1.0 / length);
            }
            if (anim.isAt("jump")) {
                entity.method_18800(entity.jumpDir.field_1352, 2.0, entity.jumpDir.field_1350);
            }
            if (anim.isPast("jump")) {
                entity.field_6017 = 0.0f;
                entity.method_18799(entity.method_18798().method_1031(0.0, -0.08, 0.0));
                if (entity.method_18798().field_1351 < -1.1) {
                    entity.method_18800(entity.method_18798().field_1352, -1.1, entity.method_18798().field_1350);
                }
                if (anim.done(0) && entity.method_24828()) {
                    entity.getAnimationHandler().setAnimation(LAND);
                }
                if (!(!anim.isPast(6.0) || entity.method_36601().method_27852(class_2246.field_10124) && entity.method_25936().method_27852(class_2246.field_10124))) {
                    entity.getAnimationHandler().setAnimation(LAND);
                }
            }
        });
        b.put((Object)LAND, (anim, entity) -> {
            if (anim.isAt("attack")) {
                CustomDamage.Builder source = new CustomDamage.Builder((class_1297)entity).noKnockback().element(EnumElement.EARTH).hurtResistant(5).withChangedAttribute((class_1320)ModAttributes.STUN.get(), 80.0);
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), e -> CombatUtils.mobAttack((class_1309)entity, (class_1297)e, source));
                S2CScreenShake.sendAround((class_1297)entity, 24.0, 8, 3.0f);
                entity.field_6002.method_8649((class_1297)new GroundShakeParticleSpawner(entity.field_6002, (class_1309)entity, 360.0, (double)entity.method_17681() * 1.8));
                entity.field_6002.method_8396(null, entity.method_24515(), class_3417.field_15152, entity.method_5634(), 1.0f, 0.9f);
            }
        });
        b.put((Object)STOMP, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                CustomDamage.Builder source = new CustomDamage.Builder((class_1297)entity).noKnockback().element(EnumElement.EARTH).hurtResistant(5).withChangedAttribute((class_1320)ModAttributes.STUN.get(), 50.0);
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), e -> CombatUtils.mobAttack((class_1309)entity, (class_1297)e, source));
                S2CScreenShake.sendAround((class_1297)entity, 24.0, 8, 3.0f);
                entity.field_6002.method_8396(null, entity.method_24515(), class_3417.field_15152, entity.method_5634(), 1.0f, 0.9f);
            }
        });
        b.put((Object)LEAF_SHOOT, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X7.get())))).use((class_1309)entity);
                } else if (entity.isTamed() || (double)entity.field_5974.nextFloat() < 0.6) {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X3.get())))).use((class_1309)entity);
                } else {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X5.get())))).use((class_1309)entity);
                }
            }
        });
        b.put((Object)LEAF_SHOT_CLONE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X7.get())))).use((class_1309)entity);
                } else if ((double)entity.field_5974.nextFloat() < 0.6) {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X3.get())))).use((class_1309)entity);
                } else {
                    ((Spell)((Object)((Object)((Object)ModSpells.SMALL_LEAF_SPELL_X5.get())))).use((class_1309)entity);
                }
            }
        });
        b.put((Object)LEAF_BOOMERANG, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                if (entity.isEnraged()) {
                    ((Spell)((Object)((Object)((Object)ModSpells.BIG_LEAF_SPELL_DOUBLE.get())))).use((class_1309)entity);
                } else {
                    ((Spell)((Object)((Object)((Object)ModSpells.BIG_LEAF_SPELL.get())))).use((class_1309)entity);
                }
            }
        });
        b.put((Object)ROAR, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("roar")) {
                entity.playAngrySound();
            }
        });
        b.put((Object)CLONE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt(0.05)) {
                entity.playAngrySound();
                class_243 center = entity.method_5968() == null ? entity.method_19538() : (entity.method_5858((class_1297)entity.method_5968()) < 144.0 ? entity.method_5968().method_19538() : entity.method_5968().method_19538().method_1020(entity.method_19538()).method_1029().method_1021(12.0).method_1019(entity.method_19538()));
                entity.field_6011.method_12778(CLONE_CENTER, Optional.of(center));
                int id = entity.field_5974.nextInt(CLONE_POS.length);
                class_243 pos2 = CLONE_POS[id];
                entity.field_6011.method_12778(CLONE_INDEX, (Object)id);
                entity.method_5859(center.method_10216() + pos2.field_1352, center.method_10214() + pos2.field_1351, center.method_10215() + pos2.field_1350);
            }
            ((Optional)entity.field_6011.method_12789(CLONE_CENTER)).ifPresent(pos -> entity.method_5702(class_2183.class_2184.field_9853, (class_243)pos));
        });
        b.put((Object)UNTRANSFORM, (anim, entity) -> {
            if (entity.method_24828() && anim.isPast("knockback_start") && !anim.isPast("knockback_end")) {
                entity.method_5762(0.0, 0.4, 0.0);
            }
        });
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntityRaccoon>>> ATTACKS = List.of(class_6008.method_34980((Object)new GoalAttackAction(DOUBLE_PUNCH).cooldown(e -> e.animationCooldown(DOUBLE_PUNCH)).withCondition((goal, target, previous) -> !((EntityRaccoon)goal.attacker).isBerserk()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(4.0, 1.2, 5), e -> 20 + e.method_6051().nextInt(10))), (int)20), class_6008.method_34980((Object)new GoalAttackAction(DOUBLE_PUNCH).cooldown(e -> e.animationCooldown(DOUBLE_PUNCH)).withCondition((goal, target, previous) -> !((EntityRaccoon)goal.attacker).isBerserk()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.method_6051().nextInt(15))), (int)17), class_6008.method_34980((Object)new GoalAttackAction(PUNCH).cooldown(e -> e.animationCooldown(PUNCH)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !PUNCH.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.0), e -> 25 + e.method_6051().nextInt(10))), (int)20), class_6008.method_34980((Object)new GoalAttackAction(JUMP).cooldown(e -> e.animationCooldown(JUMP)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !JUMP.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.0, 6.0), e -> 25 + e.method_6051().nextInt(10))), (int)18), class_6008.method_34980((Object)new GoalAttackAction(STOMP).cooldown(e -> e.animationCooldown(STOMP)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !STOMP.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.0), e -> 25 + e.method_6051().nextInt(10))), (int)18), class_6008.method_34980((Object)new GoalAttackAction(LEAF_SHOOT).cooldown(e -> e.animationCooldown(LEAF_SHOOT)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !LEAF_SHOOT.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(3.0, 1.0, 5), e -> 25 + e.method_6051().nextInt(10))), (int)17), class_6008.method_34980((Object)new GoalAttackAction(LEAF_BOOMERANG).cooldown(e -> e.animationCooldown(LEAF_BOOMERANG)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !LEAF_BOOMERANG.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(3.0, 1.0, 5), e -> 25 + e.method_6051().nextInt(10))), (int)18), class_6008.method_34980((Object)new GoalAttackAction(ROAR).cooldown(e -> e.animationCooldown(ROAR)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !ROAR.getID().equals(previous)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)5), class_6008.method_34980((Object)new GoalAttackAction(BARRAGE).cooldown(e -> e.animationCooldown(BARRAGE)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isBerserk() && !BARRAGE.getID().equals(previous)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.0), e -> 25 + e.method_6051().nextInt(10))), (int)1), class_6008.method_34980((Object)new GoalAttackAction(CLONE).cooldown(e -> e.animationCooldown(CLONE)).withCondition((goal, target, previous) -> ((EntityRaccoon)goal.attacker).isEnraged() && !CLONE.getID().equals(previous)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)15));
    private static final List<class_6008.class_6010<IdleAction<EntityRaccoon>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 0.5)).withCondition((goal, target) -> ((EntityRaccoon)goal.attacker).isBerserk()), (int)10), class_6008.method_34980((Object)new IdleAction(() -> new MoveAwayRunner(1.0, 1.0, 5)).withCondition((goal, target) -> !((EntityRaccoon)goal.attacker).isBerserk()), (int)11));
    public final AnimatedAttackGoal<EntityRaccoon> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private boolean clone;
    private class_243 jumpDir;
    private int hit;
    private int hitCountdown = -1;
    private final AnimationHandler<EntityRaccoon> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (CLONE.is(new AnimatedAction[]{anim})) {
            this.clone = true;
        } else if (anim != null) {
            this.clone = false;
            this.field_6011.method_12778(CLONE_CENTER, Optional.empty());
        }
        this.jumpDir = null;
        if (anim == null && this.clone) {
            this.getAnimationHandler().setAnimation(this.method_6051().nextBoolean() ? LEAF_SHOT_CLONE : LEAF_BOOMERANG);
            return true;
        }
        return false;
    });

    public EntityRaccoon(class_1299<? extends EntityRaccoon> type, class_1937 world) {
        super((class_1299<? extends BossMonster>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795).setMusic((class_3414)ModSounds.RACCOON_FIGHT.get());
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(BERSERK, (Object)false);
        this.field_6011.method_12784(CLONE_CENTER, Optional.empty());
        this.field_6011.method_12784(CLONE_INDEX, (Object)0);
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    public boolean isBerserk() {
        return (Boolean)this.field_6011.method_12789(BERSERK);
    }

    public Optional<class_243> cloneCenter() {
        return (Optional)this.field_6011.method_12789(CLONE_CENTER);
    }

    public int cloneIndex() {
        return (Integer)this.field_6011.method_12789(CLONE_INDEX);
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.24);
        super.applyAttributes();
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (!this.field_6002.field_9236) {
            --this.hitCountdown;
            if (this.method_5805() && !this.isBerserk() && (this.hitCountdown == 0 || this.hit >= 5)) {
                this.setBerserk(true, false);
                this.hit = 0;
            }
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{JUMP, LAND, DEFEAT, TRANSFORM, UNTRANSFORM, ANGRY})) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    @Override
    protected void method_6074(class_1282 damageSrc, float damageAmount) {
        AnimatedAction anim;
        super.method_6074(damageSrc, damageAmount);
        if (!this.isBerserk()) {
            ++this.hit;
            this.hitCountdown = 30;
        } else if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{BARRAGE}) && (anim = this.getAnimationHandler().getAnimation()).isPast("vulnerable_start") && !anim.isPast("vulnerable_end")) {
            this.setBerserk(false, false);
            this.getAnimationHandler().setAnimation(UNTRANSFORM);
            this.method_5762(0.0, 0.6, 0.0);
        }
    }

    protected int method_23329(float fallDistance, float damageMultiplier) {
        return super.method_23329(fallDistance - 5.0f, damageMultiplier);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        if (BERSERK.equals(key)) {
            this.method_18382();
        }
        super.method_5674(key);
    }

    public void setBerserk(boolean flag, boolean load) {
        this.field_6011.method_12778(BERSERK, (Object)flag);
        this.method_18382();
        if (!load) {
            if (flag) {
                this.getAnimationHandler().setAnimation(TRANSFORM);
            } else {
                this.getAnimationHandler().setAnimation(UNTRANSFORM);
            }
            this.attack.method_6270();
        }
    }

    public class_4048 method_18377(class_4050 pose) {
        if (this.isBerserk()) {
            return pose == class_4050.field_18078 ? field_18072 : class_4048.method_18385((float)1.65f, (float)3.35f).method_18383(this.method_17825());
        }
        return super.method_18377(pose);
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{CLONE, TRANSFORM, UNTRANSFORM, ANGRY, ROAR, DEFEAT});
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setBerserk(compound.method_10577("Berserk"), true);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Berserk", this.isBerserk());
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, ROAR, DEFEAT})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        this.method_5942().method_6340();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{JUMP, LAND})) {
            return new OrientedBoundingBox(this.attackBB(anim), 0.0f, 0.0f, this.method_19538());
        }
        if (anim.is(new AnimatedAction[]{STOMP})) {
            class_243 dir;
            double reach = (double)this.method_17681() * 0.55;
            float offset = anim.isAt("attack") ? -90.0f : 90.0f;
            class_1297 class_12972 = this.method_5642();
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                dir = class_243.method_1030((float)player.method_36455(), (float)(player.method_36454() + offset));
            } else {
                dir = class_243.method_1030((float)this.method_36455(), (float)(this.method_36454() + offset));
            }
            class_243 attackPos = this.method_19538().method_1019(dir.method_1021(reach));
            return new OrientedBoundingBox(this.attackBB(anim), this.method_36454(), 0.0f, attackPos);
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{JUMP, LAND})) {
            double attackSize = (double)this.method_17681() * 1.5;
            return new class_238(-attackSize, -0.5, -attackSize, attackSize, 2.0, attackSize);
        }
        if (anim.is(new AnimatedAction[]{STOMP})) {
            return new class_238(-1.8, -0.5, -2.2, 1.8, 2.0, 2.2);
        }
        double width = (double)this.method_17681() * 1.4;
        double length = (double)this.method_17681() * 1.5;
        if (anim.is(new AnimatedAction[]{DOUBLE_PUNCH})) {
            width = (double)this.method_17681() * 1.5;
            length = (double)this.method_17681() * 1.7;
        }
        if (anim.is(new AnimatedAction[]{PUNCH})) {
            width = (double)this.method_17681() * 1.5;
            length = (double)this.method_17681() * 1.6;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 2 ? (Spell)((Object)ModSpells.SMALL_LEAF_SPELL_X3.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(LEAF_SHOOT);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(JUMP);
            } else {
                this.getAnimationHandler().setAnimation(DOUBLE_PUNCH);
            }
        }
    }

    public void method_5697(class_1297 entityIn) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ROAR, CLONE, TRANSFORM})) {
            return;
        }
        super.method_5697(entityIn);
    }

    protected void method_6070() {
        if (!this.getAnimationHandler().isCurrent(new AnimatedAction[]{CLONE})) {
            super.method_6070();
        }
    }

    public AnimationHandler<EntityRaccoon> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        if (this.isBerserk()) {
            return new class_243(0.0, 1.015625, -0.65625).method_1021(1.4);
        }
        return new class_243(0.0, 1.0625, -0.3125);
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }
}

