/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.EntitySanoUno;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntityUno;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.spells.FireWallSpell;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5575;
import net.minecraft.class_6008;

public class EntitySano
extends EntitySanoUno {
    public static final AnimatedAction FIREBALL_3X = AnimatedAction.builder((double)2.0, (String)"fireball_3x").marker("attack", new double[]{0.8, 1.0, 1.2}).build();
    public static final AnimatedAction FIREBALL_BARRAGE = AnimatedAction.builder((double)4.5, (String)"fireball_barrage").marker("single", new double[]{3.0}).marker("double", new double[]{3.8}).marker("triple", new double[]{0.8}).marker("quad", new double[]{1.2, 3.4}).build();
    public static final AnimatedAction EXPLOSION = AnimatedAction.builder((double)1.5, (String)"explosion").marker("attack", new double[]{0.8}).build();
    public static final AnimatedAction FIRE_BREATH = AnimatedAction.builder((double)2.0, (String)"fire_breath").marker("attack", new double[]{0.8, 1.2}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{FIREBALL_3X, FIREBALL_BARRAGE, EXPLOSION, FIRE_BREATH, DEFEAT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntitySano>> ATTACK_HANDLER = EntitySano.createAnimationHandler(b -> {
        b.put((Object)FIREBALL_3X, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.FIREBALL.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)FIREBALL_BARRAGE, (anim, entity) -> {
            if (anim.isAt("single")) {
                ((Spell)((Object)((Object)((Object)ModSpells.FIREBALL.get())))).use((class_1309)entity);
            }
            if (anim.isAt("double")) {
                ((Spell)((Object)((Object)((Object)ModSpells.DOUBLE_FIRE_BALL.get())))).use((class_1309)entity);
            }
            if (anim.isAt("triple")) {
                ((Spell)((Object)((Object)((Object)ModSpells.TRIPLE_FIRE_BALL.get())))).use((class_1309)entity);
            }
            if (anim.isAt("quad")) {
                ((Spell)((Object)((Object)((Object)ModSpells.QUAD_FIRE_BALL.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)EXPLOSION, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.EXPLOSION.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)FIRE_BREATH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                class_243 from = FireWallSpell.offset((class_1309)entity);
                class_243 dir = entity.method_5968() != null ? EntityUtils.getStraightProjectileTarget(from, (class_1297)entity.method_5968()).method_1020(from).method_1029() : entity.method_5720();
                dir = dir.method_1021(10.0).method_1031(entity.field_5974.nextGaussian() * 2.3, -Math.abs(entity.field_5974.nextGaussian()) * 0.6, entity.field_5974.nextGaussian() * 2.3);
                entity.targetPos = entity.method_19538().method_1019(dir);
                ((Spell)((Object)((Object)((Object)ModSpells.FIRE_WALL.get())))).use((class_1309)entity);
            }
        });
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntitySano>>> ATTACKS = List.of(class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(FIREBALL_3X).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(FIREBALL_BARRAGE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(EXPLOSION).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(FIRE_BREATH).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10));
    private static final List<class_6008.class_6010<IdleAction<EntitySano>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new).duration(e -> e.method_6051().nextInt(20) + 35), (int)1));
    public final AnimatedAttackGoal<EntitySano> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntitySano> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private EntityUno other;

    public EntitySano(class_1299<? extends EntitySano> type, class_1937 world) {
        super((class_1299<? extends EntitySanoUno>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.FIRE_WALL.get()))) {
                    this.getAnimationHandler().setAnimation(FIRE_BREATH);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.FIREBALL_BARRAGE.get()))) {
                    this.getAnimationHandler().setAnimation(FIREBALL_BARRAGE);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.TRIPLE_FIRE_BALL.get()))) {
                this.getAnimationHandler().setAnimation(FIREBALL_3X);
            }
        }
    }

    public AnimationHandler<EntitySano> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public EntityUno getLinked() {
        List results;
        if (this.other != null && !this.other.method_31481()) {
            return this.other;
        }
        if (this.getLinkedID() != null && !(results = this.field_6002.method_18023(class_5575.method_31795(EntityUno.class), this.method_5829().method_1014(64.0), e -> this.getLinkedID().equals(e.getLinkedID()))).isEmpty()) {
            this.other = (EntityUno)results.get(0);
        }
        return this.other;
    }
}

