/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.RestrictedWaterAvoidingStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntitySarcophagus
extends BossMonster {
    public static final AnimatedAction TELEPORT = AnimatedAction.builder((double)2.64, (String)"teleport").marker("teleport_start_1", new double[]{0.2}).marker("teleport_end_1", new double[]{0.44}).marker("teleport_start_2", new double[]{1.2}).marker("teleport_end_2", new double[]{1.44}).marker("teleport_start_3", new double[]{2.2}).marker("teleport_end_3", new double[]{2.44}).marker("teleport", new double[]{0.28, 1.28, 2.28}).build();
    public static final AnimatedAction CHARGE = AnimatedAction.builder((double)1.6, (String)"charge").marker("attack_start", new double[]{0.28}).marker("attack_end", new double[]{1.48}).build();
    public static final AnimatedAction BEAM = AnimatedAction.builder((double)0.68, (String)"cast").marker("attack", new double[]{0.48}).build();
    public static final AnimatedAction BEAM_3X = AnimatedAction.builder((double)2.2, (String)"cast_3x").marker("attack", new double[]{0.48, 1.24, 2.0}).build();
    public static final AnimatedAction FIRE_CIRCLE = AnimatedAction.builder((double)2.32, (String)"circle_cast").marker("attack", new double[]{0.4}).build();
    public static final AnimatedAction WIND_CIRCLE = AnimatedAction.copyOf((AnimatedAction)FIRE_CIRCLE, (String)"wind_circle");
    public static final AnimatedAction ICE_CIRCLE = AnimatedAction.copyOf((AnimatedAction)FIRE_CIRCLE, (String)"ice_circle");
    public static final AnimatedAction EARTH_CIRCLE = AnimatedAction.copyOf((AnimatedAction)FIRE_CIRCLE, (String)"earth_circle");
    public static final AnimatedAction LIGHT_2X = AnimatedAction.copyOf((AnimatedAction)BEAM, (String)"light_2x");
    public static final AnimatedAction LIGHT_4X = AnimatedAction.copyOf((AnimatedAction)BEAM, (String)"light_4x");
    public static final AnimatedAction SHINE = AnimatedAction.copyOf((AnimatedAction)BEAM, (String)"shine");
    public static final AnimatedAction PRISM = AnimatedAction.copyOf((AnimatedAction)BEAM, (String)"prism");
    public static final AnimatedAction MISSILE = AnimatedAction.builder((double)1.04, (String)"missile").marker("attack", new double[]{0.72}).build();
    public static final AnimatedAction STARFALL = AnimatedAction.builder((double)8.2, (String)"starfall").marker("attack", new double[]{0.8}).marker("attack_start", new double[]{0.24}).marker("attack_end", new double[]{7.96}).marker("teleport_start", new double[]{0.2}).marker("teleport_end", new double[]{8.0}).build();
    public static final AnimatedAction ANGRY = new AnimatedAction(1.04, "angry");
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)BEAM, (String)"interact");
    private static final AnimatedAction[] ANIMATED_ACTIONS = new AnimatedAction[]{TELEPORT, CHARGE, BEAM, BEAM_3X, FIRE_CIRCLE, WIND_CIRCLE, ICE_CIRCLE, EARTH_CIRCLE, LIGHT_2X, LIGHT_4X, SHINE, PRISM, MISSILE, STARFALL, DEFEAT, INTERACT, ANGRY};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntitySarcophagus>> ATTACK_HANDLER = EntitySarcophagus.createAnimationHandler(b -> {
        b.put((Object)TELEPORT, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("teleport_start_1") || anim.isAt("teleport_end_1") || anim.isAt("teleport_start_2") || anim.isAt("teleport_end_2") || anim.isAt("teleport_start_3") || anim.isAt("teleport_end_3")) {
                entity.method_5783(class_3417.field_14879, 1.0f, 1.0f);
            }
            if (anim.isAt("teleport")) {
                entity.teleportAround(8, 10);
            }
        });
        b.put((Object)CHARGE, (anim, entity) -> {
            if (anim.isPast("attack_start") && !anim.isPast("attack_end")) {
                if (entity.hitEntity == null) {
                    entity.hitEntity = new ArrayList<class_1309>();
                }
                if (entity.chargeMotion == null) {
                    entity.setChargeDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(0.3));
                }
                entity.method_18800(entity.chargeMotion.method_10216(), entity.method_18798().method_10214(), entity.chargeMotion.method_10215());
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new CustomDamage.Builder((class_1297)entity).hurtResistant(5).knock(CustomDamage.KnockBackType.BACK).knockAmount(2.0f))) {
                        entity.hitEntity.add((class_1309)e);
                    }
                });
                if (entity.field_6012 % 5 == 0) {
                    entity.method_5783((class_3414)ModSounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (entity.field_5974.nextFloat() - entity.field_5974.nextFloat()) * 0.2f + 1.0f);
                }
            } else {
                entity.method_18799(entity.method_18798().method_1021(0.6));
            }
        });
        b.put((Object)BEAM, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.LIGHT_BEAM.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)BEAM_3X, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.LIGHT_BEAM.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)FIRE_CIRCLE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.FIRE_CIRCLE.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)WIND_CIRCLE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.WIND_CIRCLE.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)ICE_CIRCLE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.ICE_CIRCLE.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)EARTH_CIRCLE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.EARTH_CIRCLE.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)LIGHT_2X, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.EXPANDING_DOUBLE_LIGHT.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)LIGHT_4X, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.EXPANDING_QUAD_LIGHT.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)SHINE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.SHINE.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)PRISM, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.PRISM_LONG.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)MISSILE, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.MISSILE_8X.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)STARFALL, (anim, entity) -> {
            entity.method_5942().method_6340();
            if (anim.isAt("attack_start")) {
                entity.starFallPre = entity.method_19538();
                if (entity.method_18410()) {
                    class_243 pos = class_243.method_24953((class_2382)entity.method_18412());
                    entity.method_5859(pos.field_1352, pos.field_1351 + 8.0, pos.field_1350);
                } else if (entity.method_5968() != null) {
                    entity.method_5859(entity.method_5968().method_23317(), entity.method_5968().method_23318() + 8.0, entity.method_5968().method_23321());
                } else {
                    entity.method_5859(entity.method_23317(), entity.method_23318() + 8.0, entity.method_23321());
                }
                entity.starFallPos = entity.method_19538();
                ((Spell)((Object)((Object)((Object)ModSpells.STARFALL_LONG.get())))).use((class_1309)entity);
            }
            if (entity.starFallPos != null) {
                entity.method_33574(entity.starFallPos);
            }
            if (anim.isAt("attack_end")) {
                entity.method_5859(entity.starFallPre.method_10216(), entity.starFallPre.method_10214(), entity.starFallPre.method_10215());
                entity.starFallPre = null;
                entity.starFallPos = null;
                entity.teleportAround(6, 12);
            }
        });
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntitySarcophagus>>> ATTACKS = List.of(class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(TELEPORT).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(CHARGE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(BEAM).withCondition((goal, target, previous) -> !((EntitySarcophagus)goal.attacker).isEnraged() && ((EntitySarcophagus)goal.attacker).allowAnimation(previous, BEAM)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.enragedBossAttack(BEAM_3X).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(FIRE_CIRCLE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)4), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(WIND_CIRCLE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)4), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(ICE_CIRCLE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)4), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(EARTH_CIRCLE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)4), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(LIGHT_2X).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.enragedBossAttack(LIGHT_4X).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(SHINE).withCondition((goal, target, previous) -> !((EntitySarcophagus)goal.attacker).isEnraged() && ((EntitySarcophagus)goal.attacker).allowAnimation(previous, SHINE)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)7), class_6008.method_34980((Object)MonsterActionUtils.enragedBossAttack(PRISM).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)7), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(MISSILE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.enragedBossAttack(STARFALL).withCondition((goal, target, previous) -> ((EntitySarcophagus)goal.attacker).isEnraged() && ((EntitySarcophagus)goal.attacker).starfallCooldown <= 0).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10));
    private static final List<class_6008.class_6010<IdleAction<EntitySarcophagus>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new DoNothingRunner(true)), (int)1));
    public final AnimatedAttackGoal<EntitySarcophagus> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntitySarcophagus> animationHandler = new AnimationHandler((class_1297)this, ANIMATED_ACTIONS).withChangeListener(anim -> {
        this.hitEntity = null;
        if (anim != null) {
            this.teleported = TELEPORT.is(new AnimatedAction[]{anim});
            if (!TELEPORT.is(new AnimatedAction[]{anim})) {
                this.previousAttack = anim.getID();
            }
            if (CHARGE.is(new AnimatedAction[]{anim})) {
                this.chargeMotion = null;
                this.prevStepHeight = this.field_6013;
                this.field_6013 = 1.0f + this.field_6013;
            }
            if (STARFALL.is(new AnimatedAction[]{anim})) {
                this.gravityPre = this.method_5740();
                this.starfallCooldown = 240 + this.method_6051().nextInt(600);
                this.method_5875(true);
            }
        } else {
            if (this.prevStepHeight != -1.0f) {
                this.field_6013 = this.prevStepHeight;
                this.prevStepHeight = -1.0f;
            }
            if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{STARFALL})) {
                this.method_5875(this.gravityPre);
            }
        }
        return false;
    });
    private class_243 chargeMotion;
    private class_243 starFallPre;
    private class_243 starFallPos;
    protected List<class_1309> hitEntity;
    private boolean teleported;
    private boolean gravityPre;
    private String previousAttack = "";
    private int starfallCooldown;
    private float prevStepHeight = -1.0f;

    public EntitySarcophagus(class_1299<? extends EntitySarcophagus> type, class_1937 world) {
        super((class_1299<? extends BossMonster>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
        this.field_6013 = 1.0f;
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5782, class_1259.class_1261.field_5795).setMusic((class_3414)ModSounds.SARCOPHAGUS_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.26);
        super.applyAttributes();
    }

    @Override
    public void addGoal() {
        super.addGoal();
        this.field_6201.method_6280((class_1352)this.wander);
        this.wander = new RestrictedWaterAvoidingStrollGoal(this, 0.6);
        this.field_6201.method_6277(6, (class_1352)this.wander);
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{DEFEAT, ANGRY}) && !this.isTeleporting()) && super.method_5643(source, amount);
    }

    @Override
    public boolean method_5747(float fallDistance, float multiplier, class_1282 source) {
        return false;
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT});
    }

    public boolean method_5727(double x, double y, double z) {
        if (this.isTeleporting()) {
            return false;
        }
        return super.method_5727(x, y, z);
    }

    private boolean isTeleporting() {
        AnimatedAction anim = this.getAnimationHandler().getAnimation();
        if (TELEPORT.is(new AnimatedAction[]{anim})) {
            if (anim.isPast("teleport_start_1") && !anim.isPast("teleport_end_1")) {
                return true;
            }
            if (anim.isPast("teleport_start_2") && !anim.isPast("teleport_end_2")) {
                return true;
            }
            return anim.isPast("teleport_start_3") && !anim.isPast("teleport_end_3");
        }
        if (STARFALL.is(new AnimatedAction[]{anim})) {
            return anim.isPast("teleport_start") && !anim.isPast("teleport_end");
        }
        return false;
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY, DEFEAT, TELEPORT, STARFALL})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    public int animationCooldown(AnimatedAction anim) {
        if (TELEPORT.is(new AnimatedAction[]{anim})) {
            return 7 + this.method_6051().nextInt(6);
        }
        return super.animationCooldown(anim);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{CHARGE})) {
            double width = this.method_17681();
            double speed = Math.max(width, this.method_18798().method_1033() - width);
            float rotY = -class_3532.method_15393((float)((float)(class_3532.method_15349((double)this.method_18798().method_10216(), (double)this.method_18798().method_10215()) * 57.2957763671875)));
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(grow + 0.4, 0.1, grow + 0.4).method_1012(0.0, 0.0, speed), rotY, 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler;
        class_1309 target = this.method_5968();
        if (target != null) {
            this.method_5942().method_6340();
            this.method_5988().method_6226((class_1297)target, 60.0f, 30.0f);
        }
        if ((handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID())) != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.FIRE_CIRCLE.get()))) {
                    this.getAnimationHandler().setAnimation(FIRE_CIRCLE);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.MISSILE_8X.get()))) {
                    this.getAnimationHandler().setAnimation(MISSILE);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.LIGHT_BEAM.get()))) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
        }
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            --this.starfallCooldown;
        }
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE})) {
            if (this.getAnimationHandler().getAnimation().isPast("attack_start")) {
                return this.chargeMotion;
            }
            return null;
        }
        return super.directionToLookAt();
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.84375, -0.5);
    }

    public AnimationHandler<EntitySarcophagus> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean allowAnimation(String prev, AnimatedAction other) {
        if (!this.teleported) {
            return TELEPORT.is(new AnimatedAction[]{other});
        }
        return !TELEPORT.is(new AnimatedAction[]{other}) && !this.previousAttack.equals(other.getID());
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    private void teleportAround(int range, int yRange) {
        class_243 pos = this.method_18410() ? class_243.method_24953((class_2382)this.method_18412()) : (this.method_5968() != null ? this.method_5968().method_19538() : this.method_19538());
        for (int i = 0; i < 10; ++i) {
            double x = pos.method_10216() + (this.method_6051().nextDouble() * 2.0 - 1.0) * (double)range;
            double y = pos.method_10214() + 4.0;
            double z = pos.method_10215() + (this.method_6051().nextDouble() * 2.0 - 1.0) * (double)range;
            if (this.method_18410() && this.method_18412().method_10268(x, y, z) > (double)(this.method_18413() * this.method_18413()) || !this.teleport(x, y, z, yRange)) continue;
            return;
        }
    }

    private boolean teleport(double x, double y, double z, int yRange) {
        class_2338.class_2339 pos = new class_2338.class_2339(x, y - 1.0, z);
        class_2791 chunk = this.field_6002.method_22350((class_2338)pos);
        while (yRange > 0 && pos.method_10264() > this.field_6002.method_31607() && !chunk.method_8320((class_2338)pos).method_26207().method_15801()) {
            pos.method_10098(class_2350.field_11033);
            --yRange;
            y -= 1.0;
        }
        class_2680 blockState = chunk.method_8320((class_2338)pos);
        if (!blockState.method_26207().method_15801()) {
            return false;
        }
        class_243 current = this.method_19538();
        this.method_5859(x, y, z);
        if (!this.field_6002.method_17892((class_1297)this) || this.field_6002.method_22345(this.method_5829())) {
            this.method_5859(current.method_10216(), current.method_10214(), current.method_10215());
            return false;
        }
        return true;
    }

    protected void setChargeDirection(class_243 moveDirection) {
        this.chargeMotion = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.chargeMotion);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.chargeMotion = motion;
        });
    }
}

