/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.MultiPartEntity;
import io.github.flemmli97.runecraftory.common.entities.misc.EntitySlashResidue;
import io.github.flemmli97.runecraftory.common.entities.monster.MultiPartContainer;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CAttackDebug;
import io.github.flemmli97.runecraftory.common.network.S2CScreenShake;
import io.github.flemmli97.runecraftory.common.particles.DurationalParticleData;
import io.github.flemmli97.runecraftory.common.particles.SkelefangParticleData;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.utils.MathUtils;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1160;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntitySkelefang
extends BossMonster {
    public static final byte HEAD_DROP = 70;
    public static final byte HEAD_THROW = 71;
    public static final byte NECK_DROP = 72;
    public static final byte NECK_THROW = 73;
    public static final byte FRONT = 74;
    public static final byte FRONT_RIBS = 75;
    public static final byte LEFT_LEG = 76;
    public static final byte RIGHT_LEG = 77;
    public static final byte BACK = 78;
    public static final byte BACK_RIBS = 79;
    public static final byte TAIL = 80;
    public static final byte TAIL_BASE = 81;
    public static final byte HIT = 82;
    public static final byte SHATTER = 83;
    public static final byte CHARGE_BEAM = 84;
    private static final class_2940<Integer> HEAD_BONES = class_2945.method_12791(EntitySkelefang.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> TAIL_BONES = class_2945.method_12791(EntitySkelefang.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> LEFT_LEG_BONES = class_2945.method_12791(EntitySkelefang.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> RIGHT_LEG_BONES = class_2945.method_12791(EntitySkelefang.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> BODY_BONES = class_2945.method_12791(EntitySkelefang.class, (class_2941)class_2943.field_13327);
    public static final AnimatedAction TAIL_SLAM = AnimatedAction.builder((double)2.0, (String)"tail_slam").marker("attack_1", new double[]{0.72}).marker("attack_2", new double[]{1.2}).marker("attack_3", new double[]{1.64}).build();
    public static final AnimatedAction NEEDLE_THROW = AnimatedAction.builder((double)1.16, (String)"needle_throw").marker("attack", new double[]{0.8}).build();
    public static final AnimatedAction TAIL_SLAP = AnimatedAction.builder((double)0.84, (String)"tail_slap").marker("attack", new double[]{0.52}).build();
    public static final AnimatedAction SLASH = AnimatedAction.builder((double)0.96, (String)"slash").marker("attack", new double[]{0.6}).build();
    public static final AnimatedAction CHARGE = AnimatedAction.builder((double)1.5, (String)"charge").marker("attack_start", new double[]{0.0}).marker("attack_end", new double[0]).build();
    public static final AnimatedAction BEAM = AnimatedAction.builder((double)13.0, (String)"beam").marker("charge", new double[]{4.5}).marker("beam", new double[]{6.5}).marker("restore_start", new double[]{11.0}).marker("restore_end", new double[]{12.0}).marker("restore", new double[]{11.5}).build();
    public static final AnimatedAction DEATH = AnimatedAction.builder((double)10.0, (String)"death").infinite().build();
    public static final AnimatedAction ROAR = AnimatedAction.builder((double)2.0, (String)"roar").marker("roar", new double[]{0.28}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)TAIL_SLAM, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{TAIL_SLAP, NEEDLE_THROW, TAIL_SLAM, SLASH, CHARGE, BEAM, DEATH, ROAR, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntitySkelefang>> ATTACK_HANDLER = EntitySkelefang.createAnimationHandler(b -> {
        b.put((Object)TAIL_SLAM, (anim, entity) -> {
            block2: {
                block3: {
                    if (entity.remainingTailBones() <= 10 && !entity.isEnraged()) break block2;
                    if (anim.isAt("attack_1") || anim.isAt("attack_2")) break block3;
                    if (!anim.isAt("attack_3")) break block2;
                }
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), entity::method_6121);
                entity.field_6002.method_8465(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), class_3417.field_14706, entity.method_5634(), 2.0f, 0.7f);
            }
        });
        b.put((Object)NEEDLE_THROW, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.BONE_NEEDLES.get())))).use((class_1309)entity);
                if (entity.remainingHeadBones() > 10) {
                    entity.field_6002.method_8421((class_1297)entity, (byte)71);
                    entity.setHeadBones(10, false);
                } else if (entity.remainingHeadBones() > 0) {
                    entity.field_6002.method_8421((class_1297)entity, (byte)73);
                    entity.setHeadBones(0, false);
                }
            }
        });
        b.put((Object)TAIL_SLAP, (anim, entity) -> {
            if ((entity.remainingTailBones() > 10 || entity.isEnraged()) && anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), entity::method_6121);
            }
        });
        b.put((Object)SLASH, (anim, entity) -> {
            if (anim.isAt("attack")) {
                EntitySlashResidue slash;
                class_243 side;
                class_243 dir;
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), entity::method_6121);
                class_1297 patt7670$temp = entity.method_5642();
                if (patt7670$temp instanceof class_1657) {
                    class_1657 player = (class_1657)patt7670$temp;
                    dir = class_243.method_1030((float)0.0f, (float)player.field_6283);
                    side = class_243.method_1030((float)0.0f, (float)(player.field_6283 + 90.0f));
                } else {
                    dir = class_243.method_1030((float)0.0f, (float)entity.field_6283);
                    side = class_243.method_1030((float)0.0f, (float)(entity.field_6283 + 90.0f));
                }
                dir = dir.method_1021((double)entity.method_17681() * 0.5 + 1.0);
                if (entity.remainingLeftLegBones() > 0) {
                    class_243 leftPos = entity.method_19538().method_1019(dir).method_1019(side.method_1021(-1.3));
                    slash = new EntitySlashResidue(entity.field_6002, (class_1309)entity);
                    slash.setSize(1.5f);
                    slash.setOneTime();
                    slash.method_5814(leftPos.field_1352, leftPos.field_1351, leftPos.field_1350);
                    slash.method_36457(0.0f);
                    slash.method_36456(entity.field_6283);
                    entity.field_6002.method_8649((class_1297)slash);
                }
                if (entity.remainingRightLegBones() > 0) {
                    class_243 rightPos = entity.method_19538().method_1019(dir).method_1019(side.method_1021(1.3));
                    slash = new EntitySlashResidue(entity.field_6002, (class_1309)entity);
                    slash.setSize(1.5f);
                    slash.setOneTime();
                    slash.method_5814(rightPos.field_1352, rightPos.field_1351, rightPos.field_1350);
                    slash.method_36457(0.0f);
                    slash.method_36456(entity.field_6283);
                    entity.field_6002.method_8649((class_1297)slash);
                }
            }
        });
        b.put((Object)CHARGE, (anim, entity) -> {
            if (entity.hitEntity == null) {
                entity.hitEntity = new ArrayList<class_1309>();
            }
            class_243 dir = entity.method_5968() != null ? entity.method_5968().method_19538().method_1020(entity.method_19538()) : class_243.method_1030((float)0.0f, (float)entity.method_36454());
            if ((dir = new class_243(dir.method_10216(), 0.0, dir.method_10215())).method_1027() < 0.5) {
                entity.method_18800(0.0, entity.method_18798().field_1351, 0.0);
            } else {
                dir = dir.method_1029().method_1021(entity.method_26825(class_5134.field_23719) * 1.3);
                entity.method_18800(dir.method_10216(), entity.method_18798().field_1351, dir.method_10215());
            }
            if (entity.field_6012 % 5 == 0) {
                entity.method_5783((class_3414)ModSounds.ENTITY_GENERIC_HEAVY_CHARGE.get(), 1.0f, (entity.field_5974.nextFloat() - entity.field_5974.nextFloat()) * 0.2f + 1.0f);
                S2CScreenShake.sendAround((class_1297)entity, 24.0, 10, 1.0f);
            }
            entity.mobAttack((AnimatedAction)anim, null, e -> {
                if (!entity.hitEntity.contains(e) && CombatUtils.mobAttack((class_1309)entity, (class_1297)e, new CustomDamage.Builder((class_1297)entity).hurtResistant(5).knock(CustomDamage.KnockBackType.UP).withChangedAttribute((class_1320)ModAttributes.STUN.get(), 70.0))) {
                    entity.hitEntity.add((class_1309)e);
                }
            });
        });
        b.put((Object)BEAM, (anim, entity) -> {
            if (anim.isAt("charge")) {
                entity.field_6002.method_8421((class_1297)entity, (byte)84);
            }
            if (anim.isAt("beam")) {
                ((Spell)((Object)((Object)((Object)ModSpells.ENERGY_ORB_SPELL.get())))).use((class_1309)entity);
            }
            if (anim.isAt("restore")) {
                entity.restoreDragon();
            }
        });
        b.put((Object)ROAR, (anim, entity) -> {
            if (anim.isAt("roar")) {
                entity.method_5783((class_3414)ModSounds.ENTITY_SKELEFANG_ROAR.get(), 1.0f, (entity.field_5974.nextFloat() - entity.field_5974.nextFloat()) * 0.2f + 1.0f);
                S2CScreenShake.sendAround((class_1297)entity, 32.0, 40, 2.0f);
            }
        });
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntitySkelefang>>> ATTACKS = List.of(class_6008.method_34980((Object)new GoalAttackAction(TAIL_SLAM).cooldown(e -> e.animationCooldown(TAIL_SLAM)).withCondition((goal, target, previous) -> ((EntitySkelefang)goal.attacker).remainingTailBones() > 10).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 4.0), e -> 40 + e.method_6051().nextInt(20))), (int)10), class_6008.method_34980((Object)new GoalAttackAction(NEEDLE_THROW).cooldown(e -> e.animationCooldown(NEEDLE_THROW)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 6.0), e -> 40 + e.method_6051().nextInt(20))), (int)9), class_6008.method_34980((Object)new GoalAttackAction(TAIL_SLAP).cooldown(e -> e.animationCooldown(TAIL_SLAP)).withCondition((goal, target, previous) -> ((EntitySkelefang)goal.attacker).remainingTailBones() > 10).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 3.0), e -> 40 + e.method_6051().nextInt(20))), (int)12), class_6008.method_34980((Object)new GoalAttackAction(SLASH).cooldown(e -> e.animationCooldown(SLASH)).withCondition((goal, target, previous) -> ((EntitySkelefang)goal.attacker).remainingRightLegBones() > 0 || ((EntitySkelefang)goal.attacker).remainingLeftLegBones() > 0).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 4.0), e -> 40 + e.method_6051().nextInt(20))), (int)9), class_6008.method_34980((Object)new GoalAttackAction(CHARGE).cooldown(e -> e.animationCooldown(CHARGE)).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.1, 7.0), e -> 20 + e.method_6051().nextInt(20))), (int)11));
    private static final List<class_6008.class_6010<IdleAction<EntitySkelefang>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.0, 3.0)), (int)1));
    public final AnimatedAttackGoal<EntitySkelefang> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntitySkelefang> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (anim != null) {
            this.hitEntity = null;
        }
        if (!this.field_6002.field_9236 && anim == null) {
            boolean chain = !this.commanded;
            this.commanded = false;
            if (chain && this.getAnimationHandler().isCurrent(new AnimatedAction[]{NEEDLE_THROW})) {
                if (!this.isEnraged() || this.needleChain >= 2 || this.needleChain == 1 && (double)this.method_6051().nextFloat() > 0.25) {
                    this.needleChain = 0;
                    return false;
                }
                this.getAnimationHandler().setAnimation(NEEDLE_THROW);
                ++this.needleChain;
                return true;
            }
        }
        return false;
    });
    protected List<class_1309> hitEntity;
    private final MultiPartContainer head;
    private final MultiPartContainer back;
    private final MultiPartContainer rightLeg;
    private final MultiPartContainer leftLeg;
    private int hurtResist;
    private boolean ignoreHurt;
    private boolean commanded;
    private int needleChain;

    public EntitySkelefang(class_1299<? extends EntitySkelefang> type, class_1937 world) {
        super((class_1299<? extends BossMonster>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
        this.head = new MultiPartContainer(() -> new MultiPartEntity((class_1297)this, 1.6f, 1.3f));
        this.back = new MultiPartContainer(() -> new MultiPartEntity((class_1297)this, 1.6f, 1.5f));
        this.rightLeg = new MultiPartContainer(() -> new MultiPartEntity((class_1297)this, 1.5f, 2.5f));
        this.leftLeg = new MultiPartContainer(() -> new MultiPartEntity((class_1297)this, 1.5f, 2.5f));
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5782, class_1259.class_1261.field_5795).setMusic((class_3414)ModSounds.SKELEFANG_FIGHT.get());
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.2);
        super.applyAttributes();
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HEAD_BONES, (Object)20);
        this.field_6011.method_12784(TAIL_BONES, (Object)20);
        this.field_6011.method_12784(LEFT_LEG_BONES, (Object)20);
        this.field_6011.method_12784(RIGHT_LEG_BONES, (Object)20);
        this.field_6011.method_12784(BODY_BONES, (Object)20);
    }

    @Override
    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (key.equals(BODY_BONES) && !this.hasBones()) {
            this.ignoreHurt = true;
        }
    }

    public void restoreDragon() {
        this.field_6011.method_12778(HEAD_BONES, (Object)20);
        this.field_6011.method_12778(TAIL_BONES, (Object)20);
        this.field_6011.method_12778(LEFT_LEG_BONES, (Object)20);
        this.field_6011.method_12778(RIGHT_LEG_BONES, (Object)20);
        this.field_6011.method_12778(BODY_BONES, (Object)20);
    }

    public void setHeadBones(int amount) {
        this.setHeadBones(amount, true);
    }

    private void setHeadBones(int amount, boolean withParticle) {
        int pre = (Integer)this.field_6011.method_12789(HEAD_BONES);
        this.field_6011.method_12778(HEAD_BONES, (Object)Math.min(amount, 20));
        if (withParticle) {
            if (pre > 10 && amount <= 10) {
                this.field_6002.method_8421((class_1297)this, (byte)70);
            }
            if (amount <= 0) {
                this.field_6002.method_8421((class_1297)this, (byte)72);
            }
        }
    }

    public int remainingHeadBones() {
        return (Integer)this.field_6011.method_12789(HEAD_BONES);
    }

    public void setTailBones(int amount) {
        int pre = (Integer)this.field_6011.method_12789(TAIL_BONES);
        this.field_6011.method_12778(TAIL_BONES, (Object)Math.min(amount, 20));
        if (pre > 10 && amount <= 10) {
            this.field_6002.method_8421((class_1297)this, (byte)80);
        }
        if (amount <= 0) {
            this.field_6002.method_8421((class_1297)this, (byte)81);
        }
    }

    public int remainingTailBones() {
        return (Integer)this.field_6011.method_12789(TAIL_BONES);
    }

    public void setLeftLegBones(int amount) {
        this.field_6011.method_12778(LEFT_LEG_BONES, (Object)Math.min(amount, 20));
        if (amount <= 0) {
            this.field_6002.method_8421((class_1297)this, (byte)76);
        }
    }

    public int remainingLeftLegBones() {
        return (Integer)this.field_6011.method_12789(LEFT_LEG_BONES);
    }

    public void setRightLegBones(int amount) {
        this.field_6011.method_12778(RIGHT_LEG_BONES, (Object)Math.min(amount, 20));
        if (amount <= 0) {
            this.field_6002.method_8421((class_1297)this, (byte)77);
        }
    }

    public int remainingRightLegBones() {
        return (Integer)this.field_6011.method_12789(RIGHT_LEG_BONES);
    }

    public void setBodyBones(int amount) {
        int pre = (Integer)this.field_6011.method_12789(BODY_BONES);
        this.field_6011.method_12778(BODY_BONES, (Object)Math.min(amount, 20));
        if (pre > 15 && amount <= 15) {
            this.field_6002.method_8421((class_1297)this, (byte)79);
        }
        if (pre > 10 && amount <= 10) {
            this.field_6002.method_8421((class_1297)this, (byte)78);
        }
        if (pre > 5 && amount <= 5) {
            this.field_6002.method_8421((class_1297)this, (byte)75);
        }
        if (amount <= 0) {
            this.field_6002.method_8421((class_1297)this, (byte)74);
        }
    }

    public boolean checkIgnoreHurtOverlay() {
        if (this.ignoreHurt) {
            this.ignoreHurt = false;
            return true;
        }
        return false;
    }

    public int remainingBodyBones() {
        return (Integer)this.field_6011.method_12789(BODY_BONES);
    }

    public boolean hasBones() {
        return this.remainingHeadBones() > 0 || this.remainingTailBones() > 0 || this.remainingLeftLegBones() > 0 || this.remainingRightLegBones() > 0 || this.remainingBodyBones() > 0;
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("HeadBones", this.remainingHeadBones());
        compound.method_10569("TailBones", this.remainingTailBones());
        compound.method_10569("LeftLegBones", this.remainingLeftLegBones());
        compound.method_10569("RightLegBones", this.remainingRightLegBones());
        compound.method_10569("BodyBones", this.remainingBodyBones());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.field_6011.method_12778(HEAD_BONES, (Object)compound.method_10550("HeadBones"));
        this.field_6011.method_12778(TAIL_BONES, (Object)compound.method_10550("TailBones"));
        this.field_6011.method_12778(LEFT_LEG_BONES, (Object)compound.method_10550("LeftLegBones"));
        this.field_6011.method_12778(RIGHT_LEG_BONES, (Object)compound.method_10550("RightLegBones"));
        this.field_6011.method_12778(BODY_BONES, (Object)compound.method_10550("BodyBones"));
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            --this.hurtResist;
            this.updateParts();
            if (!(this.method_29504() || this.hasBones() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{BEAM}))) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
            if (this.method_5805() && !this.getAnimationHandler().hasAnimation() && !this.isTamed() && (double)(this.method_6032() / this.method_6063()) < 0.5 && !this.isEnraged()) {
                this.setEnraged(true, false);
            }
        }
    }

    @Override
    public void method_5711(byte id) {
        switch (id) {
            case 70: {
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.HEAD, this.method_36455(), this.field_6241, 1.0f, 0.0f), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 71: {
                class_243 look = class_243.method_1030((float)0.0f, (float)this.field_6283);
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.HEAD, this.method_36455(), this.field_6241, -2.0f, 0.0f, 40, false), this.method_23317(), this.method_23318(), this.method_23321(), look.field_1352, look.field_1351, look.field_1350);
                break;
            }
            case 72: {
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.NECK, this.method_36455(), this.field_6241, 1.0f, this.field_5974.nextInt(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 73: {
                class_243 look = class_243.method_1030((float)0.0f, (float)this.field_6283);
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.NECK, this.method_36455(), this.field_6241, -2.0f, 0.0f, 40, false), this.method_23317(), this.method_23318(), this.method_23321(), look.field_1352, look.field_1351, look.field_1350);
                break;
            }
            case 74: {
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.FRONT, this.method_36455(), this.field_6283, this.field_5974.nextInt(2) - 1, this.field_5974.nextInt(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 75: {
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.FRONT_RIBS, this.method_36455(), this.field_6283, this.field_5974.nextInt(2) - 1, this.field_5974.nextInt(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 76: {
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.LEFT_LEG, this.method_36455(), this.field_6283, this.field_5974.nextInt(2) - 1, this.field_5974.nextInt(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 77: {
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.RIGHT_LEG, this.method_36455(), this.field_6283, this.field_5974.nextInt(2) - 1, this.field_5974.nextInt(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 78: {
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.BACK, this.method_36455(), this.field_6283, this.field_5974.nextInt(2) - 1, this.field_5974.nextInt(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 79: {
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.BACK_RIBS, this.method_36455(), this.field_6283, this.field_5974.nextInt(2) - 1, this.field_5974.nextInt(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 80: {
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.TAIL, this.method_36455(), this.field_6283, this.field_5974.nextInt(2) - 1, this.field_5974.nextInt(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 81: {
                this.field_6002.method_8494((class_2394)new SkelefangParticleData(SkelefangParticleData.SkelefangBoneType.TAIL_BASE, this.method_36455(), this.field_6283, this.field_5974.nextInt(2) - 1, this.field_5974.nextInt(2) - 1), this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 82: {
                int amount = this.field_5974.nextInt(6) + 12;
                for (int i = 0; i < amount; ++i) {
                    SkelefangParticleData.SkelefangBoneType type = (double)this.field_5974.nextFloat() < 0.4 ? SkelefangParticleData.SkelefangBoneType.GENERIC : SkelefangParticleData.SkelefangBoneType.GENERIC2;
                    this.field_6002.method_8494((class_2394)new SkelefangParticleData(type, this.method_36455() + (float)this.field_5974.nextInt(40) - 20.0f, this.field_6241 + (float)this.field_5974.nextInt(360), this.field_5974.nextInt(2) - 1, this.field_5974.nextInt(2) - 1), this.method_23322(1.3), this.method_23323(0.5) + (double)this.method_17682() * 0.5, this.method_23325(1.3), this.field_5974.nextGaussian() * 0.11, this.field_5974.nextGaussian() * 0.11, this.field_5974.nextGaussian() * 0.11);
                }
                break;
            }
            case 83: {
                int amount = this.field_5974.nextInt(15) + 35;
                if (this.hasBones()) {
                    for (int i = 0; i < amount; ++i) {
                        SkelefangParticleData.SkelefangBoneType type = (double)this.field_5974.nextFloat() < 0.4 ? SkelefangParticleData.SkelefangBoneType.GENERIC : SkelefangParticleData.SkelefangBoneType.GENERIC2;
                        this.field_6002.method_8494((class_2394)new SkelefangParticleData(type, this.method_36455() + (float)this.field_5974.nextInt(40) - 20.0f, this.field_6241 + (float)this.field_5974.nextInt(360), this.field_5974.nextInt(2) - 1, this.field_5974.nextInt(2) - 1), this.method_23322(1.3), this.method_23323(0.5) + (double)this.method_17682() * 0.5, this.method_23325(1.3), this.field_5974.nextGaussian() * 0.13, this.field_5974.nextGaussian() * 0.13, this.field_5974.nextGaussian() * 0.13);
                    }
                }
                if (this.remainingHeadBones() > 10) {
                    this.method_5711((byte)70);
                }
                if (this.remainingHeadBones() > 0) {
                    this.method_5711((byte)72);
                }
                if (this.remainingBodyBones() > 0) {
                    this.method_5711((byte)74);
                }
                if (this.remainingBodyBones() > 5) {
                    this.method_5711((byte)75);
                }
                if (this.remainingBodyBones() > 10) {
                    this.method_5711((byte)78);
                }
                if (this.remainingBodyBones() > 15) {
                    this.method_5711((byte)79);
                }
                if (this.remainingLeftLegBones() > 0) {
                    this.method_5711((byte)76);
                }
                if (this.remainingRightLegBones() > 0) {
                    this.method_5711((byte)77);
                }
                if (this.remainingTailBones() > 0) {
                    this.method_5711((byte)81);
                }
                if (this.remainingTailBones() <= 10) break;
                this.method_5711((byte)80);
                break;
            }
            case 84: {
                class_243 center = this.method_19538().method_1031(0.0, (double)this.method_17682() * 0.5, 0.0);
                ArrayList locations = new ArrayList();
                double speed = (this.method_17681() + 2.0f) / 40.0f;
                locations.addAll(RayTraceUtils.rotatedVecs((class_243)MathUtils.NORMAL_X.method_1021((double)(this.method_17681() + 2.0f)), (class_243)MathUtils.NORMAL_Z, (float)-180.0f, (float)180.0f, (float)10.0f));
                locations.addAll(RayTraceUtils.rotatedVecs((class_243)MathUtils.NORMAL_X.method_1021((double)(this.method_17681() + 2.0f)), (class_243)MathUtils.NORMAL_Y, (float)-180.0f, (float)180.0f, (float)10.0f));
                locations.addAll(RayTraceUtils.rotatedVecs((class_243)MathUtils.NORMAL_Y.method_1021((double)(this.method_17681() + 2.0f)), (class_243)MathUtils.NORMAL_X, (float)-180.0f, (float)180.0f, (float)10.0f));
                for (class_1160 vec : locations) {
                    class_243 pos = center.method_1031((double)vec.method_4943(), (double)vec.method_4945(), (double)vec.method_4947());
                    class_243 dir = new class_243((double)vec.method_4943(), (double)vec.method_4945(), (double)vec.method_4947()).method_1029().method_1021(speed);
                    this.field_6002.method_8494((class_2394)new DurationalParticleData(0.8509804f, 0.972549f, 0.9882353f, 0.4f, 2.3f, 40, this.method_5628()), pos.method_10216(), pos.method_10214(), pos.method_10215(), -dir.method_10216(), -dir.method_10214(), -dir.method_10215());
                }
                break;
            }
            default: {
                super.method_5711(id);
            }
        }
        if (this.field_6254 == 10 && this.checkIgnoreHurtOverlay()) {
            this.field_6254 = 0;
        }
    }

    private void updateParts() {
        if (this.remainingTailBones() > 0) {
            class_243 view = this.method_5631(0.0f, this.field_6283);
            class_243 backPos = this.method_19538().method_1019(view.method_1021(-1.0)).method_1031(0.0, 1.0, 0.0);
            this.back.updatePositionTo(backPos.method_10216(), backPos.method_10214(), backPos.method_10215(), true);
        } else {
            this.back.removeEntity();
        }
        if (this.remainingHeadBones() > 10) {
            class_243 headPos = this.method_19538().method_1019(this.method_5631(this.method_36455() * 0.6f, this.field_6283).method_1021(2.9).method_1031(0.0, 2.15, 0.0));
            this.head.updatePositionTo(headPos.method_10216(), headPos.method_10214(), headPos.method_10215(), true);
        } else {
            this.head.removeEntity();
        }
        class_243 side = this.method_5631(0.0f, this.field_6283 + 90.0f);
        if (this.remainingLeftLegBones() > 0) {
            class_243 leftLegPos = this.method_19538().method_1019(side.method_1021(-1.0)).method_1031(0.0, 0.0, 0.0);
            this.leftLeg.updatePositionTo(leftLegPos.method_10216(), leftLegPos.method_10214(), leftLegPos.method_10215(), true);
        } else {
            this.leftLeg.removeEntity();
        }
        if (this.remainingRightLegBones() > 0) {
            class_243 rightLegPos = this.method_19538().method_1019(side.method_1021(1.0)).method_1031(0.0, 0.0, 0.0);
            this.rightLeg.updatePositionTo(rightLegPos.method_10216(), rightLegPos.method_10214(), rightLegPos.method_10215(), true);
        } else {
            this.rightLeg.removeEntity();
        }
    }

    @Override
    protected boolean checkRage() {
        return false;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return !this.getAnimationHandler().isCurrent(new AnimatedAction[]{ROAR}) && super.method_5643(source, amount);
    }

    @Override
    protected void method_6074(class_1282 damageSrc, float damageAmount) {
        if (damageSrc == class_1282.field_5849) {
            super.method_6074(damageSrc, damageAmount);
            if (this.method_29504()) {
                this.field_6002.method_8421((class_1297)this, (byte)83);
            }
            return;
        }
        if (this.hurtResist > 0) {
            return;
        }
        this.hurtResist = 2;
        if (this.hasBones()) {
            if (damageAmount > 4.0f) {
                int amount;
                int boneDamage = 7;
                if (this.remainingTailBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingTailBones());
                    boneDamage -= amount;
                    this.setTailBones(this.remainingTailBones() - amount);
                }
                if (this.remainingLeftLegBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingLeftLegBones());
                    boneDamage -= amount;
                    this.setLeftLegBones(this.remainingLeftLegBones() - amount);
                }
                if (this.remainingRightLegBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingRightLegBones());
                    boneDamage -= amount;
                    this.setRightLegBones(this.remainingRightLegBones() - amount);
                }
                if (this.remainingHeadBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingHeadBones());
                    boneDamage -= amount;
                    this.setHeadBones(this.remainingHeadBones() - amount);
                }
                if (this.remainingBodyBones() > 0) {
                    amount = Math.min(boneDamage, this.remainingBodyBones());
                    this.setBodyBones(this.remainingBodyBones() - amount);
                }
            }
            if (this.method_29504()) {
                this.field_6002.method_8421((class_1297)this, (byte)83);
            } else {
                this.field_6002.method_8421((class_1297)this, (byte)82);
            }
            if (!this.hasBones()) {
                this.getAnimationHandler().setAnimation(BEAM);
            }
        } else {
            super.method_6074(damageSrc, damageAmount);
        }
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEATH;
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE})) {
            return null;
        }
        return super.directionToLookAt();
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        this.method_5942().method_6340();
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void mobAttack(AnimatedAction anim, class_1309 target, Consumer<class_1309> cons) {
        if (anim.is(new AnimatedAction[]{CHARGE})) {
            double width = this.method_17681();
            double speed = Math.max(width, this.method_18798().method_1033() - width);
            OrientedBoundingBox obb = new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(0.2, 0.0, 0.2).method_1012(0.0, 0.0, speed), this.method_36454(), 0.0f, this.method_19538());
            this.field_6002.method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.hitPred.test(entity) && obb.intersects(entity.method_5829())).forEach(cons);
            if (!this.field_6002.field_9236) {
                S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
            }
            return;
        }
        ArrayList<OrientedBoundingBox> obbs = new ArrayList<OrientedBoundingBox>();
        if (anim.is(new AnimatedAction[]{TAIL_SLAP})) {
            double range = this.method_17681() + 5.0f;
            obbs.add(new OrientedBoundingBox(new class_238(-range * 0.75, -0.02, 0.0, range * 0.75, 1.82, range), this.method_36454(), 0.0f, this.method_19538()));
        }
        if (anim.is(new AnimatedAction[]{TAIL_SLAM})) {
            float angle = this.field_6241;
            class_1297 class_12972 = this.method_5642();
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                angle = player.field_6241;
            }
            if (anim.isAt("attack_2")) {
                angle -= 35.0f;
            } else if (anim.isAt("attack_3")) {
                angle += 20.0f;
            }
            obbs.add(new OrientedBoundingBox(new class_238(-1.25, -0.02, 0.0, 1.25, 2.12, 7.0), angle, 0.0f, this.method_19538()));
        }
        if (anim.is(new AnimatedAction[]{SLASH})) {
            class_243 side;
            class_243 dir;
            double reach = 1.0;
            class_1297 class_12973 = this.method_5642();
            if (class_12973 instanceof class_1657) {
                class_1657 player = (class_1657)class_12973;
                dir = class_243.method_1030((float)0.0f, (float)player.field_6283);
                side = class_243.method_1030((float)0.0f, (float)(player.field_6283 + 90.0f));
            } else {
                dir = class_243.method_1030((float)0.0f, (float)this.field_6283);
                side = class_243.method_1030((float)0.0f, (float)(this.field_6283 + 90.0f));
            }
            dir = dir.method_1021((double)this.method_17681() * 0.5 + reach);
            double attackSize = 1.65;
            if (this.remainingLeftLegBones() > 0) {
                class_243 rightPos = this.method_19538().method_1019(dir).method_1019(side.method_1021(1.3));
                obbs.add(new OrientedBoundingBox(new class_238(-attackSize, -0.02, -attackSize, attackSize, 1.82, attackSize), this.method_36454(), 0.0f, rightPos));
            }
            if (this.remainingRightLegBones() > 0) {
                class_243 leftPos = this.method_19538().method_1019(dir).method_1019(side.method_1021(-1.3));
                obbs.add(new OrientedBoundingBox(new class_238(-attackSize, -0.02, -attackSize, attackSize, 1.82, attackSize), this.method_36454(), 0.0f, leftPos));
            }
        }
        HashSet targets = new HashSet();
        for (OrientedBoundingBox obb : obbs) {
            targets.addAll(this.field_6002.method_8390(class_1309.class, obb.getEncompassingBox(), entity -> this.hitPred.test(entity) && obb.intersects(entity.method_5829())));
            if (this.field_6002.field_9236) continue;
            S2CAttackDebug.sendDebugPacket(obb, S2CAttackDebug.EnumAABBType.ATTACK, (class_1297)this);
        }
        targets.forEach(cons);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), null)) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(CHARGE);
            } else {
                this.getAnimationHandler().setAnimation(TAIL_SLAP);
            }
            this.commanded = true;
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ROAR);
        }
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        if (this.hasBones()) {
            return new class_243(0.0, 2.71875, 0.4375);
        }
        return new class_243(0.0, 1.875, -0.1875);
    }

    public AnimationHandler<EntitySkelefang> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public int animationCooldown(AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        return (this.isEnraged() ? 27 + this.method_6051().nextInt(20) : 35 + this.method_6051().nextInt(25)) + diffAdd;
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return DEATH;
    }

    @Override
    public void playAngrySound() {
    }
}

