/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.RestrictedWaterAvoidingStrollGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableDatas;
import io.github.flemmli97.runecraftory.common.entities.data.SyncableEntityData;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.network.S2CMobUpdate;
import io.github.flemmli97.runecraftory.common.registry.ModParticles;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveAwayRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetAttackRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.MoveToTargetRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StrafingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.TimedWrappedRunner;
import io.github.flemmli97.tenshilib.common.particle.ColoredParticleData;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_6008;

public class EntityThunderbolt
extends BossMonster {
    public static final AnimatedAction BACK_KICK = AnimatedAction.builder((double)0.64, (String)"back_kick").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction LASER_X5 = AnimatedAction.builder((double)1.44, (String)"laser_x5").marker("attack", new double[]{1.2}).build();
    public static final AnimatedAction STOMP = AnimatedAction.builder((double)0.44, (String)"stomp").marker("attack", new double[]{0.28}).build();
    public static final AnimatedAction HORN_ATTACK = AnimatedAction.builder((double)0.44, (String)"horn_attack").marker("attack", new double[]{0.24}).build();
    public static final AnimatedAction BACK_KICK_HORN = AnimatedAction.copyOf((AnimatedAction)BACK_KICK, (String)"back_kick_horn");
    public static final AnimatedAction CHARGE = AnimatedAction.builder((double)1.64, (String)"charge").marker("attack_start", new double[]{0.44}).marker("attack_end", new double[]{1.12}).build();
    public static final AnimatedAction CHARGE_2 = AnimatedAction.copyOf((AnimatedAction)CHARGE, (String)"charge_2");
    public static final AnimatedAction CHARGE_3 = AnimatedAction.copyOf((AnimatedAction)CHARGE, (String)"charge_3");
    public static final AnimatedAction LASER_AOE = AnimatedAction.copyOf((AnimatedAction)LASER_X5, (String)"laser_aoe");
    public static final AnimatedAction LASER_KICK = AnimatedAction.builder((double)1.2, (String)"laser_kick").marker("attack", new double[]{0.32}).build();
    public static final AnimatedAction LASER_KICK_2 = AnimatedAction.copyOf((AnimatedAction)LASER_KICK, (String)"laser_kick_2");
    public static final AnimatedAction WIND_BLADE = AnimatedAction.builder((double)0.72, (String)"wind_blade").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction LASER_KICK_3 = AnimatedAction.copyOf((AnimatedAction)LASER_KICK, (String)"laser_kick_3");
    public static final AnimatedAction FEINT = AnimatedAction.builder((double)2.0, (String)"feint").marker("neigh", new double[]{0.96}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    public static final AnimatedAction NEIGH = AnimatedAction.builder((double)1.16, (String)"neigh").marker("neigh", new double[]{0.48}).build();
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)STOMP, (String)"interact");
    private static final float RANGE_THRESHOLD = 0.7f;
    private static final float FEINT_THRESHOLD = 0.35f;
    private static final AnimatedAction[] ANIMATED_ACTIONS = new AnimatedAction[]{BACK_KICK, LASER_X5, STOMP, HORN_ATTACK, BACK_KICK_HORN, CHARGE, CHARGE_2, CHARGE_3, LASER_AOE, LASER_KICK, LASER_KICK_2, WIND_BLADE, LASER_KICK_3, FEINT, DEFEAT, NEIGH, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityThunderbolt>> ATTACK_HANDLER = EntityThunderbolt.createAnimationHandler(b -> {
        BiConsumer<AnimatedAction, EntityThunderbolt> kick = (anim, entity) -> {
            class_1309 target = entity.method_5968();
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, target, e -> {
                    if (entity.method_6121((class_1297)e)) {
                        e.method_18800(0.0, 0.05, 0.0);
                        e.field_6007 = true;
                        e.method_6005((double)0.8f, entity.method_23317() - e.method_23317(), entity.method_23321() - e.method_23321());
                    }
                });
            }
        };
        b.put((Object)BACK_KICK, kick);
        b.put((Object)BACK_KICK_HORN, kick);
        b.put((Object)HORN_ATTACK, (anim, entity) -> {
            class_1309 target = entity.method_5968();
            if (anim.isAt("attack")) {
                AtomicBoolean bool = new AtomicBoolean(false);
                entity.mobAttack((AnimatedAction)anim, target, e -> {
                    if (entity.method_6121((class_1297)e)) {
                        if (!bool.get()) {
                            bool.set(true);
                        }
                        e.method_18800(0.0, 0.65, 0.0);
                        e.field_6007 = true;
                    }
                });
                if (bool.get() && !entity.method_5782()) {
                    entity.hornAttackSuccess = true;
                }
            }
        });
        b.put((Object)STOMP, (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.mobAttack((AnimatedAction)anim, entity.method_5968(), entity::method_6121);
            }
        });
        b.put((Object)WIND_BLADE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.DOUBLE_SONIC.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)LASER_X5, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.LASER5.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)LASER_AOE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.LASER_AOE.get())))).use((class_1309)entity);
            }
        });
        BiConsumer<AnimatedAction, EntityThunderbolt> bigLaser = (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.BIG_LIGHTNING.get())))).use((class_1309)entity);
            }
        };
        b.put((Object)LASER_KICK, bigLaser);
        b.put((Object)LASER_KICK_2, bigLaser);
        b.put((Object)LASER_KICK_3, bigLaser);
        BiConsumer<AnimatedAction, EntityThunderbolt> charge = (anim, entity) -> {
            if (entity.chargeMotion == null) {
                entity.setChargeDirection(EntityUtils.getTargetDirection((class_1308)entity, class_2183.class_2184.field_9853, true).method_1021(2.0));
            }
            if (anim.isAt("attack_start")) {
                entity.method_18800(entity.chargeMotion.method_10216(), 0.2, entity.chargeMotion.method_10215());
            }
            if (anim.isPast("attack_start") && !anim.isPast("attack_end") && !entity.chargeAttackSuccess) {
                entity.mobAttack((AnimatedAction)anim, null, e -> {
                    if (entity.method_6121((class_1297)e)) {
                        entity.chargeAttackSuccess = true;
                        entity.method_18800(0.0, entity.method_18798().field_1351, 0.0);
                    }
                });
            }
        };
        b.put((Object)CHARGE, charge);
        b.put((Object)CHARGE_2, charge);
        b.put((Object)CHARGE_3, charge);
        b.put((Object)NEIGH, (anim, entity) -> {
            if (anim.isAt("neigh")) {
                entity.method_5783((class_3414)ModSounds.ENTITY_THUNDERBOLT_NEIGH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
            }
        });
        b.put((Object)FEINT, (anim, entity) -> {
            if (anim.isAt("neigh")) {
                entity.method_5783((class_3414)ModSounds.ENTITY_THUNDERBOLT_NEIGH.get(), 1.0f, (entity.method_6051().nextFloat() - entity.method_6051().nextFloat()) * 0.2f + 1.0f);
            }
        });
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntityThunderbolt>>> ATTACKS = List.of(class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(BACK_KICK).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, BACK_KICK) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.method_6051().nextInt(15))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(LASER_X5).withCondition((goal, target, previous) -> !((EntityThunderbolt)goal.attacker).isEnraged() && ((EntityThunderbolt)goal.attacker).allowAnimation(previous, LASER_X5) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(2.0, 1.2, 4), e -> 35 + e.method_6051().nextInt(15))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(STOMP).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, STOMP) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.method_6051().nextInt(15))), (int)11), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(HORN_ATTACK).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, HORN_ATTACK) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.method_6051().nextInt(15))), (int)9), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(CHARGE).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, CHARGE) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.method_6051().nextInt(15))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(LASER_AOE).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).isEnraged() && ((EntityThunderbolt)goal.attacker).allowAnimation(previous, LASER_AOE) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(2.0, 1.2, 4), e -> 35 + e.method_6051().nextInt(15))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(LASER_KICK).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).isEnraged() && ((EntityThunderbolt)goal.attacker).allowAnimation(previous, LASER_KICK) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.method_6051().nextInt(15))), (int)8), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(WIND_BLADE).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, WIND_BLADE) && !((EntityThunderbolt)goal.attacker).feintedDeath).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.2, 7.0), e -> 35 + e.method_6051().nextInt(15))), (int)7), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(WIND_BLADE).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).allowAnimation(previous, WIND_BLADE) && !((EntityThunderbolt)goal.attacker).feintedDeath && ((EntityThunderbolt)goal.attacker).method_5968() != null && ((EntityThunderbolt)goal.attacker).method_5968().method_23318() - ((EntityThunderbolt)goal.attacker).method_23318() > 4.0).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetRunner(1.2, 7.0), e -> 35 + e.method_6051().nextInt(15))), (int)6), class_6008.method_34980((Object)new GoalAttackAction(LASER_AOE).cooldown(e -> e.animationCooldown(LASER_AOE) + 30).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).afterFeint()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveAwayRunner(2.0, 1.2, 4), e -> 35 + e.method_6051().nextInt(15))), (int)4), class_6008.method_34980((Object)new GoalAttackAction(CHARGE).cooldown(e -> e.animationCooldown(CHARGE) + 40).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).afterFeint()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.method_6051().nextInt(15))), (int)20), class_6008.method_34980((Object)new GoalAttackAction(LASER_KICK).cooldown(e -> e.animationCooldown(LASER_KICK) + 50).withCondition((goal, target, previous) -> ((EntityThunderbolt)goal.attacker).afterFeint()).prepare(() -> new TimedWrappedRunner((ActionRun)new MoveToTargetAttackRunner(1.2), e -> 35 + e.method_6051().nextInt(15))), (int)17));
    private static final List<class_6008.class_6010<IdleAction<EntityThunderbolt>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new MoveToTargetRunner(1.1, 0.5)), (int)8), class_6008.method_34980((Object)new IdleAction(() -> new StrafingRunner(7.0f, 1.1f, 0.2f)), (int)10), class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new).withCondition((goal, target) -> ((EntityThunderbolt)goal.attacker).afterFeint()), (int)6));
    public final AnimatedAttackGoal<EntityThunderbolt> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityThunderbolt> animationHandler = new AnimationHandler((class_1297)this, ANIMATED_ACTIONS).withChangeListener(anim -> {
        if (!this.field_6002.field_9236) {
            this.setChargeDirection(null);
            if (anim == null) {
                AnimatedAction chainAnim = this.chainAnim(this.getAnimationHandler().getAnimation());
                this.chargeAttackSuccess = false;
                this.hornAttackSuccess = false;
                boolean chain = !this.commanded;
                this.commanded = false;
                if (chain && chainAnim != null) {
                    this.getAnimationHandler().setAnimation(chainAnim);
                    return true;
                }
            }
            return false;
        }
        return false;
    });
    protected boolean feintedDeath;
    protected boolean hornAttackSuccess;
    protected boolean chargeAttackSuccess;
    private class_243 chargeMotion;
    private boolean commanded;

    public EntityThunderbolt(class_1299<? extends BossMonster> type, class_1937 world) {
        super(type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
        this.field_6013 = 1.0f;
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5780, class_1259.class_1261.field_5795).setMusic((class_3414)ModSounds.THUNDERBOLT_FIGHT.get());
    }

    private boolean afterFeint() {
        return !this.isTamed() && this.isEnraged() && this.feintedDeath;
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.31);
        super.applyAttributes();
    }

    @Override
    public void addGoal() {
        super.addGoal();
        this.field_6201.method_6280((class_1352)this.wander);
        this.wander = new RestrictedWaterAvoidingStrollGoal(this, 0.6);
        this.field_6201.method_6277(6, (class_1352)this.wander);
    }

    @Override
    public double sprintSpeedThreshold() {
        return 0.9;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return (!this.getAnimationHandler().hasAnimation() || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{FEINT, DEFEAT, NEIGH})) && super.method_5643(source, amount);
    }

    @Override
    protected boolean method_6062() {
        return super.method_6062() || this.getAnimationHandler().isCurrent(new AnimatedAction[]{FEINT, DEFEAT});
    }

    public void method_5762(double x, double y, double z) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{FEINT, DEFEAT})) {
            return;
        }
        super.method_5762(x, y, z);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public OrientedBoundingBox calculateAttackAABB(AnimatedAction anim, class_243 target, double grow) {
        if (anim.is(new AnimatedAction[]{STOMP})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1009(1.7, -0.4, 1.7), this.method_36454(), 0.0f, this.method_19538());
        }
        if (anim.is(new AnimatedAction[]{CHARGE, CHARGE_2, CHARGE_3})) {
            return new OrientedBoundingBox(OrientedBoundingBox.originAABB((class_1297)this).method_1014(grow + 1.0), this.method_36454(), 0.0f, this.method_19538());
        }
        return super.calculateAttackAABB(anim, target, grow);
    }

    @Override
    public class_238 attackBB(AnimatedAction anim) {
        double width = (double)this.method_17681() * 1.6;
        double length = (double)this.method_17681() * 1.5;
        if (anim.is(new AnimatedAction[]{HORN_ATTACK})) {
            width = (double)this.method_17681() * 1.3;
            length = (double)this.method_17681() * 1.8;
        }
        return new class_238(-width * 0.5, -0.02, 0.0, width * 0.5, (double)this.method_17682() + 0.02, length);
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 2 ? (Spell)((Object)ModSpells.LASER5.get()) : null)) {
                return;
            }
            if (command == 2) {
                this.getAnimationHandler().setAnimation(LASER_X5);
            } else if (command == 1) {
                this.getAnimationHandler().setAnimation(STOMP);
            } else {
                this.getAnimationHandler().setAnimation(HORN_ATTACK);
            }
            this.commanded = true;
        }
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return class_3417.field_14923;
    }

    protected class_3414 method_5994() {
        return class_3417.field_14947;
    }

    public float method_6017() {
        return (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 0.8f;
    }

    @Override
    public double ridingSpeedModifier() {
        return 1.5;
    }

    @Override
    public void method_5773() {
        AnimatedAction anim;
        super.method_5773();
        if (!this.field_6002.field_9236 && this.method_6032() > 0.0f && this.getAnimationHandler().isCurrent(new AnimatedAction[]{DEFEAT}) && !this.feintedDeath && !this.isTamed() && (anim = this.getAnimationHandler().getAnimation()).done(0)) {
            this.feintDeath();
        }
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{FEINT, DEFEAT}) && !this.isTamed()) {
            class_243 delta = this.method_18798();
            this.method_18800(0.0, delta.field_1351, 0.0);
            if (this.getAnimationHandler().getAnimation().is(new AnimatedAction[]{DEFEAT})) {
                int tick = (int)this.getAnimationHandler().getAnimation().getTick(1.0f);
                if (tick < 40) {
                    if (tick % 10 == 0) {
                        this.field_6002.method_8406((class_2394)new ColoredParticleData((class_2396)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.method_23317() + (this.field_5974.nextDouble() - 0.5) * (double)this.method_17681(), this.method_23318() + this.field_5974.nextDouble() * (double)this.method_17682(), this.method_23321() + (this.field_5974.nextDouble() - 0.5) * (double)this.method_17681(), this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02);
                    }
                } else if (tick < 80) {
                    if (tick % 2 == 0) {
                        this.field_6002.method_8406((class_2394)new ColoredParticleData((class_2396)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.method_23317() + (this.field_5974.nextDouble() - 0.5) * (double)(this.method_17681() + 2.0f), this.method_23318() + this.field_5974.nextDouble() * (double)(this.method_17682() + 1.0f), this.method_23321() + (this.field_5974.nextDouble() - 0.5) * (double)(this.method_17681() + 2.0f), this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02);
                    }
                } else {
                    int amount = (tick - 80) / 10;
                    for (int i = 0; i < amount; ++i) {
                        this.field_6002.method_8406((class_2394)new ColoredParticleData((class_2396)ModParticles.BLINK.get(), 0.2784314f, 0.92941177f, 1.0f, 1.0f), this.method_23317() + (this.field_5974.nextDouble() - 0.5) * (double)(this.method_17681() + 3.0f), this.method_23318() + this.field_5974.nextDouble() * (double)(this.method_17682() + 1.0f), this.method_23321() + (this.field_5974.nextDouble() - 0.5) * (double)(this.method_17681() + 3.0f), this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02, this.field_5974.nextGaussian() * 0.02);
                    }
                }
            }
        }
    }

    protected void feintDeath() {
        this.feintedDeath = true;
        this.getAnimationHandler().setAnimation(FEINT);
        STAT_INCREASE.forEach(att -> {
            class_1324 inst = this.method_5996((class_1320)att.get());
            inst.method_6200(STAT_INCREASE_ID);
            inst.method_26837(new class_1322(STAT_INCREASE_ID, "rf.boss_stat_increase", 0.2, class_1322.class_1323.field_6331));
        });
    }

    @Override
    protected class_243 directionToLookAt() {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{CHARGE, CHARGE_2, CHARGE_3})) {
            return this.chargeMotion;
        }
        return super.directionToLookAt();
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("Feint", this.feintedDeath);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.feintedDeath = compound.method_10577("Feint");
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        if (flag && !load) {
            if (!this.isEnraged()) {
                this.getAnimationHandler().setAnimation(NEIGH);
                this.method_5942().method_6340();
            } else {
                this.getAnimationHandler().setAnimation(DEFEAT);
                this.method_5942().method_6340();
                this.bossInfo.method_5408(0.0f);
            }
        }
        super.setEnraged(flag, load);
    }

    @Override
    protected void updateBossBar() {
        if (!this.feintedDeath) {
            this.bossInfo.method_5408((this.method_6032() - this.method_6063() * 0.35f) / (this.method_6063() * 0.7f));
        } else {
            this.bossInfo.method_5408(this.method_6032() / this.method_6063());
        }
    }

    @Override
    protected boolean checkRage() {
        if (this.method_6032() / this.method_6063() < 0.35f) {
            return !this.feintedDeath;
        }
        if (this.method_6032() / this.method_6063() < 0.7f) {
            return !this.isEnraged();
        }
        return false;
    }

    @Override
    protected void fullyHeal() {
        super.fullyHeal();
        this.feintedDeath = false;
    }

    public boolean method_5805() {
        return super.method_5805() && (this.getAnimationHandler() == null || !this.getAnimationHandler().isCurrent(new AnimatedAction[]{FEINT, DEFEAT}));
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (!state.method_26207().method_15797()) {
            class_2680 blockstate = this.field_6002.method_8320(pos.method_10084());
            class_2498 soundtype = Platform.INSTANCE.getSoundType(state, this.field_6002, pos, (class_1297)this);
            if (blockstate.method_27852(class_2246.field_10477)) {
                soundtype = Platform.INSTANCE.getSoundType(blockstate, this.field_6002, pos, (class_1297)this);
            }
            this.method_5783(class_3417.field_14987, soundtype.method_10597() * 0.15f, soundtype.method_10599());
        }
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 1.6875, -0.25);
    }

    public AnimationHandler<EntityThunderbolt> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public boolean allowAnimation(String prev, AnimatedAction other) {
        if (!this.isTamed() && this.isEnraged() && this.feintedDeath) {
            return other.is(new AnimatedAction[]{CHARGE, LASER_KICK, LASER_AOE});
        }
        if (prev.equals(CHARGE_2.getID()) || prev.equals(CHARGE_3.getID())) {
            return !other.getID().equals(CHARGE.getID());
        }
        if (prev.equals(LASER_KICK_2.getID()) || prev.equals(LASER_KICK_3.getID())) {
            return !other.getID().equals(LASER_KICK.getID());
        }
        if (prev.equals(BACK_KICK_HORN.getID())) {
            return !other.getID().equals(HORN_ATTACK.getID());
        }
        return super.allowAnimation(prev, other);
    }

    public AnimatedAction chainAnim(AnimatedAction anim) {
        if (anim == null) {
            return null;
        }
        return switch (anim.getID()) {
            case "laser_kick" -> {
                if (this.isEnraged() && this.feintedDeath) {
                    yield LASER_KICK_2;
                }
                yield null;
            }
            case "laser_kick_2" -> {
                if (this.feintedDeath) {
                    yield LASER_KICK_3;
                }
                yield null;
            }
            case "horn_attack" -> {
                if (this.hornAttackSuccess) {
                    yield BACK_KICK_HORN;
                }
                yield null;
            }
            case "charge" -> {
                if (this.chargeAttackSuccess) {
                    yield null;
                }
                yield CHARGE_2;
            }
            case "charge_2" -> {
                if (this.isEnraged() && !this.chargeAttackSuccess) {
                    yield CHARGE_3;
                }
                yield null;
            }
            default -> null;
        };
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public void playAngrySound() {
    }

    protected void setChargeDirection(class_243 moveDirection) {
        this.chargeMotion = moveDirection;
        S2CMobUpdate.send(this, SyncableDatas.MOTION_DIR, this.chargeMotion);
    }

    @Override
    public void onUpdate(SyncableEntityData.SyncedContainer<?> data) {
        super.onUpdate(data);
        data.runIf(SyncableDatas.MOTION_DIR, motion -> {
            this.chargeMotion = motion;
        });
    }
}

