/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.monster.EntitySanoUno;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.EntitySano;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_5575;
import net.minecraft.class_6008;

public class EntityUno
extends EntitySanoUno {
    public static final AnimatedAction WATER_LASER = AnimatedAction.builder((double)2.0, (String)"water_laser").marker("attack_1", new double[]{0.8}).marker("attack_2", new double[]{1.2}).build();
    public static final AnimatedAction WATER_LASER_2 = AnimatedAction.builder((double)2.0, (String)"water_swipe").marker("attack_1", new double[]{0.8}).marker("attack_2", new double[]{1.6}).build();
    public static final AnimatedAction ICEBALLS_5 = AnimatedAction.builder((double)3.0, (String)"iceballs").marker("attack", new double[]{0.8, 1.2, 1.6, 2.0, 2.4}).build();
    public static final AnimatedAction HOMING_WATER_WAVE = AnimatedAction.builder((double)2.0, (String)"water_wave").marker("attack", new double[]{0.8}).build();
    public static final AnimatedAction DEFEAT = AnimatedAction.builder((double)10.0, (String)"defeat").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{WATER_LASER, WATER_LASER_2, ICEBALLS_5, HOMING_WATER_WAVE, DEFEAT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityUno>> ATTACK_HANDLER = EntityUno.createAnimationHandler(b -> {
        b.put((Object)WATER_LASER, (anim, entity) -> {
            if (anim.isAt("attack_1")) {
                ((Spell)((Object)((Object)((Object)ModSpells.WATER_LASER_LONG.get())))).use((class_1309)entity);
            }
            if (anim.isAt("attack_2")) {
                ((Spell)((Object)((Object)((Object)ModSpells.PARALLEL_LASER_LONG.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)WATER_LASER_2, (anim, entity) -> {
            if (anim.isAt("attack_1")) {
                entity.reversedSwipe = false;
                ((Spell)((Object)((Object)((Object)ModSpells.WATER_SWIPE.get())))).use((class_1309)entity);
            }
            if (anim.isAt("attack_2")) {
                entity.reversedSwipe = true;
                ((Spell)((Object)((Object)((Object)ModSpells.WATER_SWIPE.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)ICEBALLS_5, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.ICE_BALL_DROP.get())))).use((class_1309)entity);
            }
        });
        b.put((Object)HOMING_WATER_WAVE, (anim, entity) -> {
            if (anim.isAt("attack")) {
                ((Spell)((Object)((Object)((Object)ModSpells.ICE_TRAIL.get())))).use((class_1309)entity);
            }
        });
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntityUno>>> ATTACKS = List.of(class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(WATER_LASER).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(WATER_LASER_2).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(ICEBALLS_5).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10), class_6008.method_34980((Object)MonsterActionUtils.nonRepeatableAttack(HOMING_WATER_WAVE).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)10));
    private static final List<class_6008.class_6010<IdleAction<EntityUno>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new).duration(e -> e.method_6051().nextInt(20) + 35), (int)1));
    public final AnimatedAttackGoal<EntityUno> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private final AnimationHandler<EntityUno> animationHandler = new AnimationHandler((class_1297)this, ANIMS);
    private EntitySano other;

    public EntityUno(class_1299<? extends EntityUno> type, class_1937 world) {
        super((class_1299<? extends EntitySanoUno>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack);
        }
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEFEAT;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (command == 2) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.ICE_BALL_DROP.get()))) {
                    this.getAnimationHandler().setAnimation(ICEBALLS_5);
                }
            } else if (command == 1) {
                if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.PARALLEL_LASER.get()))) {
                    this.getAnimationHandler().setAnimation(WATER_LASER_2);
                }
            } else if (this.getProp().rideActionCosts.canRun(command, this.method_5642(), (Spell)((Object)ModSpells.WATER_LASER.get()))) {
                this.getAnimationHandler().setAnimation(WATER_LASER);
            }
        }
    }

    public AnimationHandler<EntityUno> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public EntitySano getLinked() {
        List results;
        if (this.other != null && !this.other.method_31481()) {
            return this.other;
        }
        if (this.getLinkedID() != null && !(results = this.field_6002.method_18023(class_5575.method_31795(EntitySano.class), this.method_5829().method_1014(64.0), e -> this.getLinkedID().equals(e.getLinkedID()))).isEmpty()) {
            this.other = (EntitySano)results.get(0);
        }
        return this.other;
    }
}

