/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia;

import com.google.common.collect.ImmutableMap;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BossMonster;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesiaFlower;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesiaHorseTail;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesiaPart;
import io.github.flemmli97.runecraftory.common.entities.monster.boss.rafflesia.EntityRafflesiaPitcher;
import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.entities.utils.RunecraftoryBossbar;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.runecraftory.common.registry.ModSpells;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.EntityUtil;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_11;
import net.minecraft.class_1259;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3730;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5575;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public class EntityRafflesia
extends BossMonster {
    private static final class_2940<Optional<UUID>> HORSE_TAIL = class_2945.method_12791(EntityRafflesia.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> FLOWER = class_2945.method_12791(EntityRafflesia.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Optional<UUID>> PITCHER = class_2945.method_12791(EntityRafflesia.class, (class_2941)class_2943.field_13313);
    private static final class_2940<class_2350> SPAWN_DIRECTION = class_2945.method_12791(EntityRafflesia.class, (class_2941)class_2943.field_13321);
    public static final AnimatedAction POISON_BREATH = AnimatedAction.builder((double)1.96, (String)"breath").marker("attack", new double[]{0.56}).build();
    public static final AnimatedAction POISON_BREATH_REV = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"breath_2");
    public static final AnimatedAction PARA_BREATH = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"paralysis_breath");
    public static final AnimatedAction PARA_BREATH_REV = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"paralysis_breath_2");
    public static final AnimatedAction SLEEP_BREATH = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"sleep_breath");
    public static final AnimatedAction SLEEP_BREATH_REV = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"sleep_breath_2");
    public static final AnimatedAction WIND_BLADE_X8 = AnimatedAction.builder((double)0.88, (String)"casting").marker("attack", new double[]{0.44}).build();
    public static final AnimatedAction WIND_BLADE_X16 = AnimatedAction.copyOf((AnimatedAction)WIND_BLADE_X8, (String)"wind_blade_x16");
    public static final AnimatedAction RESUMMON = AnimatedAction.copyOf((AnimatedAction)WIND_BLADE_X8, (String)"resummon");
    public static final AnimatedAction STATUS_CIRCLE = AnimatedAction.copyOf((AnimatedAction)WIND_BLADE_X8, (String)"status_circle");
    public static final AnimatedAction DEATH = AnimatedAction.builder((double)10.0, (String)"death").infinite().build();
    public static final AnimatedAction ANGRY = AnimatedAction.copyOf((AnimatedAction)WIND_BLADE_X8, (String)"roar");
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)POISON_BREATH, (String)"interact");
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{POISON_BREATH, POISON_BREATH_REV, PARA_BREATH, PARA_BREATH_REV, SLEEP_BREATH, SLEEP_BREATH_REV, WIND_BLADE_X8, WIND_BLADE_X16, RESUMMON, STATUS_CIRCLE, DEATH, ANGRY, INTERACT};
    private static final ImmutableMap<String, BiConsumer<AnimatedAction, EntityRafflesia>> ATTACK_HANDLER = EntityRafflesia.createAnimationHandler(b -> {
        BiConsumer<AnimatedAction, EntityRafflesia> cons = (anim, entity) -> {
            if (anim.isAt("attack")) {
                entity.useAttack((AnimatedAction)anim);
            }
        };
        b.put((Object)POISON_BREATH, cons);
        b.put((Object)PARA_BREATH, cons);
        b.put((Object)SLEEP_BREATH, cons);
        b.put((Object)POISON_BREATH_REV, cons);
        b.put((Object)PARA_BREATH_REV, cons);
        b.put((Object)SLEEP_BREATH_REV, cons);
        b.put((Object)WIND_BLADE_X8, cons);
        b.put((Object)WIND_BLADE_X16, cons);
        b.put((Object)RESUMMON, cons);
        b.put((Object)STATUS_CIRCLE, cons);
    });
    private static final List<class_6008.class_6010<GoalAttackAction<EntityRafflesia>>> ATTACKS = List.of(class_6008.method_34980((Object)new GoalAttackAction(POISON_BREATH).cooldown(e -> e.animationCooldown(POISON_BREATH)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), class_6008.method_34980((Object)new GoalAttackAction(POISON_BREATH_REV).cooldown(e -> e.animationCooldown(POISON_BREATH_REV)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), class_6008.method_34980((Object)new GoalAttackAction(PARA_BREATH).cooldown(e -> e.animationCooldown(PARA_BREATH)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), class_6008.method_34980((Object)new GoalAttackAction(PARA_BREATH_REV).cooldown(e -> e.animationCooldown(PARA_BREATH_REV)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), class_6008.method_34980((Object)new GoalAttackAction(SLEEP_BREATH).cooldown(e -> e.animationCooldown(SLEEP_BREATH)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), class_6008.method_34980((Object)new GoalAttackAction(SLEEP_BREATH_REV).cooldown(e -> e.animationCooldown(SLEEP_BREATH_REV)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6), class_6008.method_34980((Object)new GoalAttackAction(WIND_BLADE_X8).cooldown(e -> e.animationCooldown(WIND_BLADE_X8)).withCondition((goal, target, previous) -> !((EntityRafflesia)goal.attacker).isEnraged()).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), class_6008.method_34980((Object)new GoalAttackAction(WIND_BLADE_X16).cooldown(e -> e.animationCooldown(WIND_BLADE_X16)).withCondition((goal, target, previous) -> ((EntityRafflesia)goal.attacker).isEnraged()).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), class_6008.method_34980((Object)new GoalAttackAction(STATUS_CIRCLE).cooldown(e -> e.animationCooldown(STATUS_CIRCLE)).withCondition((goal, target, previous) -> ((EntityRafflesia)goal.attacker).isEnraged()).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)8), class_6008.method_34980((Object)new GoalAttackAction(RESUMMON).cooldown(e -> e.animationCooldown(RESUMMON)).withCondition((goal, target, previous) -> ((EntityRafflesia)goal.attacker).getHorseTail() == null || ((EntityRafflesia)goal.attacker).getPitcher() == null || ((EntityRafflesia)goal.attacker).getFlower() == null).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)7));
    private static final List<class_6008.class_6010<IdleAction<EntityRafflesia>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(DoNothingRunner::new), (int)1));
    public final AnimatedAttackGoal<EntityRafflesia> attack2 = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private boolean mirrorAttack;
    private final AnimationHandler<EntityRafflesia> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (!this.field_6002.field_9236) {
            this.mirrorAttack = EntityRafflesia.isMirrorAttack(anim);
        }
        return false;
    });
    private EntityRafflesiaPart horseTailEntity;
    private EntityRafflesiaPart flowerEntity;
    private EntityRafflesiaPart pitcherEntity;
    private int summonCooldown = 100;

    public EntityRafflesia(class_1299<? extends EntityRafflesia> type, class_1937 world) {
        super((class_1299<? extends BossMonster>)type, world);
        if (!world.field_9236) {
            this.field_6201.method_6277(1, this.attack2);
        }
    }

    public static class_243 rotateVec(class_2350 dir, class_243 v) {
        return switch (dir) {
            case class_2350.field_11043 -> v.method_18805(-1.0, 1.0, -1.0);
            case class_2350.field_11034 -> new class_243(v.method_10215(), v.method_10214(), -v.method_10216());
            case class_2350.field_11039 -> new class_243(-v.method_10215(), v.method_10214(), -v.method_10216());
            default -> v;
        };
    }

    public static boolean isMirrorAttack(AnimatedAction anim) {
        return anim != null && anim.is(new AnimatedAction[]{POISON_BREATH_REV, PARA_BREATH_REV, SLEEP_BREATH_REV});
    }

    @Override
    public RunecraftoryBossbar createBossBar() {
        return new RunecraftoryBossbar(null, this.method_5476(), class_1259.class_1260.field_5784, class_1259.class_1261.field_5795).setMusic((class_3414)ModSounds.RAFFLESIA_FIGHT.get());
    }

    protected class_1408 method_5965(class_1937 level) {
        return new class_1409((class_1308)this, level){

            @Nullable
            protected class_11 method_18416(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy, float followRange) {
                return null;
            }
        };
    }

    public void useAttack(AnimatedAction anim) {
        if (anim.is(new AnimatedAction[]{RESUMMON})) {
            this.respawnParts();
        }
        if (anim.is(new AnimatedAction[]{WIND_BLADE_X8})) {
            ((Spell)((Object)ModSpells.WIND_CIRCLE_X8.get())).use((class_1309)this);
        }
        if (anim.is(new AnimatedAction[]{WIND_BLADE_X16})) {
            ((Spell)((Object)ModSpells.WIND_CIRCLE_X16.get())).use((class_1309)this);
        }
        if (anim.is(new AnimatedAction[]{POISON_BREATH, POISON_BREATH_REV})) {
            ((Spell)((Object)ModSpells.RAFFLESIA_POISON.get())).use((class_1309)this);
        }
        if (anim.is(new AnimatedAction[]{PARA_BREATH, PARA_BREATH_REV})) {
            ((Spell)((Object)ModSpells.RAFFLESIA_PARA.get())).use((class_1309)this);
        }
        if (anim.is(new AnimatedAction[]{SLEEP_BREATH, SLEEP_BREATH_REV})) {
            ((Spell)((Object)ModSpells.RAFFLESIA_SLEEP.get())).use((class_1309)this);
        }
        if (anim.is(new AnimatedAction[]{STATUS_CIRCLE})) {
            ((Spell)((Object)ModSpells.RAFFLESIA_CIRCLE.get())).use((class_1309)this);
        }
    }

    @Override
    protected void applyAttributes() {
        this.method_5996(class_5134.field_23719).method_6192(0.0);
        super.applyAttributes();
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HORSE_TAIL, Optional.empty());
        this.field_6011.method_12784(FLOWER, Optional.empty());
        this.field_6011.method_12784(PITCHER, Optional.empty());
        this.field_6011.method_12784(SPAWN_DIRECTION, (Object)class_2350.field_11043);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        ((Optional)this.field_6011.method_12789(HORSE_TAIL)).ifPresent(uuid -> compound.method_25927("HeadBones", uuid));
        ((Optional)this.field_6011.method_12789(FLOWER)).ifPresent(uuid -> compound.method_25927("Flower", uuid));
        ((Optional)this.field_6011.method_12789(PITCHER)).ifPresent(uuid -> compound.method_25927("Pitcher", uuid));
        compound.method_10569("SpawnDirection", ((class_2350)this.field_6011.method_12789(SPAWN_DIRECTION)).ordinal());
        compound.method_10569("SummonCooldown", this.summonCooldown);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_25928("HorseTail")) {
            this.field_6011.method_12778(HORSE_TAIL, Optional.of(compound.method_25926("HorseTail")));
        }
        if (compound.method_25928("Flower")) {
            this.field_6011.method_12778(FLOWER, Optional.of(compound.method_25926("Flower")));
        }
        if (compound.method_25928("Pitcher")) {
            this.field_6011.method_12778(PITCHER, Optional.of(compound.method_25926("Pitcher")));
        }
        try {
            this.field_6011.method_12778(SPAWN_DIRECTION, (Object)class_2350.values()[compound.method_10550("SpawnDirection")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        this.summonCooldown = compound.method_10550("SummonCooldown");
    }

    @Override
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        this.field_6011.method_12778(SPAWN_DIRECTION, (Object)this.method_5735());
        this.respawnParts();
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    @Override
    public void method_5670() {
        super.method_5670();
        if (!this.field_6002.field_9236) {
            class_1309 target = this.method_5968();
            if (target != null && !this.getAnimationHandler().hasAnimation()) {
                this.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
            }
            if (this.summonCooldown < 200 && this.getHorseTail() == null || this.getPitcher() == null || this.getFlower() == null) {
                this.summonCooldown = this.field_5974.nextInt(200) + 300;
            }
            if (this.field_6012 % 30 == 0) {
                this.field_6002.method_18023(class_5575.method_31795(class_1309.class), this.method_5829().method_1014(0.3).method_989(0.0, (double)this.method_17682(), 0.0), e -> e != this && this.targetPred.test(e)).forEach(e -> {
                    class_243 dir = e.method_19538().method_1020(this.method_19538());
                    boolean none = dir.method_10216() == 0.0 && dir.method_10215() == 0.0;
                    dir = new class_243(none ? 1.0 : dir.method_10216(), 0.0, dir.method_10215()).method_1029().method_1021(1.2);
                    e.method_18799(e.method_18798().method_1019(dir));
                    e.field_6037 = true;
                });
            }
        }
    }

    @Override
    public void setupAttack(AnimatedAction anim) {
        class_1309 target = this.method_5968();
        if (target != null) {
            this.setTargetPosition(target);
        } else {
            this.setTargetPosition(MobAttackExt.TargetPosition.of(this.method_19538().method_1019(this.method_5720().method_1021(5.0))));
        }
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        BiConsumer handler = (BiConsumer)ATTACK_HANDLER.get((Object)anim.getID());
        if (handler != null) {
            handler.accept(anim, this);
        }
    }

    public class_2350 getSpawnDirection() {
        return (class_2350)this.field_6011.method_12789(SPAWN_DIRECTION);
    }

    private void respawnParts() {
        class_2350 dir = (class_2350)this.field_6011.method_12789(SPAWN_DIRECTION);
        if (this.getHorseTail() == null) {
            EntityRafflesiaHorseTail horseTail = new EntityRafflesiaHorseTail(this.field_6002, this);
            horseTail.setSpawnDirection(dir);
            horseTail.method_33574(this.method_19538().method_1019(EntityRafflesia.rotateVec(dir, horseTail.offset())));
            this.field_6002.method_8649((class_1297)horseTail);
            this.field_6011.method_12778(HORSE_TAIL, Optional.of(horseTail.method_5667()));
        }
        if (this.getFlower() == null) {
            EntityRafflesiaFlower flower = new EntityRafflesiaFlower(this.field_6002, this);
            flower.setSpawnDirection(dir);
            flower.method_33574(this.method_19538().method_1019(EntityRafflesia.rotateVec(dir, flower.offset())));
            this.field_6002.method_8649((class_1297)flower);
            this.field_6011.method_12778(FLOWER, Optional.of(flower.method_5667()));
        }
        if (this.getPitcher() == null) {
            EntityRafflesiaPitcher pitcher = new EntityRafflesiaPitcher(this.field_6002, this);
            pitcher.setSpawnDirection(dir);
            pitcher.method_33574(this.method_19538().method_1019(EntityRafflesia.rotateVec(dir, pitcher.offset())));
            this.field_6002.method_8649((class_1297)pitcher);
            this.field_6011.method_12778(PITCHER, Optional.of(pitcher.method_5667()));
        }
        this.summonCooldown = this.field_5974.nextInt(200) + 300;
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        return !this.getAnimationHandler().isCurrent(new AnimatedAction[]{ANGRY}) && super.method_5643(source, amount);
    }

    @Override
    public AnimatedAction getDeathAnimation() {
        return DEATH;
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), command == 1 ? (Spell)((Object)ModSpells.RAFFLESIA_POISON.get()) : (Spell)((Object)ModSpells.RAFFLESIA_PARA.get()))) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(POISON_BREATH);
            } else {
                this.getAnimationHandler().setAnimation(PARA_BREATH);
            }
        }
    }

    @Override
    public void setEnraged(boolean flag, boolean load) {
        super.setEnraged(flag, load);
        if (flag && !load) {
            this.getAnimationHandler().setAnimation(ANGRY);
        }
    }

    protected void method_5712(class_2338 pos, class_2680 blockIn) {
    }

    public boolean method_30948() {
        return true;
    }

    public AnimationHandler<EntityRafflesia> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return DEATH;
    }

    public EntityRafflesiaPart getHorseTail() {
        UUID uuid = ((Optional)this.field_6011.method_12789(HORSE_TAIL)).orElse(null);
        if (uuid != null) {
            if (this.horseTailEntity == null) {
                this.horseTailEntity = (EntityRafflesiaPart)EntityUtil.findFromUUID(EntityRafflesiaPart.class, (class_1937)this.field_6002, (UUID)uuid);
            } else if (this.horseTailEntity.method_31481()) {
                this.horseTailEntity = null;
                this.field_6011.method_12778(HORSE_TAIL, Optional.empty());
            }
        } else {
            this.horseTailEntity = null;
        }
        return this.horseTailEntity;
    }

    public EntityRafflesiaPart getFlower() {
        UUID uuid = ((Optional)this.field_6011.method_12789(FLOWER)).orElse(null);
        if (uuid != null) {
            if (this.flowerEntity == null) {
                this.flowerEntity = (EntityRafflesiaPart)EntityUtil.findFromUUID(EntityRafflesiaPart.class, (class_1937)this.field_6002, (UUID)uuid);
            } else if (this.flowerEntity.method_31481()) {
                this.flowerEntity = null;
                this.field_6011.method_12778(FLOWER, Optional.empty());
            }
        } else {
            this.flowerEntity = null;
        }
        return this.flowerEntity;
    }

    public EntityRafflesiaPart getPitcher() {
        UUID uuid = ((Optional)this.field_6011.method_12789(PITCHER)).orElse(null);
        if (uuid != null) {
            if (this.pitcherEntity == null) {
                this.pitcherEntity = (EntityRafflesiaPart)EntityUtil.findFromUUID(EntityRafflesiaPart.class, (class_1937)this.field_6002, (UUID)uuid);
            } else if (this.pitcherEntity.method_31481()) {
                this.pitcherEntity = null;
                this.field_6011.method_12778(PITCHER, Optional.empty());
            }
        } else {
            this.pitcherEntity = null;
        }
        return this.pitcherEntity;
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)ModSounds.ENTITY_RAFFLESIA_DEATH.get();
    }

    @Override
    public void playAngrySound() {
        this.method_5783((class_3414)ModSounds.ENTITY_RAFFLESIA_ANGRY.get(), 1.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
    }

    public boolean mirrorAttack() {
        return this.mirrorAttack;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 2.6875, 0.21875);
    }
}

