/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.monster.wisp;

import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.entities.BaseMonster;
import io.github.flemmli97.runecraftory.common.entities.ai.NearestTargetNoLoS;
import io.github.flemmli97.runecraftory.common.entities.ai.animated.MonsterActionUtils;
import io.github.flemmli97.runecraftory.common.entities.ai.control.FreeMoveControl;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.FloatingFlyNavigator;
import io.github.flemmli97.runecraftory.common.entities.ai.pathing.NoClipFlyEvaluator;
import io.github.flemmli97.runecraftory.common.registry.ModSounds;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.ActionRun;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.AnimatedAttackGoal;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.GoalAttackAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.IdleAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.DoNothingRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.RandomMoveAroundRunner;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.StayWithinHeightAction;
import io.github.flemmli97.tenshilib.common.entity.ai.animated.impl.WrappedRunner;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_5134;
import net.minecraft.class_6008;
import org.jetbrains.annotations.Nullable;

public abstract class EntityWispBase
extends BaseMonster {
    public static final AnimatedAction ATTACK_FAR = AnimatedAction.builder((double)0.48, (String)"attack").marker("attack", new double[]{0.36}).build();
    public static final AnimatedAction ATTACK_CLOSE = AnimatedAction.copyOf((AnimatedAction)ATTACK_FAR, (String)"attack_close");
    public static final AnimatedAction INTERACT = AnimatedAction.copyOf((AnimatedAction)ATTACK_FAR, (String)"interact");
    public static final AnimatedAction VANISH = AnimatedAction.builder((double)5.0, (String)"vanish").marker("teleport", new double[]{2.5}).marker("teleport_done", new double[]{2.6}).build();
    public static final AnimatedAction STILL = AnimatedAction.builder((double)0.0, (String)"still").infinite().build();
    private static final AnimatedAction[] ANIMS = new AnimatedAction[]{ATTACK_FAR, ATTACK_CLOSE, INTERACT, VANISH, STILL};
    private static final List<class_6008.class_6010<GoalAttackAction<EntityWispBase>>> ATTACKS = List.of(class_6008.method_34980(MonsterActionUtils.simpleRangedEvadingAction(ATTACK_FAR, 7.0, 3.0, 1.0, e -> 1.0f), (int)2), class_6008.method_34980((Object)new GoalAttackAction(ATTACK_CLOSE).cooldown(e -> e.animationCooldown(ATTACK_CLOSE)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)1), class_6008.method_34980((Object)new GoalAttackAction(VANISH).withCondition((goal, target, previous) -> ((EntityWispBase)goal.attacker).shouldVanishNext(previous)).prepare(() -> new WrappedRunner((ActionRun)new DoNothingRunner(true))), (int)6));
    private static final List<class_6008.class_6010<IdleAction<EntityWispBase>>> IDLE_ACTIONS = List.of(class_6008.method_34980((Object)new IdleAction(() -> new StayWithinHeightAction(Double.valueOf(2.0), (ActionRun)new RandomMoveAroundRunner(7.0, 4))), (int)1), class_6008.method_34980((Object)new IdleAction(() -> new StayWithinHeightAction(Double.valueOf(2.0), (ActionRun)new DoNothingRunner())), (int)3));
    public final AnimatedAttackGoal<EntityWispBase> attack = new AnimatedAttackGoal((class_1314)this, ATTACKS, IDLE_ACTIONS);
    private boolean vanishNext;
    private final AnimationHandler<EntityWispBase> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (anim != null && anim.is(new AnimatedAction[]{VANISH})) {
            this.vanishNext = (double)this.method_6051().nextFloat() < 0.6;
        }
        return false;
    });

    public EntityWispBase(class_1299<? extends EntityWispBase> type, class_1937 world) {
        super(type, world);
        this.field_6201.method_6277(2, this.attack);
        this.field_6201.method_6280((class_1352)this.swimGoal);
        this.method_5875(true);
        this.field_5960 = true;
        this.field_6207 = new FreeMoveControl((class_1308)this);
    }

    protected class_1408 method_5965(class_1937 level) {
        return new FloatingFlyNavigator((class_1308)this, level){

            @Override
            protected class_13 method_6336(int maxDist) {
                this.field_6678 = new NoClipFlyEvaluator();
                return new class_13(this.field_6678, maxDist);
            }
        };
    }

    @Override
    protected void applyAttributes() {
        super.applyAttributes();
        this.method_5996(class_5134.field_23717).method_6192(32.0);
        this.method_5996(class_5134.field_23720).method_6192(0.2);
        this.method_5996(class_5134.field_23718).method_6192(1.0);
    }

    @Override
    protected class_1400<class_1657> createTargetGoalPlayer() {
        return new NearestTargetNoLoS<class_1657>((class_1308)this, class_1657.class, 5, false, player -> !this.isTamed());
    }

    @Override
    protected class_1400<class_1308> createTargetGoalMobs() {
        return new NearestTargetNoLoS<class_1308>((class_1308)this, class_1308.class, 5, false, this.targetPred);
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.getAnimationHandler().isCurrent(new AnimatedAction[]{VANISH})) {
            return false;
        }
        boolean ret = super.method_5643(source, amount);
        if (ret) {
            this.vanishNext = (double)this.method_6051().nextFloat() < 0.4;
        }
        return ret;
    }

    @Override
    public void handleAttack(AnimatedAction anim) {
        class_1309 target = this.method_5968();
        if (anim.is(new AnimatedAction[]{ATTACK_FAR})) {
            this.method_5942().method_6340();
            if (target != null) {
                this.method_5988().method_6226((class_1297)target, 360.0f, 90.0f);
            }
            if (anim.isAt("attack")) {
                this.attackFar(target);
            }
        } else if (anim.is(new AnimatedAction[]{ATTACK_CLOSE})) {
            this.method_5942().method_6340();
            if (target != null) {
                this.method_5988().method_6226((class_1297)target, 360.0f, 90.0f);
            }
            if (anim.isAt("attack")) {
                this.attackClose(target);
            }
        } else if (anim.is(new AnimatedAction[]{VANISH})) {
            this.method_5942().method_6340();
            if (anim.isAt("teleport")) {
                if (target == null) {
                    double rX = this.method_23317() + (this.field_5974.nextDouble() - 0.5) * 16.0;
                    double rY = this.method_23318() + (this.field_5974.nextDouble() - 0.5) * 4.0;
                    double rZ = this.method_23321() + (this.field_5974.nextDouble() - 0.5) * 16.0;
                    this.teleport(rX, rY, rZ);
                } else {
                    this.teleportTowards((class_1297)target);
                }
            }
        }
    }

    @Override
    public void handleRidingCommand(int command) {
        if (!this.getAnimationHandler().hasAnimation()) {
            if (!this.getProp().rideActionCosts.canRun(command, this.method_5642(), this.getSpellFor(command))) {
                return;
            }
            if (command == 1) {
                this.getAnimationHandler().setAnimation(ATTACK_CLOSE);
            } else {
                this.getAnimationHandler().setAnimation(ATTACK_FAR);
            }
        }
    }

    protected abstract Spell getSpellFor(int var1);

    protected class_3414 method_5994() {
        return (class_3414)ModSounds.ENTITY_WISP_AMBIENT.get();
    }

    @Override
    public int animationCooldown(@Nullable AnimatedAction anim) {
        int diffAdd = this.difficultyCooldown();
        if (anim == null) {
            return this.method_6051().nextInt(20) + 30 + diffAdd;
        }
        return this.method_6051().nextInt(40) + 25 + diffAdd;
    }

    public AnimationHandler<EntityWispBase> getAnimationHandler() {
        return this.animationHandler;
    }

    @Override
    public void method_6091(class_243 vec) {
        class_1297 class_12972 = this.method_31483();
        if (class_12972 instanceof class_1309) {
            class_1309 entity = (class_1309)class_12972;
            this.field_5960 = entity.field_5960;
        } else {
            boolean bl = this.field_5960 = !this.playDeath();
            if (this.method_23318() < (double)(this.field_6002.method_31607() + 1)) {
                vec = new class_243(vec.field_1352, 0.006, vec.field_1350);
            }
        }
        this.handleFreeTravel(vec);
    }

    private void teleportTowards(class_1297 entity) {
        class_243 look = new class_243(entity.method_5720().field_1352, 0.0, entity.method_5720().field_1350).method_1029().method_1021(-2.5);
        class_243 behindEntity = entity.method_19538().method_1019(look);
        class_243 dir = new class_243(behindEntity.field_1352 - this.method_23317(), behindEntity.field_1351 - this.method_23318(), behindEntity.field_1350 - this.method_23321());
        if (dir.method_1027() < 100.0) {
            this.teleport(behindEntity.field_1352, entity.method_23318(), behindEntity.field_1350);
        } else {
            dir = dir.method_1029();
            double e = this.method_23317() + this.field_5974.nextDouble() * 9.0 * dir.field_1352;
            double g = this.method_23321() + this.field_5974.nextDouble() * 9.0 * dir.field_1350;
            this.teleport(e, entity.method_23318(), g);
        }
    }

    private void teleport(double x, double y, double z) {
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339(x, y, z);
        while (mutableBlockPos.method_10264() > this.field_6002.method_31607() && !this.field_6002.method_8320((class_2338)mutableBlockPos).method_26207().method_15801()) {
            mutableBlockPos.method_10098(class_2350.field_11033);
        }
        class_2680 blockState = this.field_6002.method_8320((class_2338)mutableBlockPos);
        if (!blockState.method_26207().method_15801()) {
            y = this.method_23318();
        }
        this.method_5859(x, y + 1.0, z);
    }

    public abstract void attackFar(class_1309 var1);

    public abstract void attackClose(class_1309 var1);

    public boolean shouldVanishNext(String prev) {
        class_1309 target = this.method_5968();
        if (target != null && target.method_5858((class_1297)this) > 140.0) {
            return true;
        }
        return !prev.equals(VANISH.getID()) && this.vanishNext;
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    @Override
    public void playInteractionAnimation() {
        this.getAnimationHandler().setAnimation(INTERACT);
    }

    @Override
    public AnimatedAction getSleepAnimation() {
        return STILL;
    }

    @Override
    public class_243 passengerOffset(class_1297 passenger) {
        return new class_243(0.0, 0.625, -0.1875);
    }
}

