/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.runecraftory.RuneCraftory;
import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.PlayerModelAnimations;
import io.github.flemmli97.runecraftory.api.datapack.ConversationContext;
import io.github.flemmli97.runecraftory.api.datapack.FoodProperties;
import io.github.flemmli97.runecraftory.api.datapack.SimpleEffect;
import io.github.flemmli97.runecraftory.api.datapack.npc.ConversationSet;
import io.github.flemmli97.runecraftory.api.datapack.npc.GiftData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCData;
import io.github.flemmli97.runecraftory.api.datapack.npc.NPCLook;
import io.github.flemmli97.runecraftory.api.enums.EnumSeason;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.attachment.player.LevelExpPair;
import io.github.flemmli97.runecraftory.common.config.MobConfig;
import io.github.flemmli97.runecraftory.common.datapack.DataPackHandler;
import io.github.flemmli97.runecraftory.common.datapack.manager.npc.NPCDataManager;
import io.github.flemmli97.runecraftory.common.entities.ai.AvoidWhenNotFollowing;
import io.github.flemmli97.runecraftory.common.entities.ai.LookAtAliveGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.LookAtInteractingPlayerGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.RandomLookGoalAlive;
import io.github.flemmli97.runecraftory.common.entities.ai.StayGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCAttackGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCFindPOI;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCFollowGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.NPCWanderGoal;
import io.github.flemmli97.runecraftory.common.entities.ai.npc.actions.NPCAttackActions;
import io.github.flemmli97.runecraftory.common.entities.npc.DailyNPCUpdater;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityWeaponHandler;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCFriendPoints;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCRelationManager;
import io.github.flemmli97.runecraftory.common.entities.npc.NPCSchedule;
import io.github.flemmli97.runecraftory.common.entities.npc.PlaceHolderComponent;
import io.github.flemmli97.runecraftory.common.entities.npc.QuestConversationContext;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.entities.npc.features.SizeFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.job.NPCJob;
import io.github.flemmli97.runecraftory.common.entities.npc.job.ShopState;
import io.github.flemmli97.runecraftory.common.entities.pathing.NPCWalkNodeEvaluator;
import io.github.flemmli97.runecraftory.common.entities.utils.IBaseMob;
import io.github.flemmli97.runecraftory.common.entities.utils.MobAttackExt;
import io.github.flemmli97.runecraftory.common.entities.utils.TargetableOpponent;
import io.github.flemmli97.runecraftory.common.inventory.InventoryShop;
import io.github.flemmli97.runecraftory.common.inventory.container.ContainerShop;
import io.github.flemmli97.runecraftory.common.items.BabySpawnEgg;
import io.github.flemmli97.runecraftory.common.items.consumables.ItemObjectX;
import io.github.flemmli97.runecraftory.common.lib.LibConstants;
import io.github.flemmli97.runecraftory.common.loot.LootCtxParameters;
import io.github.flemmli97.runecraftory.common.network.S2CEntityLevelPkt;
import io.github.flemmli97.runecraftory.common.network.S2CNPCLook;
import io.github.flemmli97.runecraftory.common.network.S2CNpcDialogue;
import io.github.flemmli97.runecraftory.common.network.S2COpenNPCGui;
import io.github.flemmli97.runecraftory.common.network.S2CUpdateNPCData;
import io.github.flemmli97.runecraftory.common.quests.NPCQuest;
import io.github.flemmli97.runecraftory.common.quests.QuestHandler;
import io.github.flemmli97.runecraftory.common.quests.progress.NPCTalkTracker;
import io.github.flemmli97.runecraftory.common.registry.ModActivities;
import io.github.flemmli97.runecraftory.common.registry.ModAttributes;
import io.github.flemmli97.runecraftory.common.registry.ModEntities;
import io.github.flemmli97.runecraftory.common.registry.ModItems;
import io.github.flemmli97.runecraftory.common.registry.ModNPCJobs;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import io.github.flemmli97.runecraftory.common.utils.CombatUtils;
import io.github.flemmli97.runecraftory.common.utils.CustomDamage;
import io.github.flemmli97.runecraftory.common.utils.EntityUtils;
import io.github.flemmli97.runecraftory.common.utils.ItemNBT;
import io.github.flemmli97.runecraftory.common.utils.ItemUtils;
import io.github.flemmli97.runecraftory.common.utils.LevelCalc;
import io.github.flemmli97.runecraftory.common.utils.TeleportUtils;
import io.github.flemmli97.runecraftory.common.utils.WorldUtils;
import io.github.flemmli97.runecraftory.common.world.NPCHandler;
import io.github.flemmli97.runecraftory.common.world.WorldHandler;
import io.github.flemmli97.runecraftory.common.world.family.FamilyEntry;
import io.github.flemmli97.runecraftory.common.world.family.FamilyHandler;
import io.github.flemmli97.runecraftory.mixin.AttributeMapAccessor;
import io.github.flemmli97.runecraftory.platform.Platform;
import io.github.flemmli97.simplequests_api.quest.QuestState;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.AnimationHandler;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import io.github.flemmli97.tenshilib.api.item.IAOEWeapon;
import io.github.flemmli97.tenshilib.api.item.IExtendedWeapon;
import io.github.flemmli97.tenshilib.common.item.SpawnEgg;
import io.github.flemmli97.tenshilib.common.utils.OrientedBoundingBox;
import io.github.flemmli97.tenshilib.common.utils.RayTraceUtils;
import io.github.flemmli97.tenshilib.platform.registry.RegistryEntrySupplier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_11;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1285;
import net.minecraft.class_1291;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_13;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_156;
import net.minecraft.class_1569;
import net.minecraft.class_1588;
import net.minecraft.class_1655;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1829;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2767;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4153;
import net.minecraft.class_4168;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_4255;
import net.minecraft.class_47;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5569;
import net.minecraft.class_5575;
import net.minecraft.class_6025;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class EntityNPCBase
extends class_1296
implements class_1655,
IBaseMob,
IAnimated,
TargetableOpponent,
MobAttackExt {
    public static final float PATH_FIND_LENGTH = 100.0f;
    private static final class_2940<Boolean> PLAY_DEATH_STATE = class_2945.method_12791(EntityNPCBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SHOP_SYNC = class_2945.method_12791(EntityNPCBase.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> MALE = class_2945.method_12791(EntityNPCBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> BEHAVIOUR_DATA = class_2945.method_12791(EntityNPCBase.class, (class_2941)class_2943.field_13327);
    private static final ImmutableList<class_4140<?>> MEMORY_TYPES = ImmutableList.of((Object)class_4140.field_18438, (Object)class_4140.field_18439, (Object)class_4140.field_18440, (Object)class_4140.field_26389, (Object)class_4140.field_19008, (Object)class_4140.field_18445, (Object)class_4140.field_19293);
    public static final AnimatedAction[] ANIMS = PlayerModelAnimations.getAll().toArray(new AnimatedAction[0]);
    private final AnimationHandler<EntityNPCBase> animationHandler = new AnimationHandler((class_1297)this, ANIMS).withChangeListener(anim -> {
        if (this.method_5968() != null) {
            this.method_5951((class_1297)this.method_5968(), 360.0f, 90.0f);
            this.targetPosition = MobAttackExt.TargetPosition.of(this.method_5968());
        }
        return false;
    });
    public final Predicate<class_1309> targetPred = e -> {
        if (e != this) {
            class_6025 ownable;
            if (this.followEntity() == null) {
                return false;
            }
            if (e instanceof class_6025 && (ownable = (class_6025)e).method_6139() != null) {
                return false;
            }
            if (e instanceof class_1308 && this == ((class_1308)e).method_5968()) {
                return true;
            }
            return e instanceof class_1569;
        }
        return false;
    };
    public final Predicate<class_1309> hitPred = e -> {
        if (e != this) {
            class_1308 mob;
            if (e == this.method_5968() || e instanceof class_1308 && this == (mob = (class_1308)e).method_5968()) {
                return true;
            }
            if (this.method_5626((class_1297)e) || !e.method_33190()) {
                return false;
            }
            class_1657 follow = this.followEntity();
            if (follow != null && e instanceof class_6025) {
                class_6025 ownable = (class_6025)e;
                if (follow.method_5667().equals(ownable.method_6139())) {
                    return false;
                }
            }
            return e instanceof class_1569;
        }
        return false;
    };
    public class_1400<class_1308> targetMobs = new class_1400((class_1308)this, class_1308.class, 5, true, true, this.targetPred);
    public NPCWanderGoal wander = new NPCWanderGoal(this);
    public class_1399 hurt = new class_1399((class_1314)this, new Class[0]);
    private final LevelExpPair levelPair = new LevelExpPair();
    private NPCJob shop = (NPCJob)ModNPCJobs.NONE.getSecond();
    public boolean ignoreInit;
    private NPCData data = NPCData.DEFAULT_DATA;
    private NPCLook look = NPCLook.DEFAULT_LOOK;
    public final NPCFeatureContainer lookFeatures = new NPCFeatureContainer();
    private NPCAttackActions attackActions = NPCAttackActions.DEFAULT;
    private Pair<EnumSeason, Integer> birthday = Pair.of((Object)((Object)EnumSeason.SPRING), (Object)1);
    private Map<String, GiftData> gifts;
    private final Random dataRandom = new Random();
    private class_4168 activity = class_4168.field_18595;
    private int foodBuffTick;
    private int playDeathTick;
    private final NPCRelationManager relationManager = new NPCRelationManager();
    private int procreationCooldown;
    private int procreationProgress;
    private class_1297 procreationEntity;
    private Behaviour behaviour = Behaviour.WANDER;
    private class_1657 entityToFollow;
    private UUID entityToFollowUUID;
    private int sleepCooldown;
    private int tpCooldown;
    private final List<class_3222> interactingPlayers = new ArrayList<class_3222>();
    private int interactionMoveCooldown;
    private final NPCSchedule schedule;
    private class_2338 prevRestriction = class_2338.field_10980;
    private int prevRestrictionRadius = -1;
    public final DailyNPCUpdater updater = new DailyNPCUpdater(this);
    public final AttackActionHandler weaponHandler = new EntityWeaponHandler<EntityNPCBase>(this);
    private MobAttackExt.TargetPosition targetPosition;

    public EntityNPCBase(class_1299<? extends EntityNPCBase> type, class_1937 level) {
        super(type, level);
        this.levelPair.setLevel(1, LevelCalc::xpAmountForLevelUp);
        this.applyAttributes(true);
        if (!level.field_9236) {
            this.addGoal();
        }
        this.schedule = new NPCSchedule(this, this.method_6051());
    }

    public static class_5132.class_5133 createAttributes() {
        class_5132.class_5133 map = class_1588.method_26918().method_26868(class_5134.field_23719, 0.24).method_26868(class_5134.field_23717, 32.0);
        for (RegistryEntrySupplier<class_1320> att : ModAttributes.ENTITY_ATTRIBUTES) {
            map.method_26867((class_1320)att.get());
        }
        for (RegistryEntrySupplier<class_1320> att : ModAttributes.PLAYER_ATTRIBUTES) {
            map.method_26867((class_1320)att.get());
        }
        map.method_26868((class_1320)ModAttributes.ATTACK_RANGE.get(), 1.5);
        return map;
    }

    protected void applyAttributes(boolean regenHealth) {
        if (this.data != null && this.data.baseStats() != null) {
            this.data.baseStats().forEach((att, d) -> {
                class_1324 inst = this.method_5996((class_1320)att);
                if (inst != null) {
                    inst.method_6192(d.doubleValue());
                    if (regenHealth && att == class_5134.field_23716) {
                        this.method_6033(this.method_6063());
                    }
                }
            });
            return;
        }
        class_1324 inst = this.method_5996(class_5134.field_23716);
        if (inst != null) {
            inst.method_6192(20.0);
            if (regenHealth) {
                this.method_6033(this.method_6063());
            }
        }
        if ((inst = this.method_5996(class_5134.field_23721)) != null) {
            inst.method_6192(1.0);
        }
        if ((inst = this.method_5996((class_1320)ModAttributes.DEFENCE.get())) != null) {
            inst.method_6192(0.0);
        }
        if ((inst = this.method_5996((class_1320)ModAttributes.MAGIC.get())) != null) {
            inst.method_6192(5.0);
        }
        if ((inst = this.method_5996((class_1320)ModAttributes.MAGIC_DEFENCE.get())) != null) {
            inst.method_6192(0.0);
        }
    }

    public void recalcStatsFull() {
        this.applyAttributes(true);
    }

    public void addGoal() {
        this.field_6185.method_6277(1, this.targetMobs);
        this.field_6185.method_6277(0, (class_1352)this.hurt);
        this.field_6201.method_6277(0, (class_1352)new NPCFindPOI(this));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(0, (class_1352)new class_4255((class_1308)this, true));
        this.field_6201.method_6277(0, new StayGoal<EntityNPCBase>(this, StayGoal.CANSTAYNPC));
        this.field_6201.method_6277(1, (class_1352)new AvoidWhenNotFollowing(this, class_1309.class, 8.0f, 1.3, 1.2));
        this.field_6201.method_6277(1, (class_1352)new LookAtInteractingPlayerGoal(this));
        this.field_6201.method_6277(2, (class_1352)new LookAtAliveGoal((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(3, (class_1352)new RandomLookGoalAlive((class_1308)this));
        this.field_6201.method_6277(2, new NPCAttackGoal<EntityNPCBase>(this));
        this.field_6201.method_6277(3, (class_1352)new NPCFollowGoal(this, 1.15, 9.0f, 3.0f, 20.0f));
        this.field_6201.method_6277(4, (class_1352)this.wander);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PLAY_DEATH_STATE, (Object)false);
        this.field_6011.method_12784(SHOP_SYNC, (Object)0);
        this.field_6011.method_12784(MALE, (Object)false);
        this.field_6011.method_12784(BEHAVIOUR_DATA, (Object)0);
    }

    public void method_5674(class_2940<?> key) {
        super.method_5674(key);
        if (this.field_6002.field_9236) {
            if (key.equals(SHOP_SYNC)) {
                try {
                    this.shop = ModNPCJobs.getFromSyncID((Integer)this.field_6011.method_12789(SHOP_SYNC));
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (key.equals(BEHAVIOUR_DATA)) {
                try {
                    this.behaviour = Behaviour.values()[(Integer)this.field_6011.method_12789(BEHAVIOUR_DATA)];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
        }
    }

    protected class_4095.class_5303<?> method_28306() {
        return class_4095.method_28311(MEMORY_TYPES, (Collection)ImmutableList.of());
    }

    protected class_1408 method_5965(class_1937 level) {
        class_1409 nav = new class_1409((class_1308)this, level){

            @Nullable
            protected class_11 method_35142(Set<class_2338> targets, int regionOffset, boolean offsetUpward, int accuracy) {
                return this.method_18416(targets, regionOffset, offsetUpward, accuracy, 100.0f);
            }

            protected class_13 method_6336(int i) {
                this.field_6678 = new NPCWalkNodeEvaluator();
                this.field_6678.method_15(true);
                return new class_13(this.field_6678, i);
            }
        };
        nav.method_6363(true);
        return nav;
    }

    public void method_5773() {
        if (this.field_5953 && this.method_5682() != null) {
            NPCHandler handler = WorldHandler.get((MinecraftServer)this.method_5682()).npcHandler;
            handler.addNPC(this);
            handler.playersToReset(this.method_5667()).forEach(pair -> this.relationManager.resetQuest((UUID)pair.getFirst(), (class_2960)pair.getSecond()));
        }
        super.method_5773();
        if (this.playDeath()) {
            this.playDeathTick = Math.min(15, ++this.playDeathTick);
            if (!this.field_6002.field_9236 && (double)this.method_6032() > 0.02) {
                this.setPlayDeath(false);
            }
        } else {
            this.playDeathTick = Math.max(0, --this.playDeathTick);
        }
        if (!this.field_6002.field_9236) {
            if (this.field_6012 % 10 == 0) {
                this.interactingPlayers.removeIf(p -> p.method_5858((class_1297)this) > 100.0);
            }
            --this.interactionMoveCooldown;
            this.updater.tick();
            this.updateActivity();
            this.foodBuffTick = Math.max(-1, --this.foodBuffTick);
            if (this.foodBuffTick == 0) {
                this.removeFoodEffect();
            }
            this.getAnimationHandler().runIfNotNull(this::handleAttack);
            --this.sleepCooldown;
            if (this.method_18398().map(pos -> !pos.method_19769((class_2374)this.method_19538(), 1.0) || this.getActivity() != class_4168.field_18597).orElse(false).booleanValue()) {
                this.method_18400();
            }
        }
        if (this.getAnimationHandler().getAnimation() == null) {
            this.targetPosition = null;
        }
    }

    public void method_6007() {
        this.method_6119();
        super.method_6007();
        this.getAnimationHandler().tick();
        this.weaponHandler.tick();
        boolean teleported = false;
        class_1937 class_19372 = this.field_6002;
        if (class_19372 instanceof class_3218) {
            class_1657 follow;
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.behaviourState().following && --this.tpCooldown <= 0 && (follow = this.followEntity()) != null) {
                serverLevel.method_14178().method_17297(WorldUtils.ENTITY_LOADER, this.method_31476(), 3, (Object)this.method_31476());
                if (follow.field_6002.method_27983() != this.field_6002.method_27983()) {
                    TeleportUtils.safeDimensionTeleport((class_1308)this, (class_3218)follow.field_6002, follow.method_24515());
                    teleported = true;
                    this.tpCooldown = 20;
                } else if (follow.method_5858((class_1297)this) > 450.0) {
                    TeleportUtils.tryTeleportAround((class_1308)this, (class_1297)follow);
                    teleported = true;
                    this.tpCooldown = 20;
                }
            }
            --this.procreationCooldown;
            if (this.procreationProgress > 0) {
                this.method_5942().method_6340();
                --this.procreationProgress;
                if (this.field_6012 % 10 == 0) {
                    serverLevel.method_14199((class_2394)class_2398.field_11201, this.method_23317(), this.method_23318() + (double)this.method_17682(), this.method_23321(), 0, 0.0, 0.0, 0.0, 0.0);
                }
                if (this.procreationProgress == 0) {
                    if (this.spawnBaby()) {
                        this.procreationCooldown = MobConfig.procreationCooldown;
                    }
                    this.procreationEntity = null;
                }
            }
        }
        if (this.playDeath()) {
            this.playDeathTick = Math.min(15, ++this.playDeathTick);
            if (!this.field_6002.field_9236) {
                if (teleported) {
                    this.method_6025(1.0f);
                }
                if ((double)this.method_6032() > 0.02) {
                    this.setPlayDeath(false);
                }
            }
        } else {
            this.playDeathTick = Math.max(0, --this.playDeathTick);
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        if (this.method_5682() != null) {
            this.getFamily().updateName((class_1297)this);
            WorldHandler.get((MinecraftServer)this.method_5682()).npcHandler.addNPC(this);
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!(player instanceof class_3222)) {
            return class_1269.field_21466;
        }
        class_3222 serverPlayer = (class_3222)player;
        if (this.method_6113()) {
            return class_1269.field_21466;
        }
        if (this.getEntityToFollowUUID() != null && this.getEntityToFollowUUID().equals(serverPlayer.method_5667())) {
            EntityUtils.sendAttributesTo((class_1309)this, serverPlayer);
        }
        Platform.INSTANCE.sendToClient(new S2CUpdateNPCData(this, this.relationManager.getFriendPointData(player.method_5667()).save()), serverPlayer);
        Platform.INSTANCE.sendToClient(new S2COpenNPCGui(this, serverPlayer), serverPlayer);
        this.interactWithPlayer(serverPlayer);
        this.method_5951((class_1297)serverPlayer, 30.0f, 30.0f);
        return class_1269.field_21466;
    }

    @Nullable
    public class_1799 method_31480() {
        return SpawnEgg.fromType((class_1299)this.method_5864()).map(class_1799::new).orElse(class_1799.field_8037);
    }

    public void method_5711(byte id) {
        if (id == 14) {
            this.addParticlesAroundSelf((class_2394)class_2398.field_11211);
        } else if (id == 15) {
            this.addParticlesAroundSelf((class_2394)class_2398.field_11207);
        } else {
            super.method_5711(id);
        }
    }

    protected void addParticlesAroundSelf(class_2394 particleData) {
        for (int i = 0; i < 5; ++i) {
            double d = this.field_5974.nextGaussian() * 0.02;
            double e = this.field_5974.nextGaussian() * 0.02;
            double f = this.field_5974.nextGaussian() * 0.02;
            this.field_6002.method_8406(particleData, this.method_23322(1.0), this.method_23319() + 1.0, this.method_23325(1.0), d, e, f);
        }
    }

    public void giftItem(class_1657 player, class_1799 stack) {
        class_1304 slot;
        class_3414 sound;
        this.method_5951((class_1297)player, 30.0f, 30.0f);
        int count = stack.method_7947();
        switch (stack.method_7976()) {
            case field_8946: {
                class_3414 class_34142 = stack.method_21832();
                break;
            }
            case field_8950: {
                class_3414 class_34142 = stack.method_21833();
                break;
            }
            default: {
                class_3414 class_34142 = sound = class_3417.field_14622;
            }
        }
        if (stack.method_7909() == ModItems.DIVORCE_PAPER.get()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                FamilyEntry family = this.getFamily();
                if (player.method_5667().equals(family.getPartner())) {
                    this.speak(serverPlayer, ConversationContext.DIVORCE);
                    family.updateRelationship(FamilyEntry.Relationship.NONE, null);
                    this.relationManager.getFriendPointData((UUID)player.method_5667()).points.addXP(-2000.0f, 10, LevelCalc::friendPointsForNext, () -> {});
                } else {
                    this.speak(serverPlayer, ConversationContext.DIVORCE_ERROR);
                }
                stack.method_7934(1);
            }
            return;
        }
        if (stack.method_7909() == ModItems.LOVE_LETTER.get()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                FamilyHandler families = FamilyHandler.get(this.method_5682());
                FamilyEntry playerEntry = families.getOrCreateEntry((class_1657)serverPlayer);
                FamilyEntry family = families.getOrCreateEntry(this);
                boolean success = false;
                if (playerEntry.getRelationship() != FamilyEntry.Relationship.NONE || family.getRelationship() != FamilyEntry.Relationship.NONE) {
                    this.speak(serverPlayer, ConversationContext.DATING_DENY);
                } else {
                    float chance;
                    float f = chance = this.friendPoints(player) >= 7 ? 0.33f * (float)(this.friendPoints(player) - 6) : 0.0f;
                    if (chance > 0.0f && this.updater.getDailyRandom().nextFloat() < chance) {
                        this.speak(serverPlayer, ConversationContext.DATING_ACCEPT);
                        family.updateRelationship(FamilyEntry.Relationship.DATING, player.method_5667());
                        success = true;
                    } else {
                        this.speak(serverPlayer, ConversationContext.DATING_DENY);
                    }
                }
                if (!success) {
                    player.method_7270(stack);
                } else {
                    stack.method_7934(1);
                }
            }
            return;
        }
        if (stack.method_7909() == ModItems.ENGAGEMENT_RING.get()) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                FamilyHandler families = FamilyHandler.get(this.method_5682());
                FamilyEntry playerEntry = families.getOrCreateEntry((class_1657)serverPlayer);
                FamilyEntry family = families.getOrCreateEntry(this);
                boolean success = false;
                if (playerEntry.getRelationship() != FamilyEntry.Relationship.NONE && !this.method_5667().equals(playerEntry.getPartner()) || family.getPartner() == null || !family.getPartner().equals(player.method_5667())) {
                    this.speak(serverPlayer, ConversationContext.MARRIAGE_DENY);
                } else if (family.getRelationship() == FamilyEntry.Relationship.DATING) {
                    float chance;
                    float f = chance = this.friendPoints(player) >= 10 ? 0.2f * (float)(this.friendPoints(player) - 9) : 0.0f;
                    if (chance > 0.0f && this.relationManager.getCompletedQuests(player.method_5667()).containsAll(this.data.questHandler().requiredQuests()) && this.updater.getDailyRandom().nextFloat() < chance) {
                        this.speak(serverPlayer, ConversationContext.MARRIAGE_ACCEPT);
                        family.updateRelationship(FamilyEntry.Relationship.MARRIED, player.method_5667());
                        success = true;
                        this.procreationCooldown = MobConfig.initialProcreationCooldown;
                    } else {
                        this.speak(serverPlayer, ConversationContext.MARRIAGE_DENY);
                    }
                }
                if (!success) {
                    player.method_7270(stack);
                } else {
                    stack.method_7934(1);
                }
            }
            return;
        }
        float mult = 1.0f;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            WorldHandler handler = WorldHandler.get(serverPlayer.method_5682());
            if (handler.currentSeason() == this.birthday.getFirst() && handler.date() == ((Integer)this.birthday.getSecond()).intValue()) {
                mult = 3.0f;
            }
            serverPlayer.field_13987.method_14364((class_2596)new class_2767(sound, class_3419.field_15254, player.method_23317(), player.method_23318(), player.method_23321(), 0.7f, 1.0f));
        }
        if ((slot = ItemUtils.slotOf(stack)) != class_1304.field_6173 || ItemNBT.isWeapon(stack) || stack.method_7909() instanceof class_1829 || stack.method_7909() instanceof class_1743) {
            class_1799 copy = stack.method_7972();
            copy.method_7939(1);
            this.method_5673(slot, copy);
        }
        this.applyFoodEffect(stack);
        stack.method_7939(count);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            NPCData.Gift gift = this.giftOf(stack);
            if (gift != null) {
                if (this.relationManager.getFriendPointData(player.method_5667()).giftXP(this.field_6002, (int)((float)gift.xp() * mult))) {
                    this.tellDialogue(serverPlayer, null, null, (class_2561)new class_2588(gift.responseKey()), List.of());
                }
            } else if (this.relationManager.getFriendPointData(player.method_5667()).giftXP(this.field_6002, (int)(5.0f * mult))) {
                this.tellDialogue(serverPlayer, null, null, (class_2561)new class_2588(this.data.neutralGiftResponse()), List.of());
            }
        }
        stack.method_7934(1);
    }

    public void talkTo(class_3222 player) {
        ConversationContext ctx = ConversationContext.TALK;
        NPCFriendPoints fp = this.relationManager.getFriendPointData(player.method_5667());
        boolean talkedTo = fp.talked();
        boolean doGreet = fp.talkTo(this.field_6002, 15);
        if (!talkedTo) {
            ctx = ConversationContext.FIRST_TALK;
        } else if (doGreet) {
            ctx = ConversationContext.GREETING;
        }
        this.speak(player, ctx);
    }

    public void speak(class_3222 player, ConversationContext convCtx) {
        int heart = this.relationManager.getFriendPointData((UUID)player.method_5667()).points.getLevel();
        ConversationSet conversations = this.data.getConversation(convCtx);
        class_47 ctx = new class_47.class_48((class_3218)this.field_6002).method_311(this.field_5974).method_312(class_181.field_1226, (Object)this).method_312(class_181.field_24424, (Object)this.method_19538()).method_312(LootCtxParameters.UUID_CONTEXT, (Object)player.method_5667()).method_303(player.method_7292()).method_309(LootCtxParameters.NPC_INTERACTION);
        List filtered = conversations.conversations().entrySet().stream().filter(c -> {
            if (((ConversationSet.Conversation)c.getValue()).actions().stream().anyMatch(h -> h.action() == ConversationSet.ConversationAction.QUEST) && QuestHandler.questForExists(player, this) != null && !this.updater.alreadyAcceptedRandomquest(player)) {
                return false;
            }
            return ((ConversationSet.Conversation)c.getValue()).startingConversation() && ((ConversationSet.Conversation)c.getValue()).test(heart, ctx);
        }).collect(Collectors.toList());
        Collections.shuffle(filtered, this.updater.getDailyRandom());
        int size = Math.min(filtered.size(), 2 + this.updater.getDailyRandom().nextInt(2));
        if (size > 0) {
            Map.Entry randomLine = (Map.Entry)filtered.get(this.field_5974.nextInt(size));
            this.tellDialogue(player, convCtx, (String)randomLine.getKey(), (ConversationSet.Conversation)randomLine.getValue());
        } else {
            class_2588 dialog = conversations.missing() != null ? new class_2588(conversations.fallbackKey(), new Object[]{conversations.missing()}) : new class_2588(conversations.fallbackKey());
            this.tellDialogue(player, convCtx, null, (class_2561)dialog, List.of());
        }
    }

    public void respondToQuest(class_3222 player, class_2960 quest) {
        QuestHandler.getData(player).trigger(NPCTalkTracker.KEY, this);
        QuestState result = QuestHandler.checkCompletionQuest(player, this);
        int questState = this.relationManager.questStateFor(player.method_5667(), quest);
        QuestConversationContext questCtx = QuestConversationContext.NOT_STARTED;
        if (questState != -1) {
            questCtx = QuestConversationContext.IN_PROGRESS;
            if (result == QuestState.COMPLETE) {
                this.relationManager.endQuest(player.method_5667(), quest);
                questState = -2;
                questCtx = QuestConversationContext.COMPLETED;
            } else if (result == QuestState.PARTIAL_COMPLETE) {
                questState = this.relationManager.advanceQuest(player.method_5667(), quest);
                questCtx = QuestConversationContext.NOT_STARTED;
            }
        } else {
            this.relationManager.advanceQuest(player.method_5667(), quest);
        }
        int heart = this.relationManager.getFriendPointData((UUID)player.method_5667()).points.getLevel();
        ConversationSet conversations = this.data.getFromQuest(quest, questCtx, questState);
        class_47 ctx = new class_47.class_48((class_3218)this.field_6002).method_311(this.field_5974).method_312(class_181.field_1226, (Object)this).method_312(class_181.field_24424, (Object)this.method_19538()).method_312(LootCtxParameters.UUID_CONTEXT, (Object)player.method_5667()).method_303(player.method_7292()).method_309(LootCtxParameters.NPC_INTERACTION);
        List filtered = conversations.conversations().entrySet().stream().filter(c -> ((ConversationSet.Conversation)c.getValue()).startingConversation() && ((ConversationSet.Conversation)c.getValue()).test(heart, ctx)).collect(Collectors.toList());
        Collections.shuffle(filtered, this.updater.getDailyRandom());
        int size = Math.min(filtered.size(), 2 + this.updater.getDailyRandom().nextInt(2));
        if (size > 0) {
            Map.Entry randomLine = (Map.Entry)filtered.get(this.field_5974.nextInt(size));
            this.tellDialogue(player, null, (String)randomLine.getKey(), (ConversationSet.Conversation)randomLine.getValue());
        } else {
            class_2588 dialog = conversations.missing() != null ? new class_2588(conversations.fallbackKey(), new Object[]{conversations.missing()}) : new class_2588(conversations.fallbackKey());
            this.tellDialogue(player, null, null, (class_2561)dialog, List.of());
        }
    }

    private void tellDialogue(class_3222 player, ConversationContext convCtx, String conversationID, ConversationSet.Conversation conversation) {
        List<class_2561> actions = conversation.actions().stream().map(e -> new class_2588(e.translationKey())).toList();
        this.tellDialogue(player, convCtx, conversationID, (class_2561)new class_2588(conversation.translationKey()), actions);
    }

    private void tellDialogue(class_3222 player, ConversationContext convCtx, String conversationID, class_2561 component, List<class_2561> actions) {
        this.interactWithPlayer(player);
        Platform.INSTANCE.sendToClient(new S2CNpcDialogue(this.method_5628(), convCtx, conversationID, component, this.conversationData(player), actions), player);
    }

    private Map<String, class_2561> conversationData(class_3222 player) {
        HashMap<String, class_2561> map = new HashMap<String, class_2561>();
        map.put(PlaceHolderComponent.NPC, this.method_5476());
        map.put(PlaceHolderComponent.PLAYER, player.method_5476());
        this.randomGiftContext(15, Integer.MAX_VALUE).ifPresent(comp -> map.put(PlaceHolderComponent.FAVORITE, (class_2561)comp));
        this.randomGiftContext(7, 14).ifPresent(comp -> map.put(PlaceHolderComponent.LIKE, (class_2561)comp));
        this.randomGiftContext(-14, -1).ifPresent(comp -> map.put(PlaceHolderComponent.DISLIKE, (class_2561)comp));
        this.randomGiftContext(Integer.MIN_VALUE, -15).ifPresent(comp -> map.put(PlaceHolderComponent.HATE, (class_2561)comp));
        return map;
    }

    public void handleDialogueAction(class_3222 sender, ConversationContext convCtx, String conversationID, int actionIdx) {
        ConversationSet.ConversationActionHolder action;
        ConversationSet conversations = this.data.getConversation(convCtx);
        ConversationSet.Conversation conversation = conversations.conversations().get(conversationID);
        if (conversation != null && actionIdx < conversation.actions().size() && (action = conversation.actions().get(actionIdx)) != null) {
            switch (action.action()) {
                case ANSWER: {
                    ConversationSet.Conversation answer = conversations.conversations().get(action.actionValue());
                    if (answer == null) break;
                    this.relationManager.getFriendPointData(sender.method_5667()).answer(conversationID, action.friendXP());
                    this.tellDialogue(sender, convCtx, action.actionValue(), answer);
                    break;
                }
                case QUEST: {
                    QuestHandler.acceptQuestRandom(sender, this, new class_2960(action.actionValue()));
                }
            }
        }
    }

    public void closedDialogue(class_3222 sender) {
        this.decreaseInteractingPlayers(sender);
    }

    public void closedQuestDialogue(class_3222 sender) {
        this.closedDialogue(sender);
        class_2960 quest = QuestHandler.questForExists(sender, this);
        if (quest != null && this.relationManager.questStateFor(sender.method_5667(), quest) == -2) {
            QuestHandler.getData(sender).submit(this);
        }
    }

    public void resetQuestProcess(class_3222 player, class_2960 quest) {
        this.relationManager.resetQuest(player.method_5667(), quest);
    }

    public void completeNPCQuest(class_3222 player, NPCQuest quest) {
        this.relationManager.completeQuest(player.method_5667(), quest.getOriginID());
    }

    public boolean canAcceptNPCQuest(class_3222 player, NPCQuest quest) {
        return this.relationManager.getCompletedQuests(player.method_5667()).containsAll(quest.neededParentQuests);
    }

    @Nullable
    public FamilyEntry getFamily() {
        if (this.method_5682() != null) {
            return FamilyHandler.get(this.method_5682()).getOrCreateEntry(this);
        }
        return null;
    }

    @Nullable
    public class_1657 getPartner() {
        FamilyEntry family = this.getFamily();
        if (family != null && family.getPartner() != null && family.hasPlayerRelationShip()) {
            return this.method_5682().method_3760().method_14602(family.getPartner());
        }
        return null;
    }

    public FamilyEntry.Relationship relationFor(UUID player) {
        FamilyEntry entry = this.getFamily();
        if (entry != null && player.equals(entry.getPartner())) {
            return entry.getRelationship();
        }
        return FamilyEntry.Relationship.NONE;
    }

    public boolean method_6121(class_1297 entity) {
        return EntityNPCBase.attack((class_1309)this, entity);
    }

    public static boolean attack(class_1309 attacker, class_1297 target) {
        class_1799 stack = attacker.method_6047();
        CustomDamage.Builder source = new CustomDamage.Builder((class_1297)attacker).hurtResistant(0).element(ItemNBT.getElement(stack));
        return CombatUtils.mobAttack(attacker, target, source);
    }

    @Override
    public LevelExpPair level() {
        return this.levelPair;
    }

    @Override
    public void setLevel(int level) {
        this.level().setLevel(class_3532.method_15340((int)level, (int)1, (int)10000), LevelCalc::xpAmountForLevelUp);
        this.updateStatsToLevel();
    }

    public void increaseLevel() {
        this.level().setLevel(class_3532.method_15340((int)(this.level().getLevel() + 1), (int)1, (int)10000), LevelCalc::xpAmountForLevelUp);
        this.updateStatsToLevel();
    }

    public void addXp(float amount) {
        boolean res = this.level().addXP(amount, 10000, LevelCalc::xpAmountForLevelUp, () -> {});
        Platform.INSTANCE.sendToTrackingAndSelf(S2CEntityLevelPkt.create(this), (class_1297)this);
        if (res) {
            this.updateStatsToLevel();
        }
    }

    public void updateStatsToLevel() {
        float multiplier;
        if (!this.field_6002.field_9236) {
            Platform.INSTANCE.sendToTrackingAndSelf(S2CEntityLevelPkt.create(this), (class_1297)this);
        }
        float preHealthDiff = this.method_6063() - this.method_6032();
        ((AttributeMapAccessor)this.method_6127()).getAttributes().forEach((att, inst) -> inst.method_6200(LibConstants.ATTRIBUTE_LEVEL_MOD));
        if (this.data != null) {
            Map<class_1320, Double> gain = this.data.statIncrease() != null ? this.data.statIncrease() : NPCData.DEFAULT_GAIN;
            gain.forEach((att, val) -> {
                val = val * 0.01;
                class_1324 inst = this.method_5996((class_1320)att);
                if (inst != null) {
                    float multiplier = 1.0f;
                    multiplier = att == class_5134.field_23716 ? (multiplier += LevelCalc.getMultiplierInterval(this.level().getLevel(), 20, 30.0f, 0.12f) * 0.015f) : (multiplier += LevelCalc.getMultiplierInterval(this.level().getLevel(), 20, 30.0f, 0.0f) * 0.01f);
                    inst.method_26837(new class_1322(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - 1) * val * (double)multiplier, class_1322.class_1323.field_6328));
                    if (att == class_5134.field_23716) {
                        this.method_6033(this.method_6063() - preHealthDiff);
                    }
                }
            });
            return;
        }
        int levelOffset = 1;
        class_1324 inst2 = this.method_5996(class_5134.field_23716);
        if (inst2 != null) {
            multiplier = 1.0f;
            inst2.method_26837(new class_1322(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - levelOffset) * 5.0 * (double)multiplier, class_1322.class_1323.field_6328));
            this.method_6033(this.method_6063() - preHealthDiff);
        }
        if ((inst2 = this.method_5996(class_5134.field_23721)) != null) {
            multiplier = 1.0f;
            inst2.method_26837(new class_1322(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - levelOffset) * 2.0 * (double)multiplier, class_1322.class_1323.field_6328));
        }
        if ((inst2 = this.method_5996((class_1320)ModAttributes.DEFENCE.get())) != null) {
            multiplier = 1.0f;
            inst2.method_26837(new class_1322(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - levelOffset) * 2.0 * (double)multiplier, class_1322.class_1323.field_6328));
        }
        if ((inst2 = this.method_5996((class_1320)ModAttributes.MAGIC.get())) != null) {
            multiplier = 1.0f;
            inst2.method_26837(new class_1322(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - levelOffset) * 2.0 * (double)multiplier, class_1322.class_1323.field_6328));
        }
        if ((inst2 = this.method_5996((class_1320)ModAttributes.MAGIC_DEFENCE.get())) != null) {
            multiplier = 1.0f;
            inst2.method_26837(new class_1322(LibConstants.ATTRIBUTE_LEVEL_MOD, "runecraftory.levelMod", (double)(this.level().getLevel() - levelOffset) * 2.0 * (double)multiplier, class_1322.class_1323.field_6328));
        }
    }

    @Override
    public int friendPoints(UUID uuid) {
        return this.relationManager.getFriendPointData((UUID)uuid).points.getLevel();
    }

    public int talkCount(UUID uuid) {
        return this.relationManager.getFriendPointData(uuid).getTalkCount();
    }

    public void updateFriendPointsFrom(class_1657 player, class_2487 tag) {
        this.relationManager.getFriendPointData(player.method_5667()).load(tag);
    }

    @Override
    public int baseXP() {
        return 0;
    }

    @Override
    public int baseMoney() {
        return 0;
    }

    @Override
    public boolean applyFoodEffect(class_1799 stack) {
        FoodProperties food;
        if (this.field_6002.field_9236) {
            return false;
        }
        if (stack.method_7909() == ModItems.OBJECT_X.get()) {
            ItemObjectX.applyEffect((class_1309)this, stack);
        }
        if ((food = DataPackHandler.INSTANCE.foodManager().get(stack.method_7909())) == null) {
            class_4174 mcFood = stack.method_7909().method_19264();
            this.method_18866(this.field_6002, stack);
            if (mcFood != null) {
                this.method_6025((float)mcFood.method_19230() * 0.5f);
                return true;
            }
            return false;
        }
        this.method_18866(this.field_6002, stack);
        Pair<Map<class_1320, Double>, Map<class_1320, Double>> foodStats = ItemNBT.foodStats(stack);
        if (!((Map)foodStats.getFirst()).isEmpty() || !((Map)foodStats.getSecond()).isEmpty()) {
            class_1324 inst;
            this.removeFoodEffect();
            for (Map.Entry entry : ((Map)foodStats.getSecond()).entrySet()) {
                inst = this.method_5996((class_1320)entry.getKey());
                if (inst == null) continue;
                inst.method_6200(LibConstants.FOOD_UUID_MULTI);
                inst.method_26837(new class_1322(LibConstants.FOOD_UUID_MULTI, "foodBuffMulti_" + ((class_1320)entry.getKey()).method_26830(), ((Double)entry.getValue()).doubleValue(), class_1322.class_1323.field_6330));
            }
            for (Map.Entry entry : ((Map)foodStats.getFirst()).entrySet()) {
                inst = this.method_5996((class_1320)entry.getKey());
                if (inst == null) continue;
                inst.method_6200(LibConstants.FOOD_UUID);
                inst.method_26837(new class_1322(LibConstants.FOOD_UUID, "foodBuff_" + ((class_1320)entry.getKey()).method_26830(), ((Double)entry.getValue()).doubleValue(), class_1322.class_1323.field_6328));
            }
            this.foodBuffTick = food.duration();
        }
        EntityUtils.foodHealing((class_1309)this, food.getHPGain());
        EntityUtils.foodHealing((class_1309)this, this.method_6063() * (float)food.getHpPercentGain() * 0.01f);
        if (food.potionHeals() != null) {
            for (class_1291 class_12912 : food.potionHeals()) {
                this.method_6016(class_12912);
            }
        }
        if (food.potionApply() != null) {
            for (SimpleEffect simpleEffect : food.potionApply()) {
                this.method_6092(simpleEffect.create());
            }
        }
        return true;
    }

    @Override
    public void removeFoodEffect() {
        ((AttributeMapAccessor)this.method_6127()).getAttributes().values().forEach(inst -> {
            inst.method_6200(LibConstants.FOOD_UUID);
            inst.method_6200(LibConstants.FOOD_UUID_MULTI);
        });
    }

    @Override
    public boolean onGivingItem(class_1657 player, class_1799 stack) {
        this.giftItem(player, stack);
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    public void method_6078(class_1282 cause) {
        RuneCraftory.LOGGER.info("NPC {} died, message: '{}'", (Object)this, (Object)cause.method_5506((class_1309)this).getString());
        if (!this.field_6002.field_9236) {
            this.getAnimationHandler().setAnimation(null);
        }
        super.method_6078(cause);
    }

    public void method_31744(class_5569 levelCallback) {
        super.method_31744(WorldUtils.wrappedCallbackFor(this, this::followEntity, levelCallback));
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.releasePOI(this.getBedPos());
        this.releasePOI(this.getWorkPlace());
        this.releasePOI(this.getMeetingPos());
        super.method_5650(reason);
        if (this.method_5682() != null) {
            NPCHandler handler = WorldHandler.get((MinecraftServer)this.method_5682()).npcHandler;
            if (reason.method_31486() && this.data != null && this.data.unique() > 0) {
                handler.removeUniqueNPC(this.method_5667(), this.data);
            }
            handler.removeNPC(this, reason);
        }
    }

    protected void method_6108() {
        super.method_6108();
    }

    public boolean playDeath() {
        return (Boolean)this.field_6011.method_12789(PLAY_DEATH_STATE);
    }

    public void setPlayDeath(boolean flag) {
        this.field_6011.method_12778(PLAY_DEATH_STATE, (Object)flag);
        if (flag) {
            class_1657 partner;
            if (!this.field_6002.field_9236 && this.field_6002.method_8450().method_8355(class_1928.field_19398) && this.followEntity() == null && (partner = this.getPartner()) instanceof class_3222) {
                partner.method_9203(this.getKnockoutMessage(), class_156.field_25140);
            }
            this.field_6002.method_18023(class_5575.method_31795(class_1308.class), this.method_5829().method_1014(32.0), e -> this.equals(e.method_5968())).forEach(m -> m.method_5980(null));
            this.method_5942().method_6340();
            this.method_5660(false);
            this.method_5728(false);
            this.method_18375();
        } else {
            this.getAnimationHandler().setAnimation(null);
        }
    }

    private class_2561 getKnockoutMessage() {
        class_1282 source = this.method_6081();
        if (source instanceof class_1285 && source.method_5529() != null) {
            return new class_2588("runecraftory.tamed.monster.knockout.by", new Object[]{this.method_5476(), this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260(), source.method_5529().method_5476()});
        }
        return new class_2588("runecraftory.tamed.monster.knockout", new Object[]{this.method_5476(), this.method_24515().method_10263(), this.method_24515().method_10264(), this.method_24515().method_10260()});
    }

    public int getPlayDeathTick() {
        return this.playDeathTick;
    }

    public boolean method_33190() {
        return super.method_33190() && !this.playDeath();
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 follow;
        if (this.playDeath() && source != class_1282.field_5849) {
            return false;
        }
        if (this.followEntity() != null && source.method_5529() != null && ((follow = this.followEntity()).equals((Object)source.method_5529()) || Platform.INSTANCE.getPlayerData(follow).map(d -> d.party.isPartyMember(source.method_5529())).orElse(false).booleanValue())) {
            return false;
        }
        return super.method_5643(source, amount);
    }

    protected void method_6074(class_1282 damageSrc, float damageAmount) {
        FamilyEntry family;
        super.method_6074(damageSrc, damageAmount);
        if (damageSrc != class_1282.field_5849 && this.method_6032() <= 0.0f && (this.followEntity() != null || (family = this.getFamily()) != null && family.getPartner() != null && FamilyHandler.get(this.method_5682()).getFamily(family.getPartner()).map(FamilyEntry::isPlayer).orElse(false).booleanValue())) {
            this.method_6033(0.01f);
            this.setPlayDeath(true);
        }
    }

    protected boolean method_6062() {
        return super.method_6062() || this.method_5782() || this.playDeath();
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10566("MobLevel", (class_2520)this.level().save());
        compound.method_10569("FoodBuffTick", this.foodBuffTick);
        compound.method_10556("PlayDeath", ((Boolean)this.field_6011.method_12789(PLAY_DEATH_STATE)).booleanValue());
        compound.method_10566("RelationManager", (class_2520)this.relationManager.save());
        if (this.entityToFollowUUID != null) {
            compound.method_25927("EntityToFollow", this.entityToFollowUUID);
        }
        compound.method_10569("Behaviour", this.behaviourState().ordinal());
        compound.method_10566("NPCData", (class_2520)this.saveNPCData());
        compound.method_10566("DailyUpdater", (class_2520)this.updater.save());
        compound.method_10569("ProcreationCooldown", this.procreationCooldown);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.levelPair.read((class_2520)compound.method_10562("MobLevel"));
        this.foodBuffTick = compound.method_10550("FoodBuffTick");
        this.setPlayDeath(compound.method_10577("PlayDeath"));
        this.relationManager.load(compound.method_10562("RelationManager"));
        if (compound.method_25928("EntityToFollow")) {
            this.entityToFollowUUID = compound.method_25926("EntityToFollow");
        }
        try {
            this.setBehaviour(Behaviour.values()[compound.method_10550("Behaviour")]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (compound.method_10545("NPCData")) {
            this.loadNpcData(compound.method_10562("NPCData"));
        }
        this.updater.read(compound.method_10562("DailyUpdater"));
        this.procreationCooldown = compound.method_10550("ProcreationCooldown");
    }

    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 reason, @Nullable class_1315 spawnData, @Nullable class_2487 dataTag) {
        if (!this.ignoreInit) {
            this.randomizeData(null, true);
        }
        return super.method_5943(level, difficulty, reason, spawnData, dataTag);
    }

    public void handleAttack(AnimatedAction anim) {
        this.method_5942().method_6340();
    }

    public void npcAttack(Consumer<class_1309> cons) {
        this.attackableEntites().forEach(cons);
    }

    public List<class_1309> attackableEntites() {
        class_1799 held = this.method_6047();
        class_1792 class_17922 = held.method_7909();
        if (class_17922 instanceof IAOEWeapon) {
            IAOEWeapon weapon = (IAOEWeapon)class_17922;
            return RayTraceUtils.getEntitiesIn((class_1309)this, (OrientedBoundingBox)weapon.attackOBB((class_1309)this, held, false), (boolean)true, (class_5575)class_5575.method_31795(class_1309.class), this.hitPred);
        }
        class_1309 target = this.method_5968();
        if (target == null) {
            return List.of();
        }
        double range = this.method_33191(target);
        if (this.method_5649(target.method_23317(), target.method_23318(), target.method_23321()) <= range) {
            return List.of(target);
        }
        return List.of();
    }

    public double method_33191(class_1309 target) {
        double reachSqr;
        class_1799 held = this.method_6047();
        if (held.method_7909() instanceof IAOEWeapon) {
            reachSqr = this.method_26825((class_1320)ModAttributes.ATTACK_RANGE.get()) - 0.3 + (double)target.method_17681() * 0.5;
            reachSqr *= reachSqr;
        } else {
            class_1792 class_17922 = held.method_7909();
            if (class_17922 instanceof IExtendedWeapon) {
                IExtendedWeapon weapon = (IExtendedWeapon)class_17922;
                float weaponRange = weapon.getRange((class_1309)this, held);
                reachSqr = (double)weaponRange + (double)target.method_17681() * 0.5;
                reachSqr *= reachSqr;
            } else {
                reachSqr = super.method_33191(target);
            }
        }
        return reachSqr;
    }

    public void method_18403(class_2338 pos) {
        if (this.sleepCooldown <= 0) {
            super.method_18403(pos);
        }
    }

    public void method_18400() {
        super.method_18400();
        this.sleepCooldown = 60;
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverLevel, class_1296 ageableMob) {
        return null;
    }

    public AnimationHandler<?> getAnimationHandler() {
        return this.animationHandler;
    }

    public boolean method_18410() {
        return super.method_18410() && this.getEntityToFollowUUID() == null;
    }

    public class_4048 method_18377(class_4050 pose) {
        SizeFeatureType.SizeFeature feat = (SizeFeatureType.SizeFeature)this.lookFeatures.getFeature((NPCFeatureType)((Object)ModNPCLooks.SIZE.get()));
        if (feat != null) {
            return super.method_18377(pose).method_18383(feat.size);
        }
        return super.method_18377(pose);
    }

    public NPCJob getShop() {
        return this.shop;
    }

    public void setShop(NPCJob shop) {
        this.shop = shop;
        if (!this.field_6002.field_9236) {
            this.field_6011.method_12778(SHOP_SYNC, (Object)ModNPCJobs.getSyncIDFrom(shop));
        }
    }

    public boolean isShopDefined() {
        return !this.data.profession().isEmpty();
    }

    public boolean updateActivity() {
        class_1937 class_19372;
        if (this.field_6012 % 20 == 0 && (class_19372 = this.field_6002) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.interactingPlayers.isEmpty()) {
                class_4168 prev = this.activity;
                this.activity = this.getActivityForTime(serverLevel);
                if (this.activity == ModActivities.EARLYIDLE.get() && this.getBedPos() != null && this.getBedPos().method_19442() == this.field_6002.method_27983()) {
                    if (!this.method_18412().equals((Object)this.getBedPos().method_19446())) {
                        this.prevRestriction = this.method_18412();
                        this.prevRestrictionRadius = (int)this.method_18413();
                        this.method_18408(this.getBedPos().method_19446(), 10);
                    }
                } else if (this.prevRestrictionRadius >= 0) {
                    this.method_18408(this.prevRestriction, this.prevRestrictionRadius);
                    this.prevRestriction = class_2338.field_10980;
                    this.prevRestrictionRadius = -1;
                }
                return prev != this.activity;
            }
        }
        return false;
    }

    public void syncActivity(class_2487 tag) {
        if (this.field_6002.field_9236) {
            this.schedule.load(tag);
        }
    }

    public class_4168 getActivity() {
        return this.activity;
    }

    public class_4168 getActivityForTime(class_3218 serverLevel) {
        return this.schedule.getActivity(serverLevel);
    }

    public NPCSchedule getSchedule() {
        return this.schedule;
    }

    public class_4208 getWorkPlace() {
        return this.method_18868().method_18904(class_4140.field_18439).orElse(null);
    }

    public void setWorkPlace(class_4208 pos) {
        if (pos != null) {
            this.field_6002.method_8421((class_1297)this, (byte)15);
        }
        this.method_18868().method_18878(class_4140.field_18439, (Object)pos);
    }

    public class_4208 getBedPos() {
        return this.method_18868().method_18904(class_4140.field_18438).orElse(null);
    }

    public void setBedPos(class_4208 pos) {
        if (pos != null) {
            this.field_6002.method_8421((class_1297)this, (byte)14);
        }
        this.method_18868().method_18878(class_4140.field_18438, (Object)pos);
    }

    public class_4208 getMeetingPos() {
        return this.method_18868().method_18904(class_4140.field_18440).orElse(null);
    }

    public void setMeetingPos(class_4208 pos) {
        this.method_18868().method_18878(class_4140.field_18440, (Object)pos);
    }

    public ShopState canTrade() {
        if (this.method_6109() || !this.shop.hasShop && !this.shop.hasWorkSchedule) {
            return ShopState.NOTWORKER;
        }
        if (!this.shop.hasWorkSchedule) {
            return ShopState.OPEN;
        }
        if (this.getWorkPlace() == null) {
            return ShopState.NOWORKPLACE;
        }
        if (this.getBedPos() == null) {
            return ShopState.NOBED;
        }
        if (this.getActivity() != class_4168.field_18596) {
            return ShopState.CLOSED;
        }
        if (!this.nearWorkPlace(this.getWorkPlace(), 4)) {
            return ShopState.TOOFAR;
        }
        return ShopState.OPEN;
    }

    public boolean nearWorkPlace(class_4208 pos, int range) {
        if (this.followEntity() == null) {
            if (this.field_6002.method_27983() != pos.method_19442()) {
                return false;
            }
            return pos.method_19446().method_19769((class_2374)this.method_19538(), (double)range);
        }
        return false;
    }

    public void releasePOI(class_4208 globalPos) {
        class_3218 serverLevel;
        if (globalPos == null) {
            return;
        }
        class_3218 class_32182 = serverLevel = globalPos.method_19442() != this.field_6002.method_27983() ? this.field_6002.method_8503().method_3847(globalPos.method_19442()) : (class_3218)this.field_6002;
        if (serverLevel == null) {
            return;
        }
        class_4153 poiManager = serverLevel.method_19494();
        if (poiManager.method_19116(globalPos.method_19446(), p -> true)) {
            poiManager.method_19129(globalPos.method_19446());
            class_4209.method_19778((class_3218)serverLevel, (class_2338)globalPos.method_19446());
        }
    }

    public class_1657 followEntity() {
        if (!(this.entityToFollowUUID == null || this.entityToFollow != null && this.entityToFollow.method_5805())) {
            this.entityToFollow = this.field_6002.field_9236 ? this.field_6002.method_18470(this.entityToFollowUUID) : this.field_6002.method_8503().method_3760().method_14602(this.entityToFollowUUID);
        }
        return this.entityToFollow;
    }

    public UUID getEntityToFollowUUID() {
        return this.entityToFollowUUID;
    }

    public boolean followEntity(class_3222 player) {
        if (player == null) {
            this.setBehaviour(Behaviour.WANDER);
        }
        if (player != null) {
            float chance;
            FamilyEntry family = this.getFamily();
            int points = this.friendPoints((class_1657)player);
            float f = chance = points < 3 ? -0.1f + 0.1f * (float)points : 0.5f + 0.15f * (float)points;
            if (!player.method_7337() && family != null && family.hasPlayerRelationShip() && !family.getPartner().equals(player.method_5667()) && this.updater.getDailyRandom().nextFloat() < chance) {
                this.speak(player, ConversationContext.FOLLOW_NO);
                return false;
            }
            this.speak(player, ConversationContext.FOLLOW_YES);
            this.entityToFollowUUID = player.method_5667();
        } else {
            class_1657 class_16572 = this.followEntity();
            if (class_16572 instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)class_16572;
                this.speak(serverPlayer, ConversationContext.FOLLOW_STOP);
            }
            this.entityToFollowUUID = null;
        }
        this.entityToFollow = player;
        if (player != null) {
            this.setBehaviour(Behaviour.FOLLOW);
        }
        return true;
    }

    public void setBehaviour(Behaviour behaviour) {
        this.field_6011.method_12778(BEHAVIOUR_DATA, (Object)behaviour.ordinal());
        this.behaviour = behaviour;
        if (!this.field_6002.field_9236) {
            this.onSetBehaviour();
        }
    }

    private void onSetBehaviour() {
        if (this.behaviourState().following) {
            if (this.followEntity() != null) {
                Platform.INSTANCE.getPlayerData(this.followEntity()).ifPresent(d -> d.party.addPartyMember((class_1297)this));
            }
        } else {
            if (this.followEntity() != null) {
                Platform.INSTANCE.getPlayerData(this.followEntity()).ifPresent(d -> d.party.removePartyMember((class_1297)this));
            }
            this.method_5980(null);
        }
        this.method_5942().method_6340();
    }

    public Behaviour behaviourState() {
        return this.behaviour;
    }

    public boolean isStaying() {
        return !this.interactingPlayers.isEmpty() || this.interactionMoveCooldown > 0 || this.behaviourState() == Behaviour.STAY;
    }

    public void interactWithPlayer(class_3222 player) {
        this.interactingPlayers.add(player);
        this.method_5942().method_6340();
    }

    public void decreaseInteractingPlayers(class_3222 player) {
        this.interactingPlayers.remove(player);
        this.interactionMoveCooldown = 40;
    }

    public class_3222 getLastInteractedPlayer() {
        if (this.interactingPlayers.isEmpty()) {
            return null;
        }
        return this.interactingPlayers.get(this.interactingPlayers.size() - 1);
    }

    public boolean procreateWith(class_1297 other) {
        FamilyEntry family = this.getFamily();
        if (family == null || !family.getPartner().equals(other.method_5667()) || this.procreationProgress > 0) {
            return false;
        }
        if (!this.canProcreate()) {
            if (other instanceof class_3222) {
                class_3222 player = (class_3222)other;
                this.speak(player, ConversationContext.PROCREATION_COOLDOWN);
            }
            return false;
        }
        this.procreationProgress = 60;
        this.procreationEntity = other;
        return true;
    }

    public void tryUpdateName(class_2561 component) {
        if (this.data.name() == null) {
            this.method_5665(component);
        }
    }

    public boolean hasDataName() {
        return this.data.name() != null;
    }

    public boolean canProcreate() {
        return this.procreationCooldown < 0;
    }

    private boolean spawnBaby() {
        UUID mother;
        UUID father;
        class_1937 class_19372 = this.field_6002;
        if (!(class_19372 instanceof class_3218)) {
            return false;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        EntityNPCBase baby = (EntityNPCBase)((class_1299)ModEntities.NPC.get()).method_5888(serverLevel, null, null, null, this.method_24515(), class_3730.field_16466, false, false);
        if (baby == null) {
            return false;
        }
        baby.method_7217(true);
        ArrayList<class_2960> childIDs = new ArrayList<class_2960>(this.data.possibleChildren());
        NPCDataManager manager = DataPackHandler.INSTANCE.npcDataManager();
        class_1297 class_12972 = this.procreationEntity;
        if (class_12972 instanceof EntityNPCBase) {
            EntityNPCBase npc = (EntityNPCBase)class_12972;
            childIDs.addAll(npc.data.possibleChildren());
        }
        childIDs.removeIf(r -> !manager.has((class_2960)r));
        if (childIDs.isEmpty()) {
            baby.randomizeData(null, true);
        } else {
            baby.setLevel(1);
            baby.setNPCData(DataPackHandler.INSTANCE.npcDataManager().get((class_2960)childIDs.get(this.field_5974.nextInt(childIDs.size()))), false);
        }
        if (this.isMale()) {
            father = this.method_5667();
            mother = this.getFamily().getPartner();
        } else {
            mother = this.method_5667();
            father = this.getFamily().getPartner();
        }
        class_1297 class_12973 = this.procreationEntity;
        if (class_12973 instanceof class_3222) {
            class_3222 player = (class_3222)class_12973;
            player.method_7270(BabySpawnEgg.createBabyFrom(baby, player.method_5477(), father, mother));
        } else {
            baby.getFamily().setFather(father);
            baby.getFamily().setMother(mother);
            serverLevel.method_8649((class_1297)baby);
        }
        return true;
    }

    public boolean isMale() {
        return (Boolean)this.field_6011.method_12789(MALE);
    }

    public void setMale(boolean flag) {
        this.field_6011.method_12778(MALE, (Object)flag);
    }

    public NPCLook getLook() {
        if (this.look == null) {
            if (this.data == NPCData.DEFAULT_DATA) {
                this.look = NPCLook.DEFAULT_LOOK;
            } else {
                List looks = this.data.look() == null ? List.of() : this.data.look().stream().filter(e -> e.gender() == NPCData.Gender.UNDEFINED || e.gender() == NPCData.Gender.MALE == this.isMale()).map(NPCData.NPCLookId::id).toList();
                this.look = !looks.isEmpty() ? DataPackHandler.INSTANCE.npcLookManager().get((class_2960)looks.get(this.field_5974.nextInt(looks.size()))) : DataPackHandler.INSTANCE.npcLookManager().getRandom(this.field_5974, this.isMale());
            }
        }
        return this.look;
    }

    public NPCAttackActions getAttackActions() {
        if (this.attackActions == null) {
            if (this.data == NPCData.DEFAULT_DATA) {
                this.attackActions = NPCAttackActions.DEFAULT;
            } else {
                List<class_2960> actions = this.data.combatActions();
                this.attackActions = DataPackHandler.INSTANCE.npcActionsManager().get(actions.isEmpty() ? null : actions.get(this.field_5974.nextInt(actions.size())));
            }
        }
        return this.attackActions;
    }

    public Pair<EnumSeason, Integer> getBirthday() {
        if (this.birthday == null) {
            if (this.data == NPCData.DEFAULT_DATA) {
                this.birthday = Pair.of((Object)((Object)EnumSeason.SPRING), (Object)1);
            } else if (this.data.birthday() != null) {
                this.birthday = this.data.birthday();
            } else {
                EnumSeason randSeason = EnumSeason.values()[this.field_5974.nextInt(EnumSeason.values().length)];
                int day = this.field_5974.nextInt(30) + 1;
                this.birthday = Pair.of((Object)((Object)randSeason), (Object)day);
            }
        }
        return this.birthday;
    }

    public void setClientLook(NPCLook look) {
        if (this.field_6002.field_9236) {
            this.look = look;
            this.method_18382();
        }
    }

    public NPCData.Gift giftOf(class_1799 stack) {
        this.calcGifts();
        for (Map.Entry<String, NPCData.Gift> e : this.data.giftItems().entrySet()) {
            if (!this.gifts.get(e.getKey()).is(stack)) continue;
            return e.getValue();
        }
        return null;
    }

    protected Optional<class_2561> randomGiftContext(int min, int max) {
        this.calcGifts();
        ArrayList gifts = new ArrayList();
        this.data.giftItems().forEach((key, gift) -> {
            if (gift.xp() >= min && gift.xp() <= max) {
                gifts.add(this.gifts.get(key));
            }
        });
        if (gifts.isEmpty()) {
            return Optional.empty();
        }
        GiftData gift2 = (GiftData)gifts.get(this.updater.getDailyRandom().nextInt(gifts.size()));
        return Optional.of(new class_2588(gift2.translation(this.updater.getDailyRandom())));
    }

    private void calcGifts() {
        if (this.gifts == null) {
            ImmutableMap.Builder b = ImmutableMap.builder();
            this.data.giftItems().forEach((s, g) -> {
                GiftData giftData;
                GiftData giftData2 = giftData = g.giftID() == null ? DataPackHandler.INSTANCE.giftManager().getRandomGift(this.updater.getDailyRandom(), g.xp()) : DataPackHandler.INSTANCE.giftManager().get(g.giftID());
                if (giftData != null) {
                    b.put(s, (Object)giftData);
                }
            });
            this.gifts = b.build();
        }
    }

    public void openShopForPlayer(class_3222 player) {
        if (this.canTrade() == ShopState.OPEN) {
            this.interactWithPlayer(player);
            Platform.INSTANCE.getPlayerData((class_1657)player).map(d -> {
                if (this.getShop().hasShop) {
                    return d.getShop(this.getShop());
                }
                return null;
            }).ifPresent(shopList -> Platform.INSTANCE.openGuiMenu(player, new class_3908(){
                final /* synthetic */ class_2371 val$shopList;
                {
                    this.val$shopList = class_23712;
                }

                public class_2561 method_5476() {
                    return new class_2588(EntityNPCBase.this.getShop().getTranslationKey());
                }

                @Nullable
                public class_1703 createMenu(int i, class_1661 inventory, class_1657 player) {
                    return new ContainerShop(i, inventory, new InventoryShop(EntityNPCBase.this, (class_2371<class_1799>)this.val$shopList));
                }
            }, buf -> {
                buf.writeInt(this.method_5628());
                buf.writeInt(shopList.size());
                shopList.forEach(s -> buf.method_29172(class_1799.field_24671, s));
            }));
        }
    }

    public void randomizeData(@Nullable class_2960 job) {
        this.randomizeData(ModNPCJobs.getFromID(job), false);
    }

    public void randomizeData(NPCJob job, boolean overwrite) {
        if (this.method_5682() != null) {
            this.setNPCData(DataPackHandler.INSTANCE.npcDataManager().getRandom(this.field_5974, d -> (d.profession().isEmpty() || d.profession().stream().anyMatch(j -> j.equals(job))) && WorldHandler.get((MinecraftServer)this.method_5682()).npcHandler.canAssignNPC((NPCData)d), job == null ? null : d -> d.profession().stream().anyMatch(j -> j.equals(job))), !overwrite);
            if (job != null) {
                this.setShop(job);
            }
        }
    }

    public class_2960 getDataID() {
        return DataPackHandler.INSTANCE.npcDataManager().getId(this.data);
    }

    public void setNPCData(NPCData data, boolean load) {
        if (this.method_5682() != null) {
            if (this.data != null) {
                WorldHandler.get((MinecraftServer)this.method_5682()).npcHandler.removeUniqueNPC(this.method_5667(), this.data);
            }
            WorldHandler.get((MinecraftServer)this.method_5682()).npcHandler.addUniqueNPC(this.method_5667(), data);
        }
        this.data = data;
        this.dataRandom.setSeed(this.method_5667().hashCode());
        if (!load) {
            this.setShop(!this.data.profession().isEmpty() ? this.data.profession().get(this.dataRandom.nextInt(this.data.profession().size())) : ModNPCJobs.getRandomJob(this.field_5974));
            this.setMale(this.data.gender() == NPCData.Gender.UNDEFINED ? this.field_5974.nextBoolean() : this.data.gender() != NPCData.Gender.FEMALE);
            if (this.data.name() == null) {
                String name = DataPackHandler.INSTANCE.nameManager().getRandomFullName(this.field_5974, this.isMale());
                if (name != null) {
                    this.method_5665((class_2561)new class_2585(name));
                }
            } else {
                Object name = this.data.name();
                if (this.data.surname() != null) {
                    name = (String)name + " " + this.data.surname();
                }
                this.method_5665((class_2561)new class_2585((String)name));
            }
            this.birthday = null;
            this.getBirthday();
            this.look = null;
            this.getLook();
            this.attackActions = null;
            this.getAttackActions();
            if (data.schedule() == null) {
                this.schedule.load(new NPCSchedule(this, this.field_5974).save());
            } else {
                this.schedule.with(data.schedule());
            }
            this.lookFeatures.buildFromLooks(this, this.look.additionalFeatures().values());
            this.gifts = null;
            this.calcGifts();
        } else {
            if (this.data.look() != null && !this.data.look().isEmpty()) {
                this.look = null;
                this.getLook();
            }
            if (!this.data.profession().isEmpty() && !this.data.profession().contains(this.getShop())) {
                this.setShop(!this.data.profession().isEmpty() ? this.data.profession().get(this.dataRandom.nextInt(this.data.profession().size())) : ModNPCJobs.getRandomJob(this.field_5974));
            }
            if (this.data.gender() != NPCData.Gender.UNDEFINED && this.data.gender() == NPCData.Gender.MALE != this.isMale()) {
                this.setMale(this.data.gender() == NPCData.Gender.UNDEFINED ? this.field_5974.nextBoolean() : this.data.gender() != NPCData.Gender.FEMALE);
            }
            if (this.data.name() != null) {
                Object name = this.data.name();
                if (this.data.surname() != null) {
                    name = (String)name + " " + this.data.surname();
                }
                this.method_5665((class_2561)new class_2585((String)name));
            }
            if (this.data.birthday() != null) {
                this.birthday = null;
                this.getBirthday();
            }
            if (this.data.combatActions() != null && !this.data.combatActions().isEmpty()) {
                this.attackActions = null;
            }
            if (data.schedule() != null) {
                this.schedule.with(data.schedule());
            }
        }
        this.applyAttributes(!load);
        if (this.level().getLevel() < this.data.baseLevel()) {
            this.setLevel(this.data.baseLevel());
        }
        this.method_18382();
        if (!this.field_6002.field_9236) {
            Platform.INSTANCE.sendToTrackingAndSelf(new S2CNPCLook(this.method_5628(), this.look, this.lookFeatures), (class_1297)this);
        }
    }

    private class_2487 saveNPCData() {
        class_2487 tag = new class_2487();
        tag.method_10582("Data", DataPackHandler.INSTANCE.npcDataManager().getId(this.data).toString());
        tag.method_10582("Look", DataPackHandler.INSTANCE.npcLookManager().getId(this.getLook()).toString());
        tag.method_10582("Profession", ModNPCJobs.getIDFrom(this.getShop()).toString());
        tag.method_10556("Male", this.isMale());
        tag.method_10569("BirthdayMonth", ((EnumSeason)((Object)this.getBirthday().getFirst())).ordinal());
        tag.method_10569("Birthday", ((Integer)this.getBirthday().getSecond()).intValue());
        tag.method_10582("Combat", DataPackHandler.INSTANCE.npcActionsManager().getId(this.getAttackActions()).toString());
        tag.method_10566("Schedule", (class_2520)this.schedule.save());
        tag.method_10566("LookFeatures", (class_2520)this.lookFeatures.save());
        class_2487 gifts = new class_2487();
        this.gifts.forEach((s, g) -> gifts.method_10582(s, DataPackHandler.INSTANCE.giftManager().getId((GiftData)g).toString()));
        tag.method_10566("GiftData", (class_2520)gifts);
        return tag;
    }

    private void loadNpcData(class_2487 tag) {
        NPCData data = DataPackHandler.INSTANCE.npcDataManager().get(new class_2960(tag.method_10558("Data")));
        this.look = DataPackHandler.INSTANCE.npcLookManager().get(new class_2960(tag.method_10558("Look")));
        this.setShop(ModNPCJobs.getFromID(new class_2960(tag.method_10558("Profession"))));
        this.setMale(tag.method_10577("Male"));
        try {
            EnumSeason month = EnumSeason.values()[tag.method_10550("BirthdayMonth")];
            this.birthday = Pair.of((Object)((Object)month), (Object)tag.method_10550("Birthday"));
        }
        catch (IllegalArgumentException e) {
            this.getBirthday();
        }
        this.attackActions = DataPackHandler.INSTANCE.npcActionsManager().get(new class_2960(tag.method_10558("Combat")));
        this.schedule.load(tag.method_10562("Schedule"));
        try {
            this.lookFeatures.read(tag.method_10562("LookFeatures"));
        }
        catch (Exception e) {
            this.lookFeatures.buildFromLooks(this, this.look.additionalFeatures().values());
        }
        class_2487 gifts = tag.method_10562("GiftData");
        ImmutableMap.Builder b = ImmutableMap.builder();
        gifts.method_10541().forEach(key -> {
            GiftData giftData = DataPackHandler.INSTANCE.giftManager().get(new class_2960(gifts.method_10558(key)));
            if (giftData != null) {
                b.put(key, (Object)giftData);
            }
        });
        this.gifts = b.build();
        this.setNPCData(data, true);
    }

    public void method_5837(class_3222 player) {
        Platform.INSTANCE.sendToClient(new S2CNPCLook(this.method_5628(), this.look, this.lookFeatures), player);
        Platform.INSTANCE.sendToClient(S2CEntityLevelPkt.create(this), player);
    }

    @Override
    public Predicate<class_1309> validTargetPredicate() {
        return this.hitPred;
    }

    @Override
    public MobAttackExt.TargetPosition getTargetPosition() {
        return this.targetPosition;
    }

    public static enum Behaviour {
        WANDER("runecraftory.npc.interact.home", false),
        FOLLOW("runecraftory.npc.interact.follow", true),
        FOLLOW_DISTANCE("runecraftory.npc.interact.follow.distance", true),
        STAY("runecraftory.npc.interact.stay", true);

        public final String interactKey;
        public final boolean following;

        private Behaviour(String interactKey, boolean following) {
            this.interactKey = interactKey;
            this.following = following;
        }
    }
}

