/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc;

import io.github.flemmli97.runecraftory.api.action.AttackActionHandler;
import io.github.flemmli97.runecraftory.api.action.ComboContainer;
import io.github.flemmli97.runecraftory.api.action.DataKey;
import io.github.flemmli97.runecraftory.api.registry.AttackAction;
import io.github.flemmli97.runecraftory.api.registry.Spell;
import io.github.flemmli97.runecraftory.common.registry.ModAttackActions;
import io.github.flemmli97.tenshilib.api.entity.AnimatedAction;
import io.github.flemmli97.tenshilib.api.entity.IAnimated;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

public class EntityWeaponHandler<T extends class_1309>
implements AttackActionHandler {
    private final T entity;
    private AttackAction currentAction = (AttackAction)((Object)ModAttackActions.NONE.get());
    private int comboCount;
    private final Set<class_1309> hitEntityTracker = new HashSet<class_1309>();
    private boolean scheduledAction;
    private final Map<DataKey<?>, Object> dataMap = new HashMap();

    public EntityWeaponHandler(T entity) {
        this.entity = entity;
    }

    @Override
    public class_1309 getEntity() {
        return this.entity;
    }

    @Override
    public boolean doWeaponAttack(AttackAction action, class_1799 stack, @Nullable Spell spell) {
        AttackAction.OverrideType overrideType = this.checkOverride(action, true);
        if (!((class_1309)this.entity).field_6002.field_9236 && overrideType != AttackAction.OverrideType.NONE) {
            if (overrideType == AttackAction.OverrideType.SCHEDULE) {
                this.scheduledAction = true;
                return true;
            }
            action.onSetup((class_1309)this.entity, this);
            this.setAnimationBasedOnState(action, -1);
            this.store(DataKey.USED_WEAPON, stack);
            this.store(DataKey.USED_SPELL, spell);
            return true;
        }
        return false;
    }

    private AttackAction.OverrideType checkOverride(AttackAction action, boolean allowNone) {
        if (allowNone && (this.currentAction == ModAttackActions.NONE.get() || this.getAnimation() == null)) {
            return AttackAction.OverrideType.REPLACE;
        }
        if (this.entity.method_5854() != null && !action.usableOnMounts(this.comboCount + 1)) {
            return AttackAction.OverrideType.NONE;
        }
        if (this.currentAction == action && action.combos() != null) {
            ComboContainer.ComboHandler combo = action.combos().get(this.comboCount - 1);
            return combo != null && combo.canExecute().test(this) ? AttackAction.OverrideType.SCHEDULE : AttackAction.OverrideType.NONE;
        }
        return AttackAction.OverrideType.NONE;
    }

    private void setAnimationBasedOnState(AttackAction action, int comboIdx) {
        AttackAction change = this.currentAction.onChange((class_1309)this.entity, this);
        if (change != null) {
            action = change;
        }
        if (comboIdx != -1) {
            this.comboCount = comboIdx;
        }
        if (action == ModAttackActions.NONE.get()) {
            this.resetStates();
        }
        this.currentAction = action;
        this.scheduledAction = false;
        AnimatedAction anim = action.getAnimation((class_1309)this.entity, this.getComboCount());
        if (this.currentAction != ModAttackActions.NONE.get()) {
            ++this.comboCount;
        }
        ((class_1309)this.entity).field_6283 = ((class_1309)this.entity).field_6241;
        this.resetHitEntityTracker();
        this.currentAction.onStart((class_1309)this.entity, this);
        if (!((class_1309)this.entity).field_6002.field_9236) {
            if (anim == null) {
                ((IAnimated)this.entity).getAnimationHandler().setAnimation(null);
            } else {
                ((IAnimated)this.entity).getAnimationHandler().setAnimation(anim, anim.getStartTransition(), anim.getEndTransitionTime(), anim.getTick(1.0f));
            }
        }
    }

    private void resetStates() {
        this.comboCount = 0;
        this.hitEntityTracker.clear();
        Set.copyOf(this.dataMap.keySet()).forEach(this::clear);
    }

    @Override
    public void tick() {
        if (this.currentAction != ModAttackActions.NONE.get()) {
            boolean changedItem;
            ComboContainer.ComboHandler handler = this.currentAction.combos() != null ? this.currentAction.combos().get(this.comboCount - 1) : null;
            class_1799 weapon = this.get(DataKey.USED_WEAPON);
            boolean bl = changedItem = this.entity.method_6047() != weapon;
            if (changedItem) {
                this.setAnimationBasedOnState((AttackAction)((Object)ModAttackActions.NONE.get()), -1);
                return;
            }
            if (this.getAnimation() == null) {
                this.setAnimationBasedOnState((AttackAction)((Object)ModAttackActions.NONE.get()), -1);
            } else {
                this.currentAction.run((class_1309)this.entity, weapon, this, this.getAnimation());
            }
            if (this.scheduledAction && handler != null && handler.canAdvance().test(this)) {
                this.setAnimationBasedOnState(this.currentAction, handler.advanceTo().get(this));
            }
        }
    }

    @Override
    public <T> void store(DataKey<T> key, T value) {
        this.dataMap.put(key, value);
    }

    @Override
    public <T> T get(DataKey<T> key) {
        return (T)this.dataMap.getOrDefault(key, key.defaultValue());
    }

    @Override
    public <T> void clearWith(DataKey<T> key, @Nullable Consumer<T> apply) {
        if (apply == null) {
            this.dataMap.remove(key);
        } else {
            apply.accept(this.dataMap.remove(key));
        }
    }

    @Override
    public AttackAction getCurrentAction() {
        return this.currentAction;
    }

    @Override
    public float getCurrentTransitionProgress(float partialTicks) {
        return ((IAnimated)this.entity).getAnimationHandler().getCurrentTransitionProgress(partialTicks);
    }

    @Override
    public float getLastTransitionProgress(float partialTicks) {
        return ((IAnimated)this.entity).getAnimationHandler().getLastTransitionProgress(partialTicks);
    }

    @Override
    public AnimatedAction getAnimation() {
        return ((IAnimated)this.entity).getAnimationHandler().getAnimation();
    }

    @Override
    public AnimatedAction getLastAnimation() {
        return ((IAnimated)this.entity).getAnimationHandler().getLastAnimation();
    }

    @Override
    public void setComboCount(int count) {
        this.comboCount = count;
    }

    @Override
    public int getComboCount() {
        return this.comboCount;
    }

    @Override
    public boolean isScheduledAction() {
        return this.scheduledAction;
    }

    @Override
    public Set<class_1309> getHitEntityTracker() {
        return this.hitEntityTracker;
    }
}

