/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureHolder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ColorSetting;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class BlushFeatureType
implements NPCFeatureHolder<BlushFeature> {
    public static Codec<BlushFeatureType> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.FLOAT.fieldOf("chance").forGetter(d -> Float.valueOf(d.chance)), (App)ColorSetting.CODEC.fieldOf("colors").forGetter(d -> d.setting)).apply((Applicative)inst, BlushFeatureType::new));
    private final float chance;
    private final ColorSetting setting;

    public BlushFeatureType(float chance, ColorSetting setting) {
        this.chance = chance;
        this.setting = setting;
    }

    @Override
    public BlushFeature create(EntityNPCBase npc) {
        return new BlushFeature(this.setting.getRandom(npc.method_6051()), npc.method_6051().nextFloat() < this.chance);
    }

    @Override
    public NPCFeatureType<BlushFeature> getType() {
        return (NPCFeatureType)((Object)ModNPCLooks.BLUSH.get());
    }

    public static class BlushFeature
    implements NPCFeature {
        public final boolean blush;
        public final int color;

        public BlushFeature(class_2540 buf) {
            this(buf.readInt(), buf.readBoolean());
        }

        public BlushFeature(class_2520 tag) {
            this(((class_2487)tag).method_10550("Color"), ((class_2487)tag).method_10577("Blush"));
        }

        public BlushFeature(int color, boolean blush) {
            this.color = color;
            this.blush = blush;
        }

        @Override
        public void writeToBuffer(class_2540 buf) {
            buf.writeInt(this.color);
            buf.writeBoolean(this.blush);
        }

        @Override
        public class_2520 save() {
            class_2487 tag = new class_2487();
            tag.method_10569("Color", this.color);
            tag.method_10556("Blush", this.blush);
            return tag;
        }

        @Override
        public NPCFeatureType<?> getType() {
            return (NPCFeatureType)((Object)ModNPCLooks.BLUSH.get());
        }
    }
}

