/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureHolder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_3532;

public record ColorSetting(List<Either<Integer, ColorRange>> colors) {
    public static final ColorSetting DEFAULT = new ColorSetting(List.of());
    public static final ColorSetting SKIN_COLOR_RANGE = new ColorSetting(List.of(Either.right((Object)new ColorRange(16706265, 16034187)), Either.right((Object)new ColorRange(15719370, 15507848)), Either.right((Object)new ColorRange(14008231, 12682070)), Either.right((Object)new ColorRange(10584941, 9721404)), Either.right((Object)new ColorRange(0x664F44, 5844505)), Either.right((Object)new ColorRange(3221798, 2888460))));
    public static final ColorSetting HAIR_COLOR_RANGE = new ColorSetting(List.of(Either.right((Object)new ColorRange(0, 0x161616)), Either.right((Object)new ColorRange(3282179, 6700324)), Either.right((Object)new ColorRange(14206993, 15854240)), Either.right((Object)new ColorRange(7669768, 0xC55252)), Either.right((Object)new ColorRange(12139171, 12811191)), Either.right((Object)new ColorRange(4014501, 7505874)), Either.right((Object)new ColorRange(0xFFFFFF, 14542327))));
    public static final ColorSetting EYE_COLOR_RANGE = new ColorSetting(List.of(Either.right((Object)new ColorRange(0, 0x2F2F2F)), Either.right((Object)new ColorRange(4598277, 7161632)), Either.right((Object)new ColorRange(731765, 2116231)), Either.right((Object)new ColorRange(4366860, 7323190)), Either.right((Object)new ColorRange(12168712, 14401345))));
    public static final ColorSetting EYEBROW_COLOR_RANGE = new ColorSetting(List.of(Either.right((Object)new ColorRange(3939589, 9269331))));
    public static final ColorSetting BLUSH_COLOR_RANGE = new ColorSetting(List.of(Either.right((Object)new ColorRange(14789096, 16109562))));
    public static final Codec<ColorSetting> CODEC = Codec.either(ColorRange.HEX_COLOR, ColorRange.CODEC).listOf().xmap(ColorSetting::new, ColorSetting::colors);

    public int getRandom(Random random) {
        if (this.colors.isEmpty()) {
            return 0xFFFFFF;
        }
        Either<Integer, ColorRange> rand = this.colors.get(random.nextInt(this.colors.size()));
        return (Integer)rand.map(i -> i, range -> range.getRandom(random));
    }

    public static NPCFeatureType<ColorSettingFeature> createSimple(final Supplier<NPCFeatureType<ColorSettingFeature>> type) {
        return new NPCFeatureType<ColorSettingFeature>(CODEC.xmap(s -> new ColorSettingFeatureType((ColorSetting)s, type), f -> f.setting), buf -> new ColorSettingFeature((class_2540)buf){

            @Override
            public NPCFeatureType<?> getType() {
                return (NPCFeatureType)((Object)type.get());
            }
        }, tag -> new ColorSettingFeature((class_2520)tag){

            @Override
            public NPCFeatureType<?> getType() {
                return (NPCFeatureType)((Object)type.get());
            }
        });
    }

    public static class ColorSettingFeatureType
    implements NPCFeatureHolder<ColorSettingFeature> {
        private final ColorSetting setting;
        private final Supplier<NPCFeatureType<ColorSettingFeature>> type;

        protected ColorSettingFeatureType(ColorSetting setting, Supplier<NPCFeatureType<ColorSettingFeature>> type) {
            this.setting = setting;
            this.type = type;
        }

        @Override
        public ColorSettingFeature create(EntityNPCBase npc) {
            return new ColorSettingFeature(this.setting.getRandom(npc.method_6051())){

                @Override
                public NPCFeatureType<?> getType() {
                    return type.get();
                }
            };
        }

        @Override
        public NPCFeatureType<ColorSettingFeature> getType() {
            return this.type.get();
        }
    }

    public record ColorRange(int colorMin, int colorMax) {
        public static Codec<Integer> HEX_COLOR = Codec.STRING.flatXmap(s -> {
            try {
                return DataResult.success((Object)Integer.parseInt(s, 16));
            }
            catch (NumberFormatException e) {
                return DataResult.error((String)("Could not parse color " + s));
            }
        }, i -> DataResult.success((Object)String.format("%06x", i)));
        public static final Codec<ColorRange> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)HEX_COLOR.fieldOf("color_min").forGetter(d -> d.colorMin), (App)HEX_COLOR.fieldOf("color_max").forGetter(d -> d.colorMax)).apply((Applicative)inst, ColorRange::new));

        static int randomRange(Random random, int first, int second) {
            if (first > second) {
                return class_3532.method_15395((Random)random, (int)second, (int)first);
            }
            return class_3532.method_15395((Random)random, (int)first, (int)second);
        }

        public int getRandom(Random random) {
            int red = ColorRange.randomRange(random, this.colorMin >> 16 & 0xFF, this.colorMax >> 16 & 0xFF);
            int green = ColorRange.randomRange(random, this.colorMin >> 8 & 0xFF, this.colorMax >> 8 & 0xFF);
            int blue = ColorRange.randomRange(random, this.colorMin & 0xFF, this.colorMax & 0xFF);
            return red << 16 | green << 8 | blue;
        }
    }

    public static abstract class ColorSettingFeature
    implements NPCFeature {
        public final int color;

        public ColorSettingFeature(class_2540 buf) {
            this(buf.readInt());
        }

        public ColorSettingFeature(class_2520 tag) {
            this(((class_2497)tag).method_10701());
        }

        public ColorSettingFeature(int color) {
            this.color = color;
        }

        @Override
        public void writeToBuffer(class_2540 buf) {
            buf.writeInt(this.color);
        }

        @Override
        public class_2520 save() {
            return class_2497.method_23247((int)this.color);
        }
    }
}

