/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureHolder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.features.HairFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.features.IndexedColorSetting;
import io.github.flemmli97.runecraftory.common.entities.npc.features.NPCFeatureContainer;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import org.jetbrains.annotations.Nullable;

public record FaceFeaturesType(IndexedColorSetting irisSetting, IndexedColorSetting scleraSetting, IndexedColorSetting eyebrowSetting, Map<String, ExpressionFeature> expressionMap) implements NPCFeatureHolder<FaceFeatures>
{
    public static final Codec<FaceFeaturesType> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)IndexedColorSetting.CODEC.fieldOf("iris").forGetter(d -> d.irisSetting), (App)IndexedColorSetting.CODEC.fieldOf("sclera").forGetter(d -> d.scleraSetting), (App)IndexedColorSetting.CODEC.fieldOf("eyebrow").forGetter(d -> d.eyebrowSetting), (App)Codec.unboundedMap((Codec)Codec.STRING, ExpressionFeature.CODEC).fieldOf("expressions").forGetter(d -> d.expressionMap)).apply((Applicative)inst, FaceFeaturesType::new));
    public static final Map<String, ExpressionFeature> DEFAULT_EXPRESSIONS = Map.of("eyes_closed", new ExpressionFeature(new TextureType("closed", true), new TextureType("closed", true), "closed"), "angry", new ExpressionFeature(TextureType.NONE, TextureType.NONE, "angry"));

    @Override
    public FaceFeatures create(EntityNPCBase npc) {
        return new FaceFeatures(this.irisSetting.resolve(npc.method_6051()), this.scleraSetting.resolve(npc.method_6051()), this.eyebrowSetting.resolve(npc.method_6051()), this.expressionMap);
    }

    @Override
    public NPCFeatureType<FaceFeatures> getType() {
        return (NPCFeatureType)((Object)ModNPCLooks.FACE.get());
    }

    public static class FaceFeatures
    implements NPCFeature {
        public final IndexedColorSetting.ResolvedIndexColor iris;
        public final IndexedColorSetting.ResolvedIndexColor sclera;
        public final IndexedColorSetting.ResolvedIndexColor eyebrow;
        public final Map<String, ExpressionFeature> expressionMap;

        public FaceFeatures(class_2540 buf) {
            this(new IndexedColorSetting.ResolvedIndexColor(buf), new IndexedColorSetting.ResolvedIndexColor(buf), new IndexedColorSetting.ResolvedIndexColor(buf), buf.method_34067(class_2540::method_19772, b -> new ExpressionFeature(new TextureType(b.method_19772(), b.readBoolean()), new TextureType(b.method_19772(), b.readBoolean()), b.method_19772())));
        }

        public FaceFeatures(class_2520 tag) {
            this(new IndexedColorSetting.ResolvedIndexColor(((class_2487)tag).method_10562("Iris")), new IndexedColorSetting.ResolvedIndexColor(((class_2487)tag).method_10562("Sclera")), new IndexedColorSetting.ResolvedIndexColor(((class_2487)tag).method_10562("Eyebrow")), FaceFeatures.fromTag(((class_2487)tag).method_10562("Expressions")));
        }

        public FaceFeatures(IndexedColorSetting.ResolvedIndexColor iris, IndexedColorSetting.ResolvedIndexColor sclera, IndexedColorSetting.ResolvedIndexColor eyebrow, Map<String, ExpressionFeature> expressionMap) {
            this.iris = iris;
            this.sclera = sclera;
            this.eyebrow = eyebrow;
            this.expressionMap = expressionMap;
        }

        private static Map<String, ExpressionFeature> fromTag(class_2487 tag) {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            tag.method_10541().forEach(k -> {
                class_2487 expTag = tag.method_10562(k);
                builder.put(k, (Object)new ExpressionFeature(new TextureType(expTag.method_10558("IrisSuffix"), expTag.method_10577("IrisColor")), new TextureType(expTag.method_10558("ScleraSuffix"), expTag.method_10577("ScleraColor")), expTag.method_10558("Eyebrow")));
            });
            return builder.build();
        }

        @Nullable
        public String expressionTexture(NPCFeatureContainer features, String expression, ExpressionType type) {
            FaceFeatures feat = (FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
            ExpressionFeature exp = feat.expressionMap.get(expression);
            if (exp != null) {
                return switch (type) {
                    default -> throw new IncompatibleClassChangeError();
                    case ExpressionType.IRIS -> exp.iris().suffix();
                    case ExpressionType.SCLERA -> exp.sclera().suffix();
                    case ExpressionType.EYEBROWS -> exp.eyebrow();
                };
            }
            return null;
        }

        public boolean useSkinColor(NPCFeatureContainer features, String expression, ExpressionType type) {
            if (type == ExpressionType.EYEBROWS) {
                return false;
            }
            FaceFeatures feat = (FaceFeatures)features.getFeature((NPCFeatureType)((Object)ModNPCLooks.FACE.get()));
            ExpressionFeature exp = feat.expressionMap.get(expression);
            if (exp != null) {
                if (type == ExpressionType.IRIS) {
                    return exp.iris().useSkinColor();
                }
                return exp.sclera().useSkinColor();
            }
            return false;
        }

        @Override
        public void writeToBuffer(class_2540 buf) {
            this.iris.writeToBuffer(buf);
            this.sclera.writeToBuffer(buf);
            this.eyebrow.writeToBuffer(buf);
            buf.method_34063(this.expressionMap, class_2540::method_10814, (b, exp) -> {
                b.method_10814(exp.iris.suffix());
                b.writeBoolean(exp.iris.useSkinColor());
                b.method_10814(exp.sclera.suffix());
                b.writeBoolean(exp.sclera.useSkinColor());
                b.method_10814(exp.eyebrow);
            });
        }

        @Override
        public class_2520 save() {
            class_2487 tag = new class_2487();
            tag.method_10566("Iris", (class_2520)this.iris.save());
            tag.method_10566("Sclera", (class_2520)this.sclera.save());
            tag.method_10566("Eyebrow", (class_2520)this.eyebrow.save());
            class_2487 expMap = new class_2487();
            this.expressionMap.forEach((s, e) -> {
                class_2487 expTag = new class_2487();
                expTag.method_10582("IrisSuffix", e.iris.suffix());
                expTag.method_10556("IrisColor", e.iris.useSkinColor());
                expTag.method_10582("ScleraSuffix", e.sclera.suffix());
                expTag.method_10556("ScleraColor", e.iris.useSkinColor());
                expTag.method_10582("Eyebrow", e.eyebrow);
                expMap.method_10566(s, (class_2520)expTag);
            });
            tag.method_10566("Expressions", (class_2520)expMap);
            return tag;
        }

        public NPCFeatureType<HairFeatureType.HairFeature> getType() {
            return (NPCFeatureType)((Object)ModNPCLooks.HAIR.get());
        }
    }

    public record ExpressionFeature(TextureType iris, TextureType sclera, String eyebrow) {
        public static final Codec<ExpressionFeature> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TextureType.CODEC.fieldOf("iris").forGetter(d -> d.iris), (App)TextureType.CODEC.fieldOf("sclera").forGetter(d -> d.sclera), (App)Codec.STRING.fieldOf("eyebrow").forGetter(d -> d.eyebrow)).apply((Applicative)inst, ExpressionFeature::new));
    }

    public record TextureType(String suffix, boolean useSkinColor) {
        public static TextureType NONE = new TextureType("", false);
        public static final Codec<TextureType> CODEC = Codec.either((Codec)Codec.STRING, (Codec)RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("suffix").forGetter(d -> d.suffix), (App)Codec.BOOL.fieldOf("use_skin_color").forGetter(d -> d.useSkinColor)).apply((Applicative)inst, TextureType::new))).xmap(e -> (TextureType)e.map(s -> new TextureType((String)s, false), t -> t), t -> !t.useSkinColor ? Either.left((Object)t.suffix()) : Either.right((Object)t));
    }

    public static enum ExpressionType {
        IRIS,
        SCLERA,
        EYEBROWS;

    }
}

