/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureHolder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.entities.npc.features.ColorSetting;
import io.github.flemmli97.runecraftory.common.entities.npc.features.TypedIndexRange;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public record HairFeatureType(TypedIndexRange types, ColorSetting color) implements NPCFeatureHolder<HairFeature>
{
    public static final Codec<HairFeatureType> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)TypedIndexRange.CODEC.fieldOf("styles").forGetter(d -> d.types), (App)ColorSetting.CODEC.fieldOf("colors").forGetter(d -> d.color)).apply((Applicative)inst, HairFeatureType::new));

    @Override
    public HairFeature create(EntityNPCBase npc) {
        Pair<String, Integer> style = this.types.getRandom(npc.method_6051());
        return new HairFeature((String)style.getFirst(), (Integer)style.getSecond(), this.color.getRandom(npc.method_6051()));
    }

    @Override
    public NPCFeatureType<HairFeature> getType() {
        return (NPCFeatureType)((Object)ModNPCLooks.HAIR.get());
    }

    public static class HairFeature
    implements NPCFeature {
        public final String type;
        public final int index;
        public final int color;

        public HairFeature(class_2540 buf) {
            this(buf.method_19772(), buf.readInt(), buf.readInt());
        }

        public HairFeature(class_2520 tag) {
            this(((class_2487)tag).method_10558("Type"), ((class_2487)tag).method_10550("Index"), ((class_2487)tag).method_10550("Color"));
        }

        public HairFeature(String type, int index, int color) {
            this.type = type;
            this.index = index;
            this.color = color;
        }

        @Override
        public void writeToBuffer(class_2540 buf) {
            buf.method_10814(this.type);
            buf.writeInt(this.index);
            buf.writeInt(this.color);
        }

        @Override
        public class_2520 save() {
            class_2487 tag = new class_2487();
            tag.method_10582("Type", this.type);
            tag.method_10569("Index", this.index);
            tag.method_10569("Color", this.color);
            return tag;
        }

        public NPCFeatureType<HairFeature> getType() {
            return (NPCFeatureType)((Object)ModNPCLooks.HAIR.get());
        }
    }
}

