/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.runecraftory.common.entities.npc.features;

import io.github.flemmli97.runecraftory.api.registry.NPCFeature;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureHolder;
import io.github.flemmli97.runecraftory.api.registry.NPCFeatureType;
import io.github.flemmli97.runecraftory.common.entities.npc.EntityNPCBase;
import io.github.flemmli97.runecraftory.common.registry.ModNPCLooks;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class NPCFeatureContainer {
    private final Map<NPCFeatureType<?>, NPCFeature> map = new HashMap();
    public final Map<NPCFeatureType<?>, NPCFeature> view = Collections.unmodifiableMap(this.map);

    public <T extends NPCFeature> T getFeature(NPCFeatureType<T> type) {
        return (T)this.map.get(type);
    }

    public void buildFromLooks(EntityNPCBase npc, Collection<NPCFeatureHolder<?>> features) {
        this.map.clear();
        features.forEach(feat -> this.map.put(feat.getType(), (NPCFeature)feat.create(npc)));
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        this.map.forEach((type, feat) -> {
            class_2520 save = feat.save();
            tag.method_10566(type.getRegistryName().toString(), (class_2520)(save == null ? class_2497.method_23247((int)0) : save));
        });
        return tag;
    }

    public NPCFeatureContainer read(class_2487 tag) {
        this.map.clear();
        tag.method_10541().forEach(key -> {
            NPCFeatureType t = (NPCFeatureType)((Object)((Object)ModNPCLooks.NPC_FEATURE_REGISTRY.get().getFromId(new class_2960(key))));
            this.map.put(t, (NPCFeature)t.load.apply(tag.method_10580(key)));
        });
        return this;
    }

    public void toBuffer(class_2540 buf) {
        buf.writeInt(this.map.size());
        this.map.forEach((type, feat) -> {
            buf.method_10812(type.getRegistryName());
            feat.writeToBuffer(buf);
        });
    }

    public NPCFeatureContainer fromBuffer(class_2540 buf) {
        this.map.clear();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            NPCFeatureType t = (NPCFeatureType)((Object)ModNPCLooks.NPC_FEATURE_REGISTRY.get().getFromId(buf.method_10810()));
            this.map.put(t, (NPCFeature)t.pkt.apply(buf));
        }
        return this;
    }

    public void with(NPCFeatureContainer other) {
        this.map.clear();
        this.map.putAll(other.map);
    }
}

